/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.integration.sqs.core.consumer;

import com.katanox.tabour.config.EventHandlerProperties;
import com.katanox.tabour.config.EventPollerProperties;
import com.katanox.tabour.exception.ExceptionHandler;
import com.katanox.tabour.integration.sqs.config.SqsConfiguration;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventFetcher;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventHandler;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventHandlerRegistryKt;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventPoller;
import com.katanox.tabour.thread.ThreadPools;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import mu.KLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020&R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventHandlerRegistry;", "", "eventHandlers", "", "Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventHandler;", "eventHandlerProperties", "Lcom/katanox/tabour/config/EventHandlerProperties;", "eventPollerProperties", "Lcom/katanox/tabour/config/EventPollerProperties;", "sqsConfiguration", "Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;", "(Ljava/util/List;Lcom/katanox/tabour/config/EventHandlerProperties;Lcom/katanox/tabour/config/EventPollerProperties;Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;)V", "getEventHandlerProperties", "()Lcom/katanox/tabour/config/EventHandlerProperties;", "setEventHandlerProperties", "(Lcom/katanox/tabour/config/EventHandlerProperties;)V", "getEventPollerProperties", "()Lcom/katanox/tabour/config/EventPollerProperties;", "setEventPollerProperties", "(Lcom/katanox/tabour/config/EventPollerProperties;)V", "pollers", "", "Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventPoller;", "getSqsConfiguration", "()Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;", "setSqsConfiguration", "(Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;)V", "createFetcherForHandler", "Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventFetcher;", "registration", "createHandlerThreadPool", "Ljava/util/concurrent/ThreadPoolExecutor;", "createPollerForHandler", "createPollingThreadPool", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "initializePollers", "registrations", "start", "", "stop", "tabour"})
public final class SqsEventHandlerRegistry {
    private Set<SqsEventPoller> pollers;
    @NotNull
    private EventHandlerProperties eventHandlerProperties;
    @NotNull
    private EventPollerProperties eventPollerProperties;
    @NotNull
    private SqsConfiguration sqsConfiguration;

    private final Set<SqsEventPoller> initializePollers(List<? extends SqsEventHandler> registrations) {
        Set pollers = new HashSet();
        for (SqsEventHandler sqsEventHandler : registrations) {
            pollers.add(this.createPollerForHandler(sqsEventHandler));
            KLogger kLogger = SqsEventHandlerRegistryKt.access$getLogger$p();
            sqsEventHandler.getClass();
            kLogger.info("initialized SqsMessagePoller '{}'", (Object)"getCanonicalName");
        }
        return pollers;
    }

    private final SqsEventPoller createPollerForHandler(SqsEventHandler registration) {
        registration.getClass();
        return new SqsEventPoller("getCanonicalName", registration, this.createFetcherForHandler(registration), this.createPollingThreadPool(registration), this.createHandlerThreadPool(registration), this.eventPollerProperties, this.sqsConfiguration, ExceptionHandler.Companion.defaultExceptionHandler());
    }

    private final SqsEventFetcher createFetcherForHandler(SqsEventHandler registration) {
        return new SqsEventFetcher(registration.getSqsQueueUrl(), this.sqsConfiguration, this.eventPollerProperties);
    }

    private final ScheduledThreadPoolExecutor createPollingThreadPool(SqsEventHandler registration) {
        int n = new EventPollerProperties(null, null, null, 0, 0, 31, null).getPollingThreads();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s-poller";
        Object[] objectArray = new Object[1];
        registration.getClass();
        objectArray[0] = "getCanonicalName";
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return ThreadPools.INSTANCE.blockingScheduledThreadPool(n, string2);
    }

    private final ThreadPoolExecutor createHandlerThreadPool(SqsEventHandler registration) {
        int n = this.eventHandlerProperties.getThreadPoolSize();
        int n2 = this.eventHandlerProperties.getQueueSize();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s-handler";
        Object[] objectArray = new Object[1];
        registration.getClass();
        objectArray[0] = "getCanonicalName";
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return ThreadPools.INSTANCE.blockingThreadPool(n, n2, string2);
    }

    public final void start() {
        Set<SqsEventPoller> set = this.pollers;
        Intrinsics.checkNotNull(set);
        for (SqsEventPoller poller : set) {
            poller.start();
        }
    }

    public final void stop() {
        Set<SqsEventPoller> set = this.pollers;
        Intrinsics.checkNotNull(set);
        for (SqsEventPoller poller : set) {
            poller.stop();
        }
    }

    @NotNull
    public final EventHandlerProperties getEventHandlerProperties() {
        return this.eventHandlerProperties;
    }

    public final void setEventHandlerProperties(@NotNull EventHandlerProperties eventHandlerProperties) {
        Intrinsics.checkNotNullParameter((Object)eventHandlerProperties, (String)"<set-?>");
        this.eventHandlerProperties = eventHandlerProperties;
    }

    @NotNull
    public final EventPollerProperties getEventPollerProperties() {
        return this.eventPollerProperties;
    }

    public final void setEventPollerProperties(@NotNull EventPollerProperties eventPollerProperties) {
        Intrinsics.checkNotNullParameter((Object)eventPollerProperties, (String)"<set-?>");
        this.eventPollerProperties = eventPollerProperties;
    }

    @NotNull
    public final SqsConfiguration getSqsConfiguration() {
        return this.sqsConfiguration;
    }

    public final void setSqsConfiguration(@NotNull SqsConfiguration sqsConfiguration) {
        Intrinsics.checkNotNullParameter((Object)sqsConfiguration, (String)"<set-?>");
        this.sqsConfiguration = sqsConfiguration;
    }

    public SqsEventHandlerRegistry(@NotNull List<? extends SqsEventHandler> eventHandlers, @NotNull EventHandlerProperties eventHandlerProperties, @NotNull EventPollerProperties eventPollerProperties, @NotNull SqsConfiguration sqsConfiguration) {
        Intrinsics.checkNotNullParameter(eventHandlers, (String)"eventHandlers");
        Intrinsics.checkNotNullParameter((Object)eventHandlerProperties, (String)"eventHandlerProperties");
        Intrinsics.checkNotNullParameter((Object)eventPollerProperties, (String)"eventPollerProperties");
        Intrinsics.checkNotNullParameter((Object)sqsConfiguration, (String)"sqsConfiguration");
        this.eventHandlerProperties = eventHandlerProperties;
        this.eventPollerProperties = eventPollerProperties;
        this.sqsConfiguration = sqsConfiguration;
        boolean bl = false;
        this.pollers = SetsKt.emptySet();
        this.pollers = this.initializePollers(eventHandlers);
    }
}

