/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.integration.sqs.core.consumer;

import com.amazonaws.http.SdkHttpMetadata;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.katanox.tabour.config.EventPollerProperties;
import com.katanox.tabour.integration.sqs.config.SqsConfiguration;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventFetcherKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventFetcher;", "", "queueUrl", "", "sqsConfiguration", "Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;", "properties", "Lcom/katanox/tabour/config/EventPollerProperties;", "(Ljava/lang/String;Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;Lcom/katanox/tabour/config/EventPollerProperties;)V", "fetchMessages", "", "Lcom/amazonaws/services/sqs/model/Message;", "tabour"})
public final class SqsEventFetcher {
    private final String queueUrl;
    private final SqsConfiguration sqsConfiguration;
    private final EventPollerProperties properties;

    @NotNull
    public final List<Message> fetchMessages() {
        ReceiveMessageResult result;
        ReceiveMessageRequest request = new ReceiveMessageRequest().withMaxNumberOfMessages(Integer.valueOf(this.properties.getBatchSize())).withQueueUrl(this.queueUrl).withWaitTimeSeconds(Integer.valueOf((int)this.properties.getWaitTime().getSeconds())).withVisibilityTimeout(Integer.valueOf((int)this.properties.getVisibilityTimeout().getSeconds()));
        ReceiveMessageResult receiveMessageResult = result = this.sqsConfiguration.amazonSQSAsync().receiveMessage(request);
        Intrinsics.checkNotNullExpressionValue((Object)receiveMessageResult, (String)"result");
        if (receiveMessageResult.getSdkHttpMetadata() == null) {
            SqsEventFetcherKt.access$getLogger$p().error("cannot determine success from response for SQS queue {}: {}", (Object)this.queueUrl, (Object)result.getSdkResponseMetadata());
            return CollectionsKt.emptyList();
        }
        SdkHttpMetadata sdkHttpMetadata = result.getSdkHttpMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)sdkHttpMetadata, (String)"result.sdkHttpMetadata");
        if (sdkHttpMetadata.getHttpStatusCode() != 200) {
            SqsEventFetcherKt.access$getLogger$p().error("got error response from SQS queue {}: {}", (Object)this.queueUrl, (Object)result.getSdkHttpMetadata());
            return CollectionsKt.emptyList();
        }
        List list = result.getMessages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.messages");
        return list;
    }

    public SqsEventFetcher(@NotNull String queueUrl, @NotNull SqsConfiguration sqsConfiguration, @NotNull EventPollerProperties properties) {
        Intrinsics.checkNotNullParameter((Object)queueUrl, (String)"queueUrl");
        Intrinsics.checkNotNullParameter((Object)sqsConfiguration, (String)"sqsConfiguration");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.queueUrl = queueUrl;
        this.sqsConfiguration = sqsConfiguration;
        this.properties = properties;
    }
}

