/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.integration.sqs.config;

import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.katanox.tabour.base.IEventConsumerBase;
import com.katanox.tabour.config.EventHandlerProperties;
import com.katanox.tabour.config.EventPollerProperties;
import com.katanox.tabour.factory.BusType;
import com.katanox.tabour.factory.EventConsumerFactory;
import com.katanox.tabour.integration.sqs.config.SqsAutoConfigurationLifecycle;
import com.katanox.tabour.integration.sqs.config.SqsConfiguration;
import com.katanox.tabour.integration.sqs.config.SqsProperties;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventHandlerRegistry;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.aws.messaging.config.SimpleMessageListenerContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="tabour.sqs", name={"enable-consumption"}, havingValue="true")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J(\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/katanox/tabour/integration/sqs/config/SqsConsumptionConfiguration;", "", "sqsProperties", "Lcom/katanox/tabour/integration/sqs/config/SqsProperties;", "(Lcom/katanox/tabour/integration/sqs/config/SqsProperties;)V", "getSqsProperties", "()Lcom/katanox/tabour/integration/sqs/config/SqsProperties;", "createDefaultTaskExecutor", "Lorg/springframework/core/task/AsyncTaskExecutor;", "simpleMessageListenerContainerFactory", "Lorg/springframework/cloud/aws/messaging/config/SimpleMessageListenerContainerFactory;", "amazonSQSAsync", "Lcom/amazonaws/services/sqs/AmazonSQSAsync;", "sqsLifecycle", "Lcom/katanox/tabour/integration/sqs/config/SqsAutoConfigurationLifecycle;", "registry", "Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventHandlerRegistry;", "sqsMessageHandlerRegistry", "eventConsumerFactory", "Lcom/katanox/tabour/factory/EventConsumerFactory;", "eventHandlerProperties", "Lcom/katanox/tabour/config/EventHandlerProperties;", "eventPollerProperties", "Lcom/katanox/tabour/config/EventPollerProperties;", "sqsConfiguration", "Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;", "tabour"})
public class SqsConsumptionConfiguration {
    @NotNull
    private final SqsProperties sqsProperties;

    @Bean
    @Nullable
    public SimpleMessageListenerContainerFactory simpleMessageListenerContainerFactory(@NotNull AmazonSQSAsync amazonSQSAsync) {
        Intrinsics.checkNotNullParameter((Object)amazonSQSAsync, (String)"amazonSQSAsync");
        SimpleMessageListenerContainerFactory factory = new SimpleMessageListenerContainerFactory();
        factory.setAmazonSqs(amazonSQSAsync);
        factory.setAutoStartup(this.getSqsProperties().getAutoStartup());
        factory.setMaxNumberOfMessages(Integer.valueOf(this.getSqsProperties().getMaxNumberOfMessages()));
        factory.setTaskExecutor(this.createDefaultTaskExecutor());
        return factory;
    }

    @NotNull
    protected AsyncTaskExecutor createDefaultTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setThreadNamePrefix("SQS-");
        threadPoolTaskExecutor.setCorePoolSize(this.getSqsProperties().getCorePoolSize());
        threadPoolTaskExecutor.setMaxPoolSize(this.getSqsProperties().getMaxPoolSize());
        threadPoolTaskExecutor.setQueueCapacity(this.getSqsProperties().getQueueCapacity());
        threadPoolTaskExecutor.afterPropertiesSet();
        return (AsyncTaskExecutor)threadPoolTaskExecutor;
    }

    @Bean
    @NotNull
    public SqsEventHandlerRegistry sqsMessageHandlerRegistry(@NotNull EventConsumerFactory eventConsumerFactory, @NotNull EventHandlerProperties eventHandlerProperties, @NotNull EventPollerProperties eventPollerProperties, @NotNull SqsConfiguration sqsConfiguration) {
        Intrinsics.checkNotNullParameter((Object)eventConsumerFactory, (String)"eventConsumerFactory");
        Intrinsics.checkNotNullParameter((Object)eventHandlerProperties, (String)"eventHandlerProperties");
        Intrinsics.checkNotNullParameter((Object)eventPollerProperties, (String)"eventPollerProperties");
        Intrinsics.checkNotNullParameter((Object)sqsConfiguration, (String)"sqsConfiguration");
        List<IEventConsumerBase> list = eventConsumerFactory.getEventConsumers(BusType.SQS);
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.katanox.tabour.integration.sqs.core.consumer.SqsEventHandler>");
        }
        return new SqsEventHandlerRegistry(list, eventHandlerProperties, eventPollerProperties, sqsConfiguration);
    }

    @Bean
    @NotNull
    public SqsAutoConfigurationLifecycle sqsLifecycle(@NotNull SqsEventHandlerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return new SqsAutoConfigurationLifecycle(registry);
    }

    @NotNull
    public SqsProperties getSqsProperties() {
        return this.sqsProperties;
    }

    public SqsConsumptionConfiguration(@Autowired @NotNull SqsProperties sqsProperties) {
        Intrinsics.checkNotNullParameter((Object)sqsProperties, (String)"sqsProperties");
        this.sqsProperties = sqsProperties;
    }
}

