/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import android.app.Activity;
import android.content.Context;
import com.karumi.dexter.AndroidPermissionService;
import com.karumi.dexter.DexterBuilder;
import com.karumi.dexter.DexterException;
import com.karumi.dexter.DexterInstance;
import com.karumi.dexter.IntentProvider;
import com.karumi.dexter.MultiplePermissionsListenerToPermissionListenerAdapter;
import com.karumi.dexter.Thread;
import com.karumi.dexter.ThreadFactory;
import com.karumi.dexter.listener.EmptyPermissionRequestErrorListener;
import com.karumi.dexter.listener.PermissionRequestErrorListener;
import com.karumi.dexter.listener.multi.BaseMultiplePermissionsListener;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;
import com.karumi.dexter.listener.single.PermissionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public final class Dexter
implements DexterBuilder,
DexterBuilder.Permission,
DexterBuilder.SinglePermissionListener,
DexterBuilder.MultiPermissionListener {
    private static DexterInstance instance;
    private Collection<String> permissions;
    private MultiplePermissionsListener listener;
    private PermissionRequestErrorListener errorListener;
    private boolean shouldExecuteOnSameThread;

    private Dexter(Context context) {
        EmptyPermissionRequestErrorListener emptyPermissionRequestErrorListener;
        BaseMultiplePermissionsListener baseMultiplePermissionsListener;
        Object object = baseMultiplePermissionsListener;
        baseMultiplePermissionsListener = new BaseMultiplePermissionsListener();
        v1.listener = object;
        object = emptyPermissionRequestErrorListener;
        emptyPermissionRequestErrorListener = new EmptyPermissionRequestErrorListener();
        v1.errorListener = object;
        v1.shouldExecuteOnSameThread = false;
        Dexter.initialize(context);
    }

    @Deprecated
    public static DexterBuilder.Permission withActivity(Activity activity) {
        return new Dexter((Context)activity);
    }

    public static DexterBuilder.Permission withContext(Context context) {
        return new Dexter(context);
    }

    private Thread getThread() {
        return this.shouldExecuteOnSameThread ? ThreadFactory.makeSameThread() : ThreadFactory.makeMainThread();
    }

    private static void initialize(Context context) {
        Object object = instance;
        if (object == null) {
            IntentProvider intentProvider;
            AndroidPermissionService androidPermissionService;
            object = androidPermissionService;
            androidPermissionService = new AndroidPermissionService();
            IntentProvider intentProvider2 = intentProvider;
            intentProvider = new IntentProvider();
            instance = new DexterInstance(context, (AndroidPermissionService)object, intentProvider2);
        } else {
            ((DexterInstance)object).setContext(context);
        }
    }

    static void onActivityReady(Activity activity) {
        DexterInstance dexterInstance = instance;
        if (dexterInstance != null) {
            dexterInstance.onActivityReady(activity);
        }
    }

    static void onActivityDestroyed() {
        DexterInstance dexterInstance = instance;
        if (dexterInstance != null) {
            dexterInstance.onActivityDestroyed();
        }
    }

    static void onPermissionsRequested(Collection<String> collection, Collection<String> collection2) {
        DexterInstance dexterInstance = instance;
        if (dexterInstance != null) {
            dexterInstance.onPermissionRequestGranted(collection);
            instance.onPermissionRequestDenied(collection2);
        }
    }

    @Override
    public DexterBuilder.SinglePermissionListener withPermission(String string) {
        this.permissions = Collections.singletonList(string);
        return this;
    }

    @Override
    public DexterBuilder.MultiPermissionListener withPermissions(String ... stringArray) {
        this.permissions = Arrays.asList(stringArray);
        return this;
    }

    @Override
    public DexterBuilder.MultiPermissionListener withPermissions(Collection<String> collection) {
        ArrayList<String> arrayList;
        Dexter dexter = arrayList2;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(collection);
        dexter.permissions = arrayList2;
        return dexter;
    }

    @Override
    public DexterBuilder withListener(PermissionListener permissionListener) {
        MultiplePermissionsListenerToPermissionListenerAdapter multiplePermissionsListenerToPermissionListenerAdapter;
        Dexter dexter = multiplePermissionsListenerToPermissionListenerAdapter2;
        MultiplePermissionsListenerToPermissionListenerAdapter multiplePermissionsListenerToPermissionListenerAdapter2 = multiplePermissionsListenerToPermissionListenerAdapter;
        multiplePermissionsListenerToPermissionListenerAdapter = new MultiplePermissionsListenerToPermissionListenerAdapter(permissionListener);
        dexter.listener = multiplePermissionsListenerToPermissionListenerAdapter2;
        return dexter;
    }

    @Override
    public DexterBuilder withListener(MultiplePermissionsListener multiplePermissionsListener) {
        this.listener = multiplePermissionsListener;
        return this;
    }

    @Override
    public DexterBuilder onSameThread() {
        this.shouldExecuteOnSameThread = true;
        return this;
    }

    @Override
    public DexterBuilder withErrorListener(PermissionRequestErrorListener permissionRequestErrorListener) {
        this.errorListener = permissionRequestErrorListener;
        return this;
    }

    @Override
    public void check() {
        Thread thread = this.getThread();
        DexterInstance dexterInstance = instance;
        Dexter dexter = this;
        Dexter dexter2 = dexter;
        MultiplePermissionsListener multiplePermissionsListener = dexter.listener;
        try {
            dexterInstance.checkPermissions(multiplePermissionsListener, dexter2.permissions, thread);
        }
        catch (DexterException dexterException) {
            this.errorListener.onError(dexterException.error);
        }
    }
}

