/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter.listener.multi;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import androidx.annotation.StringRes;
import com.google.android.material.snackbar.BaseTransientBottomBar;
import com.google.android.material.snackbar.Snackbar;
import com.karumi.dexter.MultiplePermissionsReport;
import com.karumi.dexter.listener.multi.BaseMultiplePermissionsListener;

public class SnackbarOnAnyDeniedMultiplePermissionsListener
extends BaseMultiplePermissionsListener {
    private final View view;
    private final String text;
    private final String buttonText;
    private final View.OnClickListener onButtonClickListener;
    private final Snackbar.Callback snackbarCallback;
    private final int duration;

    private SnackbarOnAnyDeniedMultiplePermissionsListener(View view, String string, String string2, View.OnClickListener onClickListener, Snackbar.Callback callback, int n) {
        this.view = view;
        this.text = string;
        this.buttonText = string2;
        this.onButtonClickListener = onClickListener;
        this.snackbarCallback = callback;
        this.duration = n;
    }

    @Override
    public void onPermissionsChecked(MultiplePermissionsReport multiplePermissionsReport) {
        super.onPermissionsChecked(multiplePermissionsReport);
        if (!multiplePermissionsReport.areAllPermissionsGranted()) {
            this.showSnackbar();
        }
    }

    private void showSnackbar() {
        Snackbar snackbar = Snackbar.make((View)this.view, (CharSequence)this.text, (int)this.duration);
        if (this.buttonText != null && this.onButtonClickListener != null) {
            snackbar.setAction((CharSequence)this.buttonText, this.onButtonClickListener);
        }
        if (this.snackbarCallback != null) {
            snackbar.addCallback((BaseTransientBottomBar.BaseCallback)this.snackbarCallback);
        }
        snackbar.show();
    }

    public static class Builder {
        private final View view;
        private final String text;
        private String buttonText;
        private View.OnClickListener onClickListener;
        private Snackbar.Callback snackbarCallback;
        private int duration = 0;

        private Builder(View view, String string) {
            this.view = view;
            this.text = string;
        }

        public static Builder with(View view, String string) {
            return new Builder(view, string);
        }

        public static Builder with(View view, @StringRes int n) {
            return Builder.with(view, view.getContext().getString(n));
        }

        public Builder withButton(String string, View.OnClickListener onClickListener) {
            this.buttonText = string;
            this.onClickListener = onClickListener;
            return this;
        }

        public Builder withButton(@StringRes int n, View.OnClickListener onClickListener) {
            return this.withButton(this.view.getContext().getString(n), onClickListener);
        }

        public Builder withOpenSettingsButton(String string) {
            this.buttonText = string;
            this.onClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    Context context = Builder.this.view.getContext();
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.parse((String)("package:" + context.getPackageName())));
                    intent.addCategory("android.intent.category.DEFAULT");
                    intent.setFlags(0x10000000);
                    context.startActivity(intent);
                }
            };
            return this;
        }

        public Builder withOpenSettingsButton(@StringRes int n) {
            return this.withOpenSettingsButton(this.view.getContext().getString(n));
        }

        public Builder withCallback(Snackbar.Callback callback) {
            this.snackbarCallback = callback;
            return this;
        }

        public Builder withDuration(int n) {
            this.duration = n;
            return this;
        }

        public SnackbarOnAnyDeniedMultiplePermissionsListener build() {
            return new SnackbarOnAnyDeniedMultiplePermissionsListener(this.view, this.text, this.buttonText, this.onClickListener, this.snackbarCallback, this.duration);
        }
    }
}

