/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import com.karumi.dexter.AndroidPermissionService;
import com.karumi.dexter.DexterActivity;
import com.karumi.dexter.DexterException;
import com.karumi.dexter.IntentProvider;
import com.karumi.dexter.MultiplePermissionListenerThreadDecorator;
import com.karumi.dexter.MultiplePermissionsListenerToPermissionListenerAdapter;
import com.karumi.dexter.MultiplePermissionsReport;
import com.karumi.dexter.PermissionRationaleToken;
import com.karumi.dexter.Thread;
import com.karumi.dexter.listener.DexterError;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.multi.BaseMultiplePermissionsListener;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;
import com.karumi.dexter.listener.single.PermissionListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

final class DexterInstance {
    private static final int PERMISSIONS_REQUEST_CODE = 42;
    private static final MultiplePermissionsListener EMPTY_LISTENER = new BaseMultiplePermissionsListener();
    private WeakReference<Context> context;
    private final AndroidPermissionService androidPermissionService;
    private final IntentProvider intentProvider;
    private final Collection<String> pendingPermissions;
    private final MultiplePermissionsReport multiplePermissionsReport;
    private final AtomicBoolean isRequestingPermission;
    private final AtomicBoolean rationaleAccepted;
    private final AtomicBoolean isShowingNativeDialog;
    private final Object pendingPermissionsMutex = new Object();
    private Activity activity;
    private MultiplePermissionsListener listener = EMPTY_LISTENER;

    DexterInstance(Context context, AndroidPermissionService androidPermissionService, IntentProvider intentProvider) {
        this.androidPermissionService = androidPermissionService;
        this.intentProvider = intentProvider;
        this.pendingPermissions = new TreeSet<String>();
        this.multiplePermissionsReport = new MultiplePermissionsReport();
        this.isRequestingPermission = new AtomicBoolean();
        this.rationaleAccepted = new AtomicBoolean();
        this.isShowingNativeDialog = new AtomicBoolean();
        this.setContext(context);
    }

    void setContext(Context context) {
        this.context = new WeakReference<Context>(context);
    }

    void checkPermission(PermissionListener permissionListener, String string, Thread thread) {
        this.checkSinglePermission(permissionListener, string, thread);
    }

    void checkPermissions(MultiplePermissionsListener multiplePermissionsListener, Collection<String> collection, Thread thread) {
        this.checkMultiplePermissions(multiplePermissionsListener, collection, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onActivityReady(Activity activity) {
        this.activity = activity;
        PermissionStates permissionStates = null;
        Object object = this.pendingPermissionsMutex;
        synchronized (object) {
            if (activity != null) {
                permissionStates = this.getPermissionStates(this.pendingPermissions);
            }
        }
        if (permissionStates != null) {
            this.handleDeniedPermissions(permissionStates.getDeniedPermissions());
            this.updatePermissionsAsDenied(permissionStates.getImpossibleToGrantPermissions());
            this.updatePermissionsAsGranted(permissionStates.getGrantedPermissions());
        }
    }

    void onActivityDestroyed() {
        if (this.activity != null) {
            this.activity = null;
            this.isRequestingPermission.set(false);
            this.rationaleAccepted.set(false);
            this.isShowingNativeDialog.set(false);
            this.listener = EMPTY_LISTENER;
        }
    }

    void onPermissionRequestGranted(Collection<String> collection) {
        this.updatePermissionsAsGranted(collection);
    }

    void onPermissionRequestDenied(Collection<String> collection) {
        this.updatePermissionsAsDenied(collection);
    }

    void onContinuePermissionRequest() {
        this.rationaleAccepted.set(true);
        this.requestPermissionsToSystem(this.pendingPermissions);
    }

    void onCancelPermissionRequest() {
        this.rationaleAccepted.set(false);
        this.updatePermissionsAsDenied(this.pendingPermissions);
    }

    private void requestPermissionsToSystem(Collection<String> collection) {
        if (!this.isShowingNativeDialog.get()) {
            this.androidPermissionService.requestPermissions(this.activity, collection.toArray(new String[0]), 42);
        }
        this.isShowingNativeDialog.set(true);
    }

    private PermissionStates getPermissionStates(Collection<String> collection) {
        PermissionStates permissionStates = new PermissionStates();
        block4: for (String string : collection) {
            int n = this.checkSelfPermission(this.activity, string);
            switch (n) {
                case -2: {
                    permissionStates.addImpossibleToGrantPermission(string);
                    continue block4;
                }
                case -1: {
                    permissionStates.addDeniedPermission(string);
                    continue block4;
                }
            }
            permissionStates.addGrantedPermission(string);
        }
        return permissionStates;
    }

    private int checkSelfPermission(Activity activity, String string) {
        try {
            return this.androidPermissionService.checkSelfPermission((Context)activity, string);
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    private void startTransparentActivityIfNeeded() {
        Context context = (Context)this.context.get();
        if (context == null) {
            return;
        }
        Intent intent = this.intentProvider.get(context, DexterActivity.class);
        if (context instanceof Application) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    private void handleDeniedPermissions(Collection<String> collection) {
        if (collection.isEmpty()) {
            return;
        }
        LinkedList<PermissionRequest> linkedList = new LinkedList<PermissionRequest>();
        for (String string : collection) {
            if (!this.androidPermissionService.shouldShowRequestPermissionRationale(this.activity, string)) continue;
            linkedList.add(new PermissionRequest(string));
        }
        if (linkedList.isEmpty()) {
            this.requestPermissionsToSystem(collection);
        } else if (!this.rationaleAccepted.get()) {
            PermissionRationaleToken permissionRationaleToken = new PermissionRationaleToken(this);
            this.listener.onPermissionRationaleShouldBeShown(linkedList, permissionRationaleToken);
        }
    }

    private void updatePermissionsAsGranted(Collection<String> collection) {
        for (String string : collection) {
            PermissionGrantedResponse permissionGrantedResponse = PermissionGrantedResponse.from(string);
            this.multiplePermissionsReport.addGrantedPermissionResponse(permissionGrantedResponse);
        }
        this.onPermissionsChecked(collection);
    }

    private void updatePermissionsAsDenied(Collection<String> collection) {
        for (String string : collection) {
            PermissionDeniedResponse permissionDeniedResponse = PermissionDeniedResponse.from(string, this.androidPermissionService.isPermissionPermanentlyDenied(this.activity, string));
            this.multiplePermissionsReport.addDeniedPermissionResponse(permissionDeniedResponse);
        }
        this.onPermissionsChecked(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPermissionsChecked(Collection<String> collection) {
        if (this.pendingPermissions.isEmpty()) {
            return;
        }
        Object object = this.pendingPermissionsMutex;
        synchronized (object) {
            this.pendingPermissions.removeAll(collection);
            if (this.pendingPermissions.isEmpty()) {
                if (this.activity != null) {
                    this.activity.finish();
                }
                this.isRequestingPermission.set(false);
                this.rationaleAccepted.set(false);
                this.isShowingNativeDialog.set(false);
                MultiplePermissionsListener multiplePermissionsListener = this.listener;
                this.listener = EMPTY_LISTENER;
                multiplePermissionsListener.onPermissionsChecked(this.multiplePermissionsReport);
            }
        }
    }

    private void checkNoDexterRequestOngoing() {
        if (this.isRequestingPermission.getAndSet(true)) {
            throw new DexterException("Only one Dexter request at a time is allowed", DexterError.REQUEST_ONGOING);
        }
    }

    private void checkRequestSomePermission(Collection<String> collection) {
        if (collection.isEmpty()) {
            throw new DexterException("Dexter has to be called with at least one permission", DexterError.NO_PERMISSIONS_REQUESTED);
        }
    }

    private void checkSinglePermission(PermissionListener permissionListener, String string, Thread thread) {
        MultiplePermissionsListenerToPermissionListenerAdapter multiplePermissionsListenerToPermissionListenerAdapter = new MultiplePermissionsListenerToPermissionListenerAdapter(permissionListener);
        this.checkMultiplePermissions(multiplePermissionsListenerToPermissionListenerAdapter, Collections.singleton(string), thread);
    }

    private void checkMultiplePermissions(final MultiplePermissionsListener multiplePermissionsListener, final Collection<String> collection, Thread thread) {
        this.checkNoDexterRequestOngoing();
        this.checkRequestSomePermission(collection);
        if (this.context.get() == null) {
            return;
        }
        if (this.activity != null && this.activity.isFinishing()) {
            this.onActivityDestroyed();
        }
        this.pendingPermissions.clear();
        this.pendingPermissions.addAll(collection);
        this.multiplePermissionsReport.clear();
        this.listener = new MultiplePermissionListenerThreadDecorator(multiplePermissionsListener, thread);
        if (this.isEveryPermissionGranted(collection, (Context)this.context.get())) {
            thread.execute(new Runnable(){

                @Override
                public void run() {
                    MultiplePermissionsReport multiplePermissionsReport = new MultiplePermissionsReport();
                    for (String string : collection) {
                        multiplePermissionsReport.addGrantedPermissionResponse(PermissionGrantedResponse.from(string));
                    }
                    DexterInstance.this.isRequestingPermission.set(false);
                    multiplePermissionsListener.onPermissionsChecked(multiplePermissionsReport);
                    DexterInstance.this.listener = EMPTY_LISTENER;
                }
            });
        } else {
            this.startTransparentActivityIfNeeded();
        }
        thread.loop();
    }

    private boolean isEveryPermissionGranted(Collection<String> collection, Context context) {
        for (String string : collection) {
            int n = this.androidPermissionService.checkSelfPermission(context, string);
            if (n == 0) continue;
            return false;
        }
        return true;
    }

    private final class PermissionStates {
        private final Collection<String> deniedPermissions = new LinkedList<String>();
        private final Collection<String> impossibleToGrantPermissions = new LinkedList<String>();
        private final Collection<String> grantedPermissions = new LinkedList<String>();

        private PermissionStates() {
        }

        private void addDeniedPermission(String string) {
            this.deniedPermissions.add(string);
        }

        private void addImpossibleToGrantPermission(String string) {
            this.impossibleToGrantPermissions.add(string);
        }

        private void addGrantedPermission(String string) {
            this.grantedPermissions.add(string);
        }

        private Collection<String> getDeniedPermissions() {
            return this.deniedPermissions;
        }

        private Collection<String> getGrantedPermissions() {
            return this.grantedPermissions;
        }

        public Collection<String> getImpossibleToGrantPermissions() {
            return this.impossibleToGrantPermissions;
        }
    }
}

