/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import android.app.Activity;
import android.content.Context;
import com.karumi.dexter.AndroidPermissionService;
import com.karumi.dexter.DexterBuilder;
import com.karumi.dexter.DexterException;
import com.karumi.dexter.DexterInstance;
import com.karumi.dexter.IntentProvider;
import com.karumi.dexter.MultiplePermissionsListenerToPermissionListenerAdapter;
import com.karumi.dexter.Thread;
import com.karumi.dexter.ThreadFactory;
import com.karumi.dexter.listener.EmptyPermissionRequestErrorListener;
import com.karumi.dexter.listener.PermissionRequestErrorListener;
import com.karumi.dexter.listener.multi.BaseMultiplePermissionsListener;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;
import com.karumi.dexter.listener.single.PermissionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public final class Dexter
implements DexterBuilder,
DexterBuilder.MultiPermissionListener,
DexterBuilder.Permission,
DexterBuilder.SinglePermissionListener {
    private static DexterInstance instance;
    private Collection<String> permissions;
    private MultiplePermissionsListener listener = new BaseMultiplePermissionsListener();
    private PermissionRequestErrorListener errorListener = new EmptyPermissionRequestErrorListener();
    private boolean shouldExecuteOnSameThread = false;

    private Dexter(Activity activity) {
        Dexter.initialize((Context)activity);
    }

    public static DexterBuilder.Permission withActivity(Activity activity) {
        return new Dexter(activity);
    }

    @Override
    public DexterBuilder.SinglePermissionListener withPermission(String string) {
        this.permissions = Collections.singletonList(string);
        return this;
    }

    @Override
    public DexterBuilder.MultiPermissionListener withPermissions(String ... stringArray) {
        this.permissions = Arrays.asList(stringArray);
        return this;
    }

    @Override
    public DexterBuilder.MultiPermissionListener withPermissions(Collection<String> collection) {
        this.permissions = new ArrayList<String>(collection);
        return this;
    }

    @Override
    public DexterBuilder withListener(PermissionListener permissionListener) {
        this.listener = new MultiplePermissionsListenerToPermissionListenerAdapter(permissionListener);
        return this;
    }

    @Override
    public DexterBuilder withListener(MultiplePermissionsListener multiplePermissionsListener) {
        this.listener = multiplePermissionsListener;
        return this;
    }

    @Override
    public DexterBuilder onSameThread() {
        this.shouldExecuteOnSameThread = true;
        return this;
    }

    @Override
    public DexterBuilder withErrorListener(PermissionRequestErrorListener permissionRequestErrorListener) {
        this.errorListener = permissionRequestErrorListener;
        return this;
    }

    @Override
    public void check() {
        try {
            Thread thread = this.getThread();
            instance.checkPermissions(this.listener, this.permissions, thread);
        }
        catch (DexterException dexterException) {
            this.errorListener.onError(dexterException.error);
        }
    }

    private Thread getThread() {
        Thread thread = this.shouldExecuteOnSameThread ? ThreadFactory.makeSameThread() : ThreadFactory.makeMainThread();
        return thread;
    }

    private static void initialize(Context context) {
        if (instance == null) {
            AndroidPermissionService androidPermissionService = new AndroidPermissionService();
            IntentProvider intentProvider = new IntentProvider();
            instance = new DexterInstance(context, androidPermissionService, intentProvider);
        } else {
            instance.setContext(context);
        }
    }

    static void onActivityReady(Activity activity) {
        if (instance != null) {
            instance.onActivityReady(activity);
        }
    }

    static void onActivityDestroyed() {
        if (instance != null) {
            instance.onActivityDestroyed();
        }
    }

    static void onPermissionsRequested(Collection<String> collection, Collection<String> collection2) {
        if (instance != null) {
            instance.onPermissionRequestGranted(collection);
            instance.onPermissionRequestDenied(collection2);
        }
    }
}

