/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter.listener.single;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.StringRes;
import android.support.design.widget.Snackbar;
import android.view.View;
import android.view.ViewGroup;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.single.BasePermissionListener;

public class SnackbarOnDeniedPermissionListener
extends BasePermissionListener {
    private final ViewGroup rootView;
    private final String text;
    private final String buttonText;
    private final View.OnClickListener onButtonClickListener;
    private final Snackbar.Callback snackbarCallback;
    private final int duration;

    private SnackbarOnDeniedPermissionListener(ViewGroup viewGroup, String string, String string2, View.OnClickListener onClickListener, Snackbar.Callback callback, int n) {
        this.rootView = viewGroup;
        this.text = string;
        this.buttonText = string2;
        this.onButtonClickListener = onClickListener;
        this.snackbarCallback = callback;
        this.duration = n;
    }

    @Override
    public void onPermissionDenied(PermissionDeniedResponse permissionDeniedResponse) {
        super.onPermissionDenied(permissionDeniedResponse);
        Snackbar snackbar = Snackbar.make((View)this.rootView, (CharSequence)this.text, (int)this.duration);
        if (this.buttonText != null && this.onButtonClickListener != null) {
            snackbar.setAction((CharSequence)this.buttonText, this.onButtonClickListener);
        }
        if (this.snackbarCallback != null) {
            snackbar.setCallback(this.snackbarCallback);
        }
        snackbar.show();
    }

    public static class Builder {
        private final ViewGroup rootView;
        private final String text;
        private String buttonText;
        private View.OnClickListener onClickListener;
        private Snackbar.Callback snackbarCallback;
        private int duration = 0;

        private Builder(ViewGroup viewGroup, String string) {
            this.rootView = viewGroup;
            this.text = string;
        }

        public static Builder with(ViewGroup viewGroup, String string) {
            return new Builder(viewGroup, string);
        }

        public static Builder with(ViewGroup viewGroup, @StringRes int n) {
            return Builder.with(viewGroup, viewGroup.getContext().getString(n));
        }

        public Builder withButton(String string, View.OnClickListener onClickListener) {
            this.buttonText = string;
            this.onClickListener = onClickListener;
            return this;
        }

        public Builder withButton(@StringRes int n, View.OnClickListener onClickListener) {
            return this.withButton(this.rootView.getContext().getString(n), onClickListener);
        }

        public Builder withOpenSettingsButton(String string) {
            this.buttonText = string;
            this.onClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    Context context = Builder.this.rootView.getContext();
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.parse((String)("package:" + context.getPackageName())));
                    intent.addCategory("android.intent.category.DEFAULT");
                    intent.setFlags(0x10000000);
                    context.startActivity(intent);
                }
            };
            return this;
        }

        public Builder withOpenSettingsButton(@StringRes int n) {
            return this.withOpenSettingsButton(this.rootView.getContext().getString(n));
        }

        public Builder withCallback(Snackbar.Callback callback) {
            this.snackbarCallback = callback;
            return this;
        }

        public Builder withDuration(int n) {
            this.duration = n;
            return this;
        }

        public SnackbarOnDeniedPermissionListener build() {
            return new SnackbarOnDeniedPermissionListener(this.rootView, this.text, this.buttonText, this.onClickListener, this.snackbarCallback, this.duration);
        }
    }
}

