/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import java.util.LinkedList;
import java.util.List;

public final class MultiplePermissionsReport {
    private final List<PermissionGrantedResponse> grantedPermissionResponses = new LinkedList<PermissionGrantedResponse>();
    private final List<PermissionDeniedResponse> deniedPermissionResponses = new LinkedList<PermissionDeniedResponse>();

    MultiplePermissionsReport() {
    }

    public List<PermissionGrantedResponse> getGrantedPermissionResponses() {
        return this.grantedPermissionResponses;
    }

    public List<PermissionDeniedResponse> getDeniedPermissionResponses() {
        return this.deniedPermissionResponses;
    }

    public boolean areAllPermissionsGranted() {
        return this.deniedPermissionResponses.isEmpty();
    }

    public boolean isAnyPermissionPermanentlyDenied() {
        boolean hasPermanentlyDeniedAnyPermission = false;
        for (PermissionDeniedResponse deniedResponse : this.deniedPermissionResponses) {
            if (!deniedResponse.isPermanentlyDenied()) continue;
            hasPermanentlyDeniedAnyPermission = true;
            break;
        }
        return hasPermanentlyDeniedAnyPermission;
    }

    boolean addGrantedPermissionResponse(PermissionGrantedResponse response) {
        return this.grantedPermissionResponses.add(response);
    }

    boolean addDeniedPermissionResponse(PermissionDeniedResponse response) {
        return this.deniedPermissionResponses.add(response);
    }

    void clear() {
        this.grantedPermissionResponses.clear();
        this.deniedPermissionResponses.clear();
    }
}

