/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import com.karumi.dexter.AndroidPermissionService;
import com.karumi.dexter.DexterActivity;
import com.karumi.dexter.DexterException;
import com.karumi.dexter.IntentProvider;
import com.karumi.dexter.MultiplePermissionListenerThreadDecorator;
import com.karumi.dexter.MultiplePermissionsListenerToPermissionListenerAdapter;
import com.karumi.dexter.MultiplePermissionsReport;
import com.karumi.dexter.PermissionRationaleToken;
import com.karumi.dexter.Thread;
import com.karumi.dexter.listener.DexterError;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.multi.EmptyMultiplePermissionsListener;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;
import com.karumi.dexter.listener.single.PermissionListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

final class DexterInstance {
    private static final int PERMISSIONS_REQUEST_CODE = 42;
    private static final MultiplePermissionsListener EMPTY_LISTENER = new EmptyMultiplePermissionsListener();
    private WeakReference<Context> context;
    private final AndroidPermissionService androidPermissionService;
    private final IntentProvider intentProvider;
    private final Collection<String> pendingPermissions;
    private final MultiplePermissionsReport multiplePermissionsReport;
    private final AtomicBoolean isRequestingPermission;
    private final AtomicBoolean rationaleAccepted;
    private final AtomicBoolean isShowingNativeDialog;
    private final Object pendingPermissionsMutex = new Object();
    private Activity activity;
    private MultiplePermissionsListener listener = EMPTY_LISTENER;

    DexterInstance(Context context, AndroidPermissionService androidPermissionService, IntentProvider intentProvider) {
        this.androidPermissionService = androidPermissionService;
        this.intentProvider = intentProvider;
        this.pendingPermissions = new TreeSet<String>();
        this.multiplePermissionsReport = new MultiplePermissionsReport();
        this.isRequestingPermission = new AtomicBoolean();
        this.rationaleAccepted = new AtomicBoolean();
        this.isShowingNativeDialog = new AtomicBoolean();
        this.setContext(context);
    }

    void setContext(Context context) {
        this.context = new WeakReference<Context>(context);
    }

    void checkPermission(PermissionListener listener, String permission, Thread thread) {
        this.checkSinglePermission(listener, permission, thread);
    }

    void checkPermissions(MultiplePermissionsListener listener, Collection<String> permissions, Thread thread) {
        this.checkMultiplePermissions(listener, permissions, thread);
    }

    void continuePendingRequestIfPossible(PermissionListener listener, Thread thread) {
        MultiplePermissionsListenerToPermissionListenerAdapter adapter = new MultiplePermissionsListenerToPermissionListenerAdapter(listener);
        this.continuePendingRequestsIfPossible(adapter, thread);
    }

    void continuePendingRequestsIfPossible(MultiplePermissionsListener listener, Thread thread) {
        if (!this.pendingPermissions.isEmpty()) {
            this.listener = new MultiplePermissionListenerThreadDecorator(listener, thread);
            if (!this.rationaleAccepted.get()) {
                this.onActivityReady(this.activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onActivityReady(Activity activity) {
        this.activity = activity;
        PermissionStates permissionStates = null;
        Object object = this.pendingPermissionsMutex;
        synchronized (object) {
            if (activity != null) {
                permissionStates = this.getPermissionStates(this.pendingPermissions);
            }
        }
        if (permissionStates != null) {
            this.handleDeniedPermissions(permissionStates.getDeniedPermissions());
            this.updatePermissionsAsGranted(permissionStates.getGrantedPermissions());
        }
    }

    void onPermissionRequestGranted(Collection<String> permissions) {
        this.updatePermissionsAsGranted(permissions);
    }

    void onPermissionRequestDenied(Collection<String> permissions) {
        this.updatePermissionsAsDenied(permissions);
    }

    void onContinuePermissionRequest() {
        this.rationaleAccepted.set(true);
        this.requestPermissionsToSystem(this.pendingPermissions);
    }

    void onCancelPermissionRequest() {
        this.rationaleAccepted.set(false);
        this.updatePermissionsAsDenied(this.pendingPermissions);
    }

    private void requestPermissionsToSystem(Collection<String> permissions) {
        if (!this.isShowingNativeDialog.get()) {
            this.androidPermissionService.requestPermissions(this.activity, permissions.toArray(new String[permissions.size()]), 42);
        }
        this.isShowingNativeDialog.set(true);
    }

    private PermissionStates getPermissionStates(Collection<String> pendingPermissions) {
        PermissionStates permissionStates = new PermissionStates();
        block3: for (String permission : pendingPermissions) {
            int permissionState = this.checkSelfPermission(this.activity, permission);
            switch (permissionState) {
                case -1: {
                    permissionStates.addDeniedPermission(permission);
                    continue block3;
                }
            }
            permissionStates.addGrantedPermission(permission);
        }
        return permissionStates;
    }

    private int checkSelfPermission(Activity activity, String permission) {
        try {
            return this.androidPermissionService.checkSelfPermission((Context)activity, permission);
        }
        catch (RuntimeException ignored) {
            return -1;
        }
    }

    private void startTransparentActivityIfNeeded() {
        Context context = (Context)this.context.get();
        if (context == null) {
            return;
        }
        Intent intent = this.intentProvider.get(context, DexterActivity.class);
        if (context instanceof Application) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    private void handleDeniedPermissions(Collection<String> permissions) {
        if (permissions.isEmpty()) {
            return;
        }
        LinkedList<PermissionRequest> shouldShowRequestRationalePermissions = new LinkedList<PermissionRequest>();
        for (String permission : permissions) {
            if (!this.androidPermissionService.shouldShowRequestPermissionRationale(this.activity, permission)) continue;
            shouldShowRequestRationalePermissions.add(new PermissionRequest(permission));
        }
        if (shouldShowRequestRationalePermissions.isEmpty()) {
            this.requestPermissionsToSystem(permissions);
        } else if (!this.rationaleAccepted.get()) {
            PermissionRationaleToken permissionToken = new PermissionRationaleToken(this);
            this.listener.onPermissionRationaleShouldBeShown(shouldShowRequestRationalePermissions, permissionToken);
        }
    }

    private void updatePermissionsAsGranted(Collection<String> permissions) {
        for (String permission : permissions) {
            PermissionGrantedResponse response = PermissionGrantedResponse.from(permission);
            this.multiplePermissionsReport.addGrantedPermissionResponse(response);
        }
        this.onPermissionsChecked(permissions);
    }

    private void updatePermissionsAsDenied(Collection<String> permissions) {
        Iterator<String> iterator = permissions.iterator();
        while (iterator.hasNext()) {
            String permission;
            PermissionDeniedResponse response = PermissionDeniedResponse.from(permission, !this.androidPermissionService.shouldShowRequestPermissionRationale(this.activity, permission = iterator.next()));
            this.multiplePermissionsReport.addDeniedPermissionResponse(response);
        }
        this.onPermissionsChecked(permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPermissionsChecked(Collection<String> permissions) {
        if (this.pendingPermissions.isEmpty()) {
            return;
        }
        Object object = this.pendingPermissionsMutex;
        synchronized (object) {
            this.pendingPermissions.removeAll(permissions);
            if (this.pendingPermissions.isEmpty()) {
                this.activity.finish();
                this.activity = null;
                this.isRequestingPermission.set(false);
                this.rationaleAccepted.set(false);
                this.isShowingNativeDialog.set(false);
                MultiplePermissionsListener currentListener = this.listener;
                this.listener = EMPTY_LISTENER;
                currentListener.onPermissionsChecked(this.multiplePermissionsReport);
            }
        }
    }

    private void checkNoDexterRequestOngoing() {
        if (this.isRequestingPermission.getAndSet(true)) {
            throw new DexterException("Only one Dexter request at a time is allowed", DexterError.REQUEST_ONGOING);
        }
    }

    private void checkRequestSomePermission(Collection<String> permissions) {
        if (permissions.isEmpty()) {
            throw new DexterException("Dexter has to be called with at least one permission", DexterError.NO_PERMISSIONS_REQUESTED);
        }
    }

    private void checkSinglePermission(PermissionListener listener, String permission, Thread thread) {
        MultiplePermissionsListenerToPermissionListenerAdapter adapter = new MultiplePermissionsListenerToPermissionListenerAdapter(listener);
        this.checkMultiplePermissions(adapter, Collections.singleton(permission), thread);
    }

    private void checkMultiplePermissions(final MultiplePermissionsListener listener, final Collection<String> permissions, Thread thread) {
        this.checkNoDexterRequestOngoing();
        this.checkRequestSomePermission(permissions);
        if (this.context.get() == null) {
            return;
        }
        this.pendingPermissions.clear();
        this.pendingPermissions.addAll(permissions);
        this.multiplePermissionsReport.clear();
        this.listener = new MultiplePermissionListenerThreadDecorator(listener, thread);
        if (this.isEveryPermissionGranted(permissions, (Context)this.context.get())) {
            thread.execute(new Runnable(){

                @Override
                public void run() {
                    MultiplePermissionsReport report = new MultiplePermissionsReport();
                    for (String permission : permissions) {
                        report.addGrantedPermissionResponse(PermissionGrantedResponse.from(permission));
                    }
                    DexterInstance.this.isRequestingPermission.set(false);
                    listener.onPermissionsChecked(report);
                }
            });
        } else {
            this.startTransparentActivityIfNeeded();
        }
        thread.loop();
    }

    private boolean isEveryPermissionGranted(Collection<String> permissions, Context context) {
        for (String permission : permissions) {
            int permissionState = this.androidPermissionService.checkSelfPermission(context, permission);
            if (permissionState == 0) continue;
            return false;
        }
        return true;
    }

    private final class PermissionStates {
        private final Collection<String> deniedPermissions = new LinkedList<String>();
        private final Collection<String> grantedPermissions = new LinkedList<String>();

        private PermissionStates() {
        }

        private void addDeniedPermission(String permission) {
            this.deniedPermissions.add(permission);
        }

        private void addGrantedPermission(String permission) {
            this.grantedPermissions.add(permission);
        }

        private Collection<String> getDeniedPermissions() {
            return this.deniedPermissions;
        }

        private Collection<String> getGrantedPermissions() {
            return this.grantedPermissions;
        }
    }
}

