/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import android.app.Activity;
import android.content.Context;
import com.karumi.dexter.AndroidPermissionService;
import com.karumi.dexter.DexterBuilder;
import com.karumi.dexter.DexterException;
import com.karumi.dexter.DexterInstance;
import com.karumi.dexter.IntentProvider;
import com.karumi.dexter.MultiplePermissionsListenerToPermissionListenerAdapter;
import com.karumi.dexter.Thread;
import com.karumi.dexter.ThreadFactory;
import com.karumi.dexter.listener.EmptyPermissionRequestErrorListener;
import com.karumi.dexter.listener.PermissionRequestErrorListener;
import com.karumi.dexter.listener.multi.EmptyMultiplePermissionsListener;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;
import com.karumi.dexter.listener.single.PermissionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public final class Dexter
implements DexterBuilder,
DexterBuilder.Permission,
DexterBuilder.SinglePermissionListener,
DexterBuilder.MultiPermissionListener {
    private static DexterInstance instance;
    private Collection<String> permissions;
    private MultiplePermissionsListener listener = new EmptyMultiplePermissionsListener();
    private PermissionRequestErrorListener errorListener = new EmptyPermissionRequestErrorListener();
    private boolean shouldExecuteOnSameThread = false;

    private Dexter(Activity activity) {
        Dexter.initialize((Context)activity);
    }

    public static DexterBuilder.Permission withActivity(Activity activity) {
        return new Dexter(activity);
    }

    @Override
    public DexterBuilder.SinglePermissionListener withPermission(String permission) {
        this.permissions = Collections.singletonList(permission);
        return this;
    }

    @Override
    public DexterBuilder.MultiPermissionListener withPermissions(String ... permissions) {
        this.permissions = Arrays.asList(permissions);
        return this;
    }

    @Override
    public DexterBuilder.MultiPermissionListener withPermissions(Collection<String> permissions) {
        this.permissions = new ArrayList<String>(permissions);
        return this;
    }

    @Override
    public void continueRequestingPendingPermissions(PermissionListener listener) {
        instance.continuePendingRequestIfPossible(listener, ThreadFactory.makeMainThread());
    }

    @Override
    public void continueRequestingPendingPermissions(MultiplePermissionsListener listener) {
        instance.continuePendingRequestsIfPossible(listener, ThreadFactory.makeMainThread());
    }

    @Override
    public DexterBuilder withListener(PermissionListener listener) {
        this.listener = new MultiplePermissionsListenerToPermissionListenerAdapter(listener);
        return this;
    }

    @Override
    public DexterBuilder withListener(MultiplePermissionsListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public DexterBuilder onSameThread() {
        this.shouldExecuteOnSameThread = true;
        return this;
    }

    @Override
    public DexterBuilder withErrorListener(PermissionRequestErrorListener errorListener) {
        this.errorListener = errorListener;
        return this;
    }

    @Override
    public void check() {
        try {
            Thread thread = this.getThread();
            instance.checkPermissions(this.listener, this.permissions, thread);
        }
        catch (DexterException e) {
            this.errorListener.onError(e.error);
        }
    }

    private Thread getThread() {
        Thread thread = this.shouldExecuteOnSameThread ? ThreadFactory.makeSameThread() : ThreadFactory.makeMainThread();
        return thread;
    }

    private static void initialize(Context context) {
        if (instance == null) {
            AndroidPermissionService androidPermissionService = new AndroidPermissionService();
            IntentProvider intentProvider = new IntentProvider();
            instance = new DexterInstance(context, androidPermissionService, intentProvider);
        }
    }

    static void onActivityReady(Activity activity) {
        instance.onActivityReady(activity);
    }

    static void onPermissionsRequested(Collection<String> grantedPermissions, Collection<String> deniedPermissions) {
        instance.onPermissionRequestGranted(grantedPermissions);
        instance.onPermissionRequestDenied(deniedPermissions);
    }
}

