/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter.listener.single;

import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.single.PermissionListener;
import java.util.Arrays;
import java.util.Collection;

public class CompositePermissionListener
implements PermissionListener {
    private final Collection<PermissionListener> listeners;

    public CompositePermissionListener(PermissionListener ... listeners) {
        this(Arrays.asList(listeners));
    }

    public CompositePermissionListener(Collection<PermissionListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void onPermissionGranted(PermissionGrantedResponse response) {
        for (PermissionListener listener : this.listeners) {
            listener.onPermissionGranted(response);
        }
    }

    @Override
    public void onPermissionDenied(PermissionDeniedResponse response) {
        for (PermissionListener listener : this.listeners) {
            listener.onPermissionDenied(response);
        }
    }

    @Override
    public void onPermissionRationaleShouldBeShown(PermissionRequest permission, PermissionToken token) {
        for (PermissionListener listener : this.listeners) {
            listener.onPermissionRationaleShouldBeShown(permission, token);
        }
    }
}

