/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import com.karumi.dexter.MultiplePermissionsReport;
import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;
import com.karumi.dexter.listener.single.PermissionListener;
import java.util.List;

final class MultiplePermissionsListenerToPermissionListenerAdapter
implements MultiplePermissionsListener {
    private final PermissionListener listener;

    public MultiplePermissionsListenerToPermissionListenerAdapter(PermissionListener listener) {
        this.listener = listener;
    }

    @Override
    public void onPermissionsChecked(MultiplePermissionsReport report) {
        List<PermissionDeniedResponse> deniedResponses = report.getDeniedPermissionResponses();
        List<PermissionGrantedResponse> grantedResponses = report.getGrantedPermissionResponses();
        if (!deniedResponses.isEmpty()) {
            PermissionDeniedResponse response = deniedResponses.get(0);
            this.listener.onPermissionDenied(response);
        } else {
            PermissionGrantedResponse response = grantedResponses.get(0);
            this.listener.onPermissionGranted(response);
        }
    }

    @Override
    public void onPermissionRationaleShouldBeShown(List<PermissionRequest> requests, PermissionToken token) {
        PermissionRequest firstRequest = requests.get(0);
        this.listener.onPermissionRationaleShouldBeShown(firstRequest, token);
    }
}

