/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.karumi.dexter.AndroidPermissionService;
import com.karumi.dexter.DexterActivity;
import com.karumi.dexter.IntentProvider;
import com.karumi.dexter.MultiplePermissionsListenerToPermissionListenerAdapter;
import com.karumi.dexter.MultiplePermissionsReport;
import com.karumi.dexter.PermissionRationaleToken;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.multi.EmptyMultiplePermissionsListener;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;
import com.karumi.dexter.listener.single.PermissionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

final class DexterInstance {
    private static final int PERMISSIONS_REQUEST_CODE = 42;
    private static final MultiplePermissionsListener EMPTY_LISTENER = new EmptyMultiplePermissionsListener();
    private final Context context;
    private final AndroidPermissionService androidPermissionService;
    private final IntentProvider intentProvider;
    private final Collection<String> pendingPermissions;
    private final MultiplePermissionsReport multiplePermissionsReport;
    private final AtomicBoolean isRequestingPermission;
    private final AtomicBoolean rationaleAccepted;
    private Activity activity;
    private MultiplePermissionsListener listener = EMPTY_LISTENER;

    DexterInstance(Context context, AndroidPermissionService androidPermissionService, IntentProvider intentProvider) {
        this.context = context.getApplicationContext();
        this.androidPermissionService = androidPermissionService;
        this.intentProvider = intentProvider;
        this.pendingPermissions = new TreeSet<String>();
        this.multiplePermissionsReport = new MultiplePermissionsReport();
        this.isRequestingPermission = new AtomicBoolean();
        this.rationaleAccepted = new AtomicBoolean();
    }

    void checkPermission(PermissionListener listener, String permission) {
        MultiplePermissionsListenerToPermissionListenerAdapter adapter = new MultiplePermissionsListenerToPermissionListenerAdapter(listener);
        this.checkPermissions(adapter, Collections.singleton(permission));
    }

    void checkPermissions(MultiplePermissionsListener listener, Collection<String> permissions) {
        this.checkNoDexterRequestOngoing();
        this.checkRequestSomePermission(permissions);
        this.pendingPermissions.clear();
        this.pendingPermissions.addAll(permissions);
        this.multiplePermissionsReport.clear();
        this.listener = listener;
        this.startTransparentActivityIfNeeded();
    }

    void continuePendingRequestIfPossible(PermissionListener listener) {
        MultiplePermissionsListenerToPermissionListenerAdapter adapter = new MultiplePermissionsListenerToPermissionListenerAdapter(listener);
        this.continuePendingRequestsIfPossible(adapter);
    }

    void continuePendingRequestsIfPossible(MultiplePermissionsListener listener) {
        if (!this.pendingPermissions.isEmpty()) {
            this.listener = listener;
            if (!this.rationaleAccepted.get()) {
                this.onActivityReady(this.activity);
            }
        }
    }

    void onActivityReady(Activity activity) {
        this.activity = activity;
        LinkedList<String> deniedRequests = new LinkedList<String>();
        LinkedList<String> grantedRequests = new LinkedList<String>();
        block3: for (String permission : this.pendingPermissions) {
            int permissionState = this.androidPermissionService.checkSelfPermission((Context)activity, permission);
            switch (permissionState) {
                case -1: {
                    deniedRequests.add(permission);
                    continue block3;
                }
            }
            grantedRequests.add(permission);
        }
        this.handleDeniedPermissions(deniedRequests);
        this.updatePermissionsAsGranted(grantedRequests);
    }

    void onPermissionRequestGranted(Collection<String> permissions) {
        this.updatePermissionsAsGranted(permissions);
    }

    void onPermissionRequestDenied(Collection<String> permissions) {
        this.updatePermissionsAsDenied(permissions);
    }

    void onContinuePermissionRequest() {
        this.rationaleAccepted.set(true);
        this.requestPermissionsToSystem(this.pendingPermissions);
    }

    void onCancelPermissionRequest() {
        this.rationaleAccepted.set(false);
        this.updatePermissionsAsDenied(this.pendingPermissions);
    }

    boolean isRequestOngoing() {
        return this.isRequestingPermission.get();
    }

    void requestPermissionsToSystem(Collection<String> permissions) {
        this.androidPermissionService.requestPermissions(this.activity, permissions.toArray(new String[permissions.size()]), 42);
    }

    private void startTransparentActivityIfNeeded() {
        Intent intent = this.intentProvider.get(this.context, DexterActivity.class);
        intent.addFlags(0x10000000);
        this.context.startActivity(intent);
    }

    private void handleDeniedPermissions(Collection<String> permissions) {
        if (permissions.isEmpty()) {
            return;
        }
        LinkedList<PermissionRequest> shouldShowRequestRationalePermissions = new LinkedList<PermissionRequest>();
        for (String permission : permissions) {
            if (!this.androidPermissionService.shouldShowRequestPermissionRationale(this.activity, permission)) continue;
            shouldShowRequestRationalePermissions.add(new PermissionRequest(permission));
        }
        if (shouldShowRequestRationalePermissions.isEmpty()) {
            this.requestPermissionsToSystem(permissions);
        } else if (!this.rationaleAccepted.get()) {
            PermissionRationaleToken permissionToken = new PermissionRationaleToken(this);
            this.listener.onPermissionRationaleShouldBeShown(shouldShowRequestRationalePermissions, permissionToken);
        }
    }

    private void updatePermissionsAsGranted(Collection<String> permissions) {
        for (String permission : permissions) {
            PermissionGrantedResponse response = PermissionGrantedResponse.from(permission);
            this.multiplePermissionsReport.addGrantedPermissionResponse(response);
        }
        this.onPermissionsChecked(permissions);
    }

    private void updatePermissionsAsDenied(Collection<String> permissions) {
        Iterator<String> i$ = permissions.iterator();
        while (i$.hasNext()) {
            String permission;
            PermissionDeniedResponse response = PermissionDeniedResponse.from(permission, !this.androidPermissionService.shouldShowRequestPermissionRationale(this.activity, permission = i$.next()));
            this.multiplePermissionsReport.addDeniedPermissionResponse(response);
        }
        this.onPermissionsChecked(permissions);
    }

    private void onPermissionsChecked(Collection<String> permissions) {
        if (this.pendingPermissions.isEmpty()) {
            return;
        }
        this.pendingPermissions.removeAll(permissions);
        if (this.pendingPermissions.isEmpty()) {
            this.activity.finish();
            this.activity = null;
            this.isRequestingPermission.set(false);
            this.rationaleAccepted.set(false);
            MultiplePermissionsListener currentListener = this.listener;
            this.listener = EMPTY_LISTENER;
            currentListener.onPermissionsChecked(this.multiplePermissionsReport);
        }
    }

    private void checkNoDexterRequestOngoing() {
        if (this.isRequestingPermission.getAndSet(true)) {
            throw new IllegalStateException("Only one Dexter request at a time is allowed");
        }
    }

    private void checkRequestSomePermission(Collection<String> permissions) {
        if (permissions.isEmpty()) {
            throw new IllegalStateException("Dexter has to be called with at least one permission");
        }
    }
}

