/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter.listener.multi;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.StringRes;
import android.support.design.widget.Snackbar;
import android.view.View;
import android.view.ViewGroup;
import com.karumi.dexter.MultiplePermissionsReport;
import com.karumi.dexter.listener.multi.EmptyMultiplePermissionsListener;

public class SnackbarOnAnyDeniedMultiplePermissionsListener
extends EmptyMultiplePermissionsListener {
    private final ViewGroup rootView;
    private final String text;
    private final String buttonText;
    private final View.OnClickListener onButtonClickListener;

    private SnackbarOnAnyDeniedMultiplePermissionsListener(ViewGroup rootView, String text, String buttonText, View.OnClickListener onButtonClickListener) {
        this.rootView = rootView;
        this.text = text;
        this.buttonText = buttonText;
        this.onButtonClickListener = onButtonClickListener;
    }

    @Override
    public void onPermissionsChecked(MultiplePermissionsReport report) {
        super.onPermissionsChecked(report);
        if (!report.areAllPermissionsGranted()) {
            this.showSnackbar();
        }
    }

    private void showSnackbar() {
        Snackbar snackbar = Snackbar.make((View)this.rootView, (CharSequence)this.text, (int)0);
        if (this.buttonText != null && this.onButtonClickListener != null) {
            snackbar.setAction((CharSequence)this.buttonText, this.onButtonClickListener);
        }
        snackbar.show();
    }

    public static class Builder {
        private final ViewGroup rootView;
        private final String text;
        private String buttonText;
        private View.OnClickListener onClickListener;

        private Builder(ViewGroup rootView, String text) {
            this.rootView = rootView;
            this.text = text;
        }

        public static Builder with(ViewGroup rootView, String text) {
            return new Builder(rootView, text);
        }

        public static Builder with(ViewGroup rootView, @StringRes int textResourceId) {
            return Builder.with(rootView, rootView.getContext().getString(textResourceId));
        }

        public Builder withButton(String buttonText, View.OnClickListener onClickListener) {
            this.buttonText = buttonText;
            this.onClickListener = onClickListener;
            return this;
        }

        public Builder withButton(@StringRes int buttonTextResourceId, View.OnClickListener onClickListener) {
            return this.withButton(this.rootView.getContext().getString(buttonTextResourceId), onClickListener);
        }

        public Builder withOpenSettingsButton(String buttonText) {
            this.buttonText = buttonText;
            this.onClickListener = new View.OnClickListener(){

                public void onClick(View v) {
                    Context context = Builder.this.rootView.getContext();
                    Intent myAppSettings = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.parse((String)("package:" + context.getPackageName())));
                    myAppSettings.addCategory("android.intent.category.DEFAULT");
                    myAppSettings.setFlags(0x10000000);
                    context.startActivity(myAppSettings);
                }
            };
            return this;
        }

        public Builder withOpenSettingsButton(@StringRes int buttonTextResourceId) {
            return this.withOpenSettingsButton(this.rootView.getContext().getString(buttonTextResourceId));
        }

        public SnackbarOnAnyDeniedMultiplePermissionsListener build() {
            return new SnackbarOnAnyDeniedMultiplePermissionsListener(this.rootView, this.text, this.buttonText, this.onClickListener);
        }
    }
}

