/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.karumi.dexter.DexterActivity;
import com.karumi.dexter.PermissionRationaleToken;
import com.karumi.dexter.listener.PermissionListener;
import java.util.concurrent.atomic.AtomicBoolean;

final class DexterInstance {
    private String permission;
    private Context context;
    private Activity activity;
    private PermissionListener listener;
    private AtomicBoolean isRequestingPermission = new AtomicBoolean(false);

    DexterInstance(Context context) {
        this.context = context;
    }

    void checkPermission(String permission, PermissionListener listener) {
        if (this.isRequestingPermission.getAndSet(true)) {
            throw new IllegalStateException("Only one permission request at a time. Currently handling permission: [" + this.permission + "]");
        }
        this.permission = permission;
        this.listener = listener;
        Intent intent = new Intent(this.context, DexterActivity.class);
        intent.addFlags(0x10000000);
        this.context.startActivity(intent);
    }

    void onActivityCreated(Activity activity) {
        this.activity = activity;
        int permissionState = ContextCompat.checkSelfPermission((Context)activity, (String)this.permission);
        switch (permissionState) {
            case -1: {
                this.handleDeniedPermission(this.permission);
                break;
            }
            default: {
                this.finishWithGrantedPermission(this.permission);
            }
        }
    }

    void onPermissionRequestGranted() {
        this.finishWithGrantedPermission(this.permission);
    }

    void onPermissionRequestDenied() {
        this.finishWithDeniedPermission(this.permission);
    }

    void onContinuePermissionRequest(String permission) {
        this.requestPermission(permission);
    }

    void onCancelPermissionRequest(String permission) {
        this.finishWithDeniedPermission(permission);
    }

    void requestPermission(String permission) {
        int permissionCode = this.getPermissionCodeForPermission(permission);
        ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{permission}, (int)permissionCode);
    }

    private void handleDeniedPermission(String permission) {
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)permission)) {
            PermissionRationaleToken permissionToken = new PermissionRationaleToken(this, permission);
            this.listener.onPermissionRationaleShouldBeShown(permission, permissionToken);
        } else {
            this.requestPermission(permission);
        }
    }

    private void finishWithGrantedPermission(String permission) {
        this.activity.finish();
        this.listener.onPermissionGranted(permission);
        this.isRequestingPermission.set(false);
    }

    private void finishWithDeniedPermission(String permission) {
        this.activity.finish();
        this.listener.onPermissionDenied(permission);
        this.isRequestingPermission.set(false);
    }

    private int getPermissionCodeForPermission(String permission) {
        return Math.abs(permission.hashCode() % Integer.MAX_VALUE);
    }
}

