/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter.listener;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.StringRes;
import android.support.design.widget.Snackbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.karumi.dexter.R;
import com.karumi.dexter.listener.EmptyPermissionListener;

public class SnackbarOnDeniedPermissionListener
extends EmptyPermissionListener {
    private final Context context;
    private final ViewGroup rootView;
    private final String text;
    private final String buttonText;
    private final View.OnClickListener onButtonClickListener;

    private SnackbarOnDeniedPermissionListener(Context context, ViewGroup rootView, String text, String buttonText, View.OnClickListener onButtonClickListener) {
        this.context = context;
        this.rootView = rootView;
        this.text = text;
        this.buttonText = buttonText;
        this.onButtonClickListener = onButtonClickListener;
    }

    @Override
    public void onPermissionDenied(String permission) {
        super.onPermissionDenied(permission);
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        View snackbarView = inflater.inflate(R.layout.snackbar, this.rootView);
        Snackbar snackbar = Snackbar.make((View)snackbarView, (CharSequence)this.text, (int)0);
        if (this.buttonText != null && this.onButtonClickListener != null) {
            snackbar.setAction((CharSequence)this.buttonText, this.onButtonClickListener);
        }
        snackbar.show();
    }

    public static class Builder {
        private final Context context;
        private final ViewGroup rootView;
        private final String text;
        private String buttonText;
        private View.OnClickListener onClickListener;

        private Builder(Context context, ViewGroup rootView, String text) {
            this.context = context;
            this.rootView = rootView;
            this.text = text;
        }

        public static Builder with(Context context, ViewGroup rootView, String text) {
            return new Builder(context, rootView, text);
        }

        public static Builder with(Context context, ViewGroup rootView, @StringRes int textResourceId) {
            return Builder.with(context, rootView, context.getString(textResourceId));
        }

        public Builder withButton(String buttonText, View.OnClickListener onClickListener) {
            this.buttonText = buttonText;
            this.onClickListener = onClickListener;
            return this;
        }

        public Builder withButton(@StringRes int buttonTextResourceId, View.OnClickListener onClickListener) {
            return this.withButton(this.context.getString(buttonTextResourceId), onClickListener);
        }

        public Builder withOpenSettingsButton(String buttonText) {
            this.buttonText = buttonText;
            this.onClickListener = new View.OnClickListener(){

                public void onClick(View v) {
                    Intent myAppSettings = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.parse((String)("package:" + Builder.this.context.getPackageName())));
                    myAppSettings.addCategory("android.intent.category.DEFAULT");
                    myAppSettings.setFlags(0x10000000);
                    Builder.this.context.startActivity(myAppSettings);
                }
            };
            return this;
        }

        public Builder withOpenSettingsButton(@StringRes int buttonTextResourceId) {
            return this.withOpenSettingsButton(this.context.getString(buttonTextResourceId));
        }

        public SnackbarOnDeniedPermissionListener build() {
            return new SnackbarOnDeniedPermissionListener(this.context, this.rootView, this.text, this.buttonText, this.onClickListener);
        }
    }
}

