/*
 * Decompiled with CFR 0.152.
 */
package com.kaopiz.kprogresshud;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.kaopiz.kprogresshud.Helper;
import com.kaopiz.kprogresshud.R;

class BackgroundLayout
extends LinearLayout {
    private float mCornerRadius;
    private int mBackgroundColor;

    public BackgroundLayout(Context context) {
        super(context);
        this.init();
    }

    public BackgroundLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    @TargetApi(value=11)
    public BackgroundLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        int color2 = this.getContext().getResources().getColor(R.color.kprogresshud_default_color);
        this.initBackground(color2, this.mCornerRadius);
    }

    private void initBackground(int color2, float cornerRadius) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(0);
        drawable.setColor(color2);
        drawable.setCornerRadius(cornerRadius);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground((Drawable)drawable);
        } else {
            this.setBackgroundDrawable((Drawable)drawable);
        }
    }

    public void setCornerRadius(float radius) {
        this.mCornerRadius = Helper.dpToPixel(radius, this.getContext());
        this.initBackground(this.mBackgroundColor, this.mCornerRadius);
    }

    public void setBaseColor(int color2) {
        this.mBackgroundColor = color2;
        this.initBackground(this.mBackgroundColor, this.mCornerRadius);
    }
}

