/*
 * Decompiled with CFR 0.152.
 */
package com.kakai.materialpreferencesheaders;

import android.content.Context;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kakai.materialpreferencesheaders.R;
import com.kakai.materialpreferencesheaders.SettingsHeader;

public class SettingsCategory
extends RelativeLayout {
    private CardView card;
    private TextView categoryName;
    private ViewGroup headersGroup;
    private SettingsHeader[] settingsHeaders;
    private boolean useDivider;
    private int dividerRes;
    private int headerTextColor = 0;
    private int headerIconTint = 0;

    public SettingsCategory(Context context) {
        super(context);
        this.init();
    }

    public SettingsCategory(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SettingsCategory(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        SettingsCategory.inflate((Context)this.getContext(), (int)R.layout.settings_category, (ViewGroup)this);
        this.card = (CardView)this.findViewById(R.id.mph_category_card);
        this.categoryName = (TextView)this.findViewById(R.id.mph_category_name);
        this.headersGroup = (ViewGroup)this.findViewById(R.id.mph_category_headers);
        this.useDivider = true;
        this.dividerRes = 0;
    }

    public SettingsCategory withName(CharSequence charSequence) {
        this.categoryName.setText(charSequence);
        return this;
    }

    public SettingsCategory withName(int resId) {
        this.categoryName.setText(resId);
        return this;
    }

    public SettingsCategory withNameColor(int color) {
        this.categoryName.setTextColor(color);
        return this;
    }

    public SettingsCategory withDivider(boolean withDivider) {
        this.useDivider = withDivider;
        return this;
    }

    public SettingsCategory withDivider(int resId) {
        this.useDivider = true;
        this.dividerRes = resId;
        return this;
    }

    public SettingsCategory withBackgroundColor(int color) {
        this.card.setBackgroundColor(color);
        return this;
    }

    public SettingsCategory withHeaderIconTint(int color) {
        this.headerIconTint = color;
        return this;
    }

    public SettingsCategory withHeaderTextColor(int color) {
        this.headerTextColor = color;
        return this;
    }

    public SettingsCategory withHeaders(SettingsHeader ... headers) {
        this.settingsHeaders = headers;
        return this;
    }

    protected SettingsCategory build() {
        for (int i = 0; i < this.settingsHeaders.length; ++i) {
            SettingsHeader header = this.settingsHeaders[i];
            if (this.headerIconTint != 0) {
                header = header.withIconTint(this.headerIconTint);
            }
            if (this.headerTextColor != 0) {
                header = header.withTextColor(this.headerTextColor);
            }
            if (this.useDivider && i < this.settingsHeaders.length - 1) {
                header = header.withDivider(this.useDivider);
                if (this.dividerRes != 0) {
                    header = header.withDivider(this.dividerRes);
                }
            }
            this.headersGroup.addView((View)header);
        }
        return this;
    }
}

