/*
 * Decompiled with CFR 0.152.
 */
package com.kakai.materialpreferencesheaders;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.kakai.materialpreferencesheaders.R;
import com.kakai.materialpreferencesheaders.SettingsCategory;

public class SettingsView
extends LinearLayout {
    private LinearLayout categoriesGroup;
    private int categoryNameColor = 0;
    private int headerIconTint = 0;
    private int headerTextColor = 0;
    private int categoryBackgroundColor = 0;
    private int headerDivider = 0;

    public SettingsView(Context context) {
        super(context);
        this.init();
    }

    public SettingsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SettingsView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        SettingsView.inflate((Context)this.getContext(), (int)R.layout.settings_view, (ViewGroup)this);
        this.categoriesGroup = (LinearLayout)this.findViewById(R.id.mph_categories);
    }

    public SettingsView withCategoryNameColor(int color) {
        this.categoryNameColor = color;
        return this;
    }

    public SettingsView withCategoryBackgroundColor(int color) {
        this.categoryBackgroundColor = color;
        return this;
    }

    public SettingsView withHeaderIconTint(int color) {
        this.headerIconTint = color;
        return this;
    }

    public SettingsView withHeaderTextColor(int color) {
        this.headerTextColor = color;
        return this;
    }

    public SettingsView withHeaderDivider(int resId) {
        this.headerDivider = resId;
        return this;
    }

    public SettingsView withCategories(SettingsCategory ... categories) {
        for (SettingsCategory category : categories) {
            if (this.categoryNameColor != 0) {
                category = category.withNameColor(this.categoryNameColor);
            }
            if (this.categoryBackgroundColor != 0) {
                category = category.withBackgroundColor(this.categoryBackgroundColor);
            }
            if (this.headerIconTint != 0) {
                category = category.withHeaderIconTint(this.headerIconTint);
            }
            if (this.headerTextColor != 0) {
                category = category.withHeaderTextColor(this.headerTextColor);
            }
            if (this.headerDivider != 0) {
                category = category.withDivider(this.headerDivider);
            }
            this.categoriesGroup.addView((View)category);
        }
        return this;
    }
}

