/*
 * Decompiled with CFR 0.152.
 */
package com.kakai.materialpreferencesheaders;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kakai.materialpreferencesheaders.R;

public class SettingsHeader
extends RelativeLayout {
    private View container;
    private ImageView icon;
    private TextView text;
    private int dividerResId = R.drawable.settings_divider;

    public SettingsHeader(Context context) {
        super(context);
        this.init();
    }

    public SettingsHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SettingsHeader(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        SettingsHeader.inflate((Context)this.getContext(), (int)R.layout.settings_header, (ViewGroup)this);
        this.container = this.findViewById(R.id.mph_header_container);
        this.icon = (ImageView)this.findViewById(R.id.mph_header_icon);
        this.text = (TextView)this.findViewById(R.id.mph_header_text);
    }

    public SettingsHeader withIcon(int resId) {
        this.icon.setImageResource(resId);
        return this;
    }

    public SettingsHeader withIconTint(int color) {
        this.icon.setColorFilter(color);
        return this;
    }

    public SettingsHeader withText(CharSequence charSequence) {
        this.text.setText(charSequence);
        return this;
    }

    public SettingsHeader withText(int resId) {
        this.text.setText(resId);
        return this;
    }

    public SettingsHeader withTextColor(int color) {
        this.text.setTextColor(color);
        return this;
    }

    public SettingsHeader withDivider(boolean withDivider) {
        if (withDivider) {
            this.text.setBackgroundResource(this.dividerResId);
        } else {
            this.text.setBackgroundResource(0);
        }
        return this;
    }

    public SettingsHeader withDivider(int resId) {
        this.dividerResId = resId;
        this.text.setBackgroundResource(resId);
        return this;
    }

    public SettingsHeader withOnClickListener(View.OnClickListener listener) {
        this.container.setOnClickListener(listener);
        return this;
    }
}

