/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.ui.payment;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.bara.SakuraHelper;
import com.quby.R;
import com.sakura.momo.comon.cmd.CmdPaymentV3;
import com.sakura.momo.comon.config.GameConfigs;
import com.sakura.momo.comon.game.BaraSdk;
import com.sakura.momo.comon.game.BaseDialogFragment;
import com.sakura.momo.comon.object.BaseObj;
import com.sakura.momo.comon.object.InitalizePuchaseObj;
import com.sakura.momo.comon.object.ItemPayObj;
import com.sakura.momo.comon.object.ListPurchaseHistoryObj;
import com.sakura.momo.comon.object.PurchaseHistoryObj;
import com.sakura.momo.comon.object.VerifyPurchaseObj;
import com.sakura.momo.comon.object.err.GetListPurchaseErrObj;
import com.sakura.momo.comon.object.err.InitialPurchaseErrObj;
import com.sakura.momo.comon.object.err.VerifyPurchaseErrObj;
import com.sakura.momo.comon.object.request.InitalizePuchaseRequestObj;
import com.sakura.momo.comon.object.request.VerifyPurchaseRequestObj;
import com.sakura.momo.comon.object.response.InitialPurchaseResponseObj;
import com.sakura.momo.comon.object.response.ItemPayResponseObj;
import com.sakura.momo.comon.object.response.VerifyPurchaseResponseObj;
import com.sakura.momo.comon.presenter.BaseView;
import com.sakura.momo.comon.sharePref.PrefManager;
import com.sakura.momo.comon.tracking.SakuraTracking;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.comon.utils.DialogUtils;
import com.sakura.momo.comon.utils.LogUtils;
import com.sakura.momo.comon.utils.PurchaseUtils;
import com.sakura.momo.comon.utils.Utils;
import com.sakura.momo.ui.payment.IPaymentPresenter;
import com.sakura.momo.ui.payment.PaymentAdapter;
import com.sakura.momo.ui.payment.PaymentPresenterImpl;
import com.sakura.momo.ui.payment.PaymentWebviewFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONObject;

public class PaymentNativeFragment
extends BaseDialogFragment
implements PaymentAdapter.OnClickItemPaymentListener,
BaseView {
    private static final String TAG = PaymentNativeFragment.class.getSimpleName();
    Activity mActivity;
    String account_id;
    private RecyclerView gridView;
    private View viewConnectionLost;
    ItemPayObj itemPayObj;
    private String state = "";
    List<SkuDetails> skuDetails;
    int current;
    TextView tv_title;
    PaymentPresenterImpl paymentPresenter;
    PaymentAdapter paymentAdapter;
    Purchase purchase;
    PurchaseHistoryObj currentPurchase;
    InitalizePuchaseObj initalizePuchaseObj;
    ArrayList<IPaymentPresenter> listPresenter;
    PaymentSuccess paymentSuccess;
    private final SkuDetailsResponseListener skuDetailsResponseListener = new SkuDetailsResponseListener(){

        public void onSkuDetailsResponse(@NonNull BillingResult billingResult, @Nullable List<SkuDetails> list) {
            int responseCode = billingResult.getResponseCode();
            String debugMessage = billingResult.getDebugMessage();
            switch (responseCode) {
                case 0: {
                    Log.d((String)TAG, (String)("onSkuDetailsResponse: " + responseCode));
                    if (list != null && list.size() > 0) {
                        PaymentNativeFragment.this.skuDetails = list;
                        CmdPaymentV3.getInstance().launchBillingFlow(PaymentNativeFragment.this.getActivity(), PaymentNativeFragment.this.skuDetails.get(PaymentNativeFragment.this.skuDetails.size() - 1));
                        break;
                    }
                    Toast.makeText((Context)PaymentNativeFragment.this.mActivity, (int)R.string.error_transaction, (int)0).show();
                    break;
                }
                case -1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Log.e((String)TAG, (String)("onSkuDetailsResponse: " + responseCode + " " + debugMessage));
                    break;
                }
                case 1: {
                    Log.i((String)TAG, (String)("onSkuDetailsResponse: " + responseCode + " " + debugMessage));
                    break;
                }
                default: {
                    Log.wtf((String)TAG, (String)("onSkuDetailsResponse: " + responseCode + " " + debugMessage));
                }
            }
        }
    };

    public static PaymentNativeFragment newInstance(String state, PaymentSuccess paymentSuccess) {
        PaymentNativeFragment frag = new PaymentNativeFragment();
        frag.setPaymentSuccess(state, paymentSuccess);
        return frag;
    }

    public void onStart() {
        super.onStart();
        Objects.requireNonNull(this.getDialog().getWindow()).setFlags(1024, 1024);
        this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getDialog().getWindow().setDimAmount(0.8f);
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mActivity = activity;
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.payment_dialog_fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, R.style.DialogTheme);
        this.initIAP();
        this.account_id = GameConfigs.getInstance().getUser().getAccount().getAccountId();
        this.listPresenter = new ArrayList();
        this.skuDetails = new ArrayList<SkuDetails>();
        this.current = -1;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        SakuraTracking.getInstance().trackPaymentScreenOpened();
        this.initView(view);
        this.paymentPresenter = new PaymentPresenterImpl(this);
        this.paymentPresenter.getItemList();
    }

    @Override
    public void onResume() {
        super.onResume();
        this.checkPurchaseHistory();
        SakuraHelper.hideNotiFloatButton();
    }

    private void initView(View view) {
        ImageButton btn_close = (ImageButton)view.findViewById(R.id.btn_close_pay);
        this.gridView = (RecyclerView)view.findViewById(R.id.grid_view_pay);
        this.viewConnectionLost = view.findViewById(R.id.layout_connection_lost);
        Button btnReload = (Button)view.findViewById(R.id.btn_reload);
        this.tv_title = (TextView)view.findViewById(R.id.tv_title);
        this.tv_title.setText((CharSequence)this.mActivity.getResources().getString(R.string.txt_title_payment));
        this.viewConnectionLost.setVisibility(8);
        btn_close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PaymentNativeFragment.this.dismiss();
            }
        });
        btnReload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PaymentNativeFragment.this.paymentPresenter.getItemList();
            }
        });
    }

    private void initGridView(int col) {
        GridLayoutManager gridLayoutManager = new GridLayoutManager((Context)this.mActivity, col);
        if (this.itemPayObj != null) {
            this.paymentAdapter = new PaymentAdapter((Context)this.mActivity, this.itemPayObj, this);
            this.gridView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
            this.gridView.setAdapter((RecyclerView.Adapter)this.paymentAdapter);
        }
    }

    @Override
    public void onClickItem(View view, ItemPayObj.Item item) {
        Log.d((String)TAG, (String)("onPaymentStartIAP clicked: " + item.getProductId()));
        if (item.getConfigItem() != null && "webview".equals(item.getConfigItem().getType())) {
            this.showLocalPurchaseFragment(item);
        } else {
            String character_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_ROLE_ID", "");
            String area_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_AREA_ID", "");
            String invoice_no = DeviceUtils.getOSInfo().replace(" ", "") + System.currentTimeMillis();
            if (this.state == null || "".equals(this.state)) {
                this.state = "";
            }
            InitalizePuchaseRequestObj obj = new InitalizePuchaseRequestObj();
            obj.setRequest(PrefManager.getAppKey((Context)this.mActivity));
            obj.setDevice_id(DeviceUtils.getUniqueDeviceID((Context)this.mActivity));
            obj.setMethod("2");
            obj.setCharacter_name("");
            obj.setCharacter_id(character_id);
            obj.setArea_id(area_id);
            obj.setArea_name("");
            obj.setItem_no(item.getItemNo());
            obj.setProduct_id(item.getProductId());
            obj.setPayload(this.state);
            obj.setInvoice_no(invoice_no);
            obj.setApp_version(Utils.getGameVersion((Context)this.mActivity));
            obj.setSdk_version(Utils.getSDKVersion((Context)this.mActivity));
            obj.setDevice_name(DeviceUtils.getDevice());
            obj.setDevice_os(DeviceUtils.getOSInfo());
            obj.setNetwork(Utils.getNetwork((Context)this.mActivity));
            obj.setAdvertising_id(DeviceUtils.getAdvertisingID((Context)this.mActivity));
            obj.setAppsflyer_id(DeviceUtils.getAppsflyerUID((Context)this.mActivity));
            obj.setLocale(PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "APP_LANG", "en"));
            obj.setResolution(DeviceUtils.getResolution((Context)this.mActivity));
            if (this.paymentPresenter != null) {
                this.paymentPresenter.initialPurchase(obj);
            }
        }
    }

    private void showLocalPurchaseFragment(ItemPayObj.Item item) {
        PaymentWebviewFragment paymentWebviewFragment = PaymentWebviewFragment.newInstance(item, new PaymentWebviewFragment.LocalPurchaseListener(){

            @Override
            public void localPurchaseSuccess(VerifyPurchaseObj verifyPurchaseObj) {
                PaymentNativeFragment.this.paymentSuccess.onLocalPaymentSuccess(verifyPurchaseObj);
                PaymentNativeFragment.this.dismiss();
            }

            @Override
            public void localPurchaseFailed() {
                DialogUtils.showErrorDialog(PaymentNativeFragment.this.mActivity, PaymentNativeFragment.this.mActivity.getString(R.string.err_and_try_again_late));
                PaymentNativeFragment.this.dismiss();
            }
        });
        if (paymentWebviewFragment.getDialog() != null && paymentWebviewFragment.getDialog().isShowing()) {
            return;
        }
        paymentWebviewFragment.show(this.mActivity.getFragmentManager(), PaymentNativeFragment.class.getSimpleName());
    }

    public void onDestroyView() {
        super.onDestroyView();
        SakuraHelper.showNotiFloatButton(GameConfigs.getInstance().getSdkConfig().getEx());
    }

    public void onDestroy() {
        super.onDestroy();
        CmdPaymentV3.getInstance().billingEndConnection();
    }

    private void initIAP() {
        CmdPaymentV3.getInstance().initIABv3((Context)this.getActivity(), new BillingClientStateListener(){

            public void onBillingSetupFinished(@NonNull BillingResult billingResult) {
                int responseCode = billingResult.getResponseCode();
                String debugMessage = billingResult.getDebugMessage();
                Log.d((String)TAG, (String)("onBillingSetupFinished: " + responseCode + " " + debugMessage));
            }

            public void onBillingServiceDisconnected() {
                Log.d((String)TAG, (String)"onBillingServiceDisconnected: ");
            }
        }, new PurchasesUpdatedListener(){

            public void onPurchasesUpdated(@NonNull BillingResult billingResult, @Nullable List<Purchase> list) {
                int responseCode = billingResult.getResponseCode();
                String debugMessage = billingResult.getDebugMessage();
                Log.d((String)TAG, (String)("onPurchasesUpdated:  " + responseCode + " " + debugMessage));
                switch (responseCode) {
                    case 0: {
                        PaymentNativeFragment.this.processPurchases(list);
                        break;
                    }
                    case 1: {
                        Log.i((String)TAG, (String)"onPurchasesUpdated: User canceled the purchase");
                        PaymentNativeFragment.this.skuDetails.clear();
                        break;
                    }
                    case 4: {
                        Log.i((String)TAG, (String)"onPurchasesUpdated: This item is unavailable");
                        break;
                    }
                    case 7: {
                        Log.i((String)TAG, (String)"onPurchasesUpdated: The user already owns this item");
                        break;
                    }
                    case 5: {
                        Log.e((String)TAG, (String)"onPurchasesUpdated: Developer error means that Google Play does not recognize the configuration. If you are just getting started, make sure you have configured the application correctly in the Google Play Console. The SKU product ID must match and the APK you are using must be signed with release keys.");
                        break;
                    }
                    default: {
                        Log.i((String)TAG, (String)("onPurchasesUpdated: " + debugMessage));
                    }
                }
            }
        });
    }

    private void processPurchases(List<Purchase> purchasesList) {
        if (purchasesList != null) {
            Log.d((String)TAG, (String)("processPurchases: " + purchasesList.size() + " purchase(s)"));
            for (Purchase purchase : purchasesList) {
                this.handlePurchase(purchase);
            }
        } else {
            Log.d((String)TAG, (String)"processPurchases: with no purchases");
            Log.d((String)TAG, (String)"onPurchasesUpdated: null purchase list");
        }
    }

    private void handlePurchase(final Purchase purchase) {
        Log.i((String)TAG, (String)("handlePurchase: " + purchase.getPurchaseState()));
        if (purchase.getPurchaseState() == 1) {
            Log.i((String)TAG, (String)"PURCHASE IS PURCHASED ");
            this.purchase = purchase;
            CmdPaymentV3.getInstance().consumeAsyncPurchase(purchase, new ConsumeResponseListener(){

                public void onConsumeResponse(@NonNull BillingResult billingResult, @NonNull String s) {
                    PaymentNativeFragment.this.skuDetails.clear();
                    if (billingResult.getResponseCode() == 0) {
                        PaymentNativeFragment.this.currentPurchase = new PurchaseHistoryObj();
                        String character_id = PrefManager.getString((Context)PaymentNativeFragment.this.mActivity, "MANCT_ROLE_ID", "");
                        String area_id = PrefManager.getString((Context)PaymentNativeFragment.this.mActivity, "MANCT_AREA_ID", "");
                        PaymentNativeFragment.this.currentPurchase.setArea_id(area_id);
                        PaymentNativeFragment.this.currentPurchase.setCharactor_id(character_id);
                        PaymentNativeFragment.this.currentPurchase.setOrder_no(PaymentNativeFragment.this.initalizePuchaseObj.getOrder_no());
                        Log.i((String)TAG, (String)("currentPurchase: " + PaymentNativeFragment.this.currentPurchase.getOrder_no()));
                        try {
                            JSONObject joReceipt = new JSONObject(purchase.getOriginalJson());
                            VerifyPurchaseRequestObj.Receipt rec = new VerifyPurchaseRequestObj.Receipt();
                            rec.setData(joReceipt.toString());
                            rec.setItemType("inapp");
                            rec.setSignature(purchase.getSignature());
                            PaymentNativeFragment.this.currentPurchase.setReceipt(rec);
                        }
                        catch (Exception e) {
                            LogUtils.e("Err Purchase", e.getMessage());
                        }
                        PaymentNativeFragment.this.currentPurchase.setIs_send(false);
                        PaymentNativeFragment.this.currentPurchase.setAccount_id(PaymentNativeFragment.this.account_id);
                        LogUtils.d("RECEIPT 1", purchase.getOriginalJson());
                        for (IPaymentPresenter p : PaymentNativeFragment.this.listPresenter) {
                            if (p == null) continue;
                            p.cancelRequest(new String[0]);
                        }
                        PrefManager.saveUsePurchaseHistory((Context)PaymentNativeFragment.this.mActivity, PaymentNativeFragment.this.account_id, PaymentNativeFragment.this.currentPurchase);
                        Log.i((String)TAG, (String)("currentPurchase: " + PaymentNativeFragment.this.currentPurchase.getOrder_no()));
                        if (PaymentNativeFragment.this.paymentSuccess != null) {
                            PaymentNativeFragment.this.dismiss();
                            PaymentNativeFragment.this.paymentSuccess.onIapPaymentSuccess(PaymentNativeFragment.this.currentPurchase);
                        }
                    }
                }
            });
        } else if (purchase.getPurchaseState() == 2) {
            Log.i((String)TAG, (String)"PURCHASE IS PENDING ");
        }
    }

    @Override
    public void showProgress(String message) {
        Utils.showLoading(this.mActivity, true);
    }

    @Override
    public void hideProgress() {
        Utils.showLoading(this.mActivity, false);
    }

    public void success(Object x) {
        InitialPurchaseResponseObj initialPurchaseResponseObj;
        if (x instanceof ItemPayResponseObj) {
            ItemPayResponseObj itemPayResponseObj = (ItemPayResponseObj)x;
            if (itemPayResponseObj.getStatus() == 0 && itemPayResponseObj.getData() != null) {
                this.itemPayObj = itemPayResponseObj.getData();
                this.initGridView(itemPayResponseObj.getData().getConfig().getColumns());
                SakuraTracking.getInstance().trackPaymentLoadScreenSuccess();
            }
        } else if (x instanceof InitialPurchaseResponseObj && (initialPurchaseResponseObj = (InitialPurchaseResponseObj)x).getStatus() == 0) {
            this.initalizePuchaseObj = initialPurchaseResponseObj.getData();
            Log.d((String)TAG, (String)("onPaymentStartIAP response: " + this.initalizePuchaseObj.getProduct_id()));
            if (TextUtils.isEmpty((CharSequence)this.initalizePuchaseObj.getOrder_no())) {
                DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.err_and_try_again_late));
                return;
            }
            CmdPaymentV3.getInstance().querySkuDetails(this.initalizePuchaseObj.getProduct_id(), this.skuDetailsResponseListener);
        }
    }

    public void error(Object o) {
        if (o instanceof GetListPurchaseErrObj) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.err_and_try_again_late));
            this.dismiss();
            SakuraTracking.getInstance().trackPaymentLoadScreenFail(((GetListPurchaseErrObj)o).getStatus() + "", ((GetListPurchaseErrObj)o).getMessage());
        } else if (o instanceof InitialPurchaseErrObj) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.err_and_try_again_late));
        } else if (o instanceof VerifyPurchaseErrObj) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.err_and_try_again_late));
        }
    }

    public void setPaymentSuccess(String state, PaymentSuccess paymentSuccess) {
        this.state = state;
        this.paymentSuccess = paymentSuccess;
    }

    public void checkPurchaseHistory() {
        ++this.current;
        ListPurchaseHistoryObj listPurchaseHistoryObj = PrefManager.getHistoryPurchase((Context)this.mActivity, this.account_id);
        if (listPurchaseHistoryObj.getData() == null || listPurchaseHistoryObj.getData().size() == 0 || listPurchaseHistoryObj.getData().size() <= this.current && this.current >= 0) {
            return;
        }
        PurchaseHistoryObj obj = listPurchaseHistoryObj.getData().get(this.current);
        this.sendHistory(obj);
    }

    public void sendHistory(final PurchaseHistoryObj obj) {
        PaymentPresenterImpl presenter = new PaymentPresenterImpl(new BaseView(){

            @Override
            public void showProgress(String message) {
            }

            @Override
            public void hideProgress() {
            }

            public void success(Object x) {
                if (x instanceof VerifyPurchaseResponseObj) {
                    VerifyPurchaseResponseObj responseObj = (VerifyPurchaseResponseObj)x;
                    int status = responseObj.getData().getStatus();
                    if (status == 3 || status == 2 || status == 17) {
                        SakuraTracking.getInstance().trackPaymentVerifySuccess(responseObj.getData());
                    } else {
                        SakuraTracking.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "code", String.valueOf(status), responseObj.getData().getDescription());
                    }
                    obj.setAccount_id(PaymentNativeFragment.this.account_id);
                    PurchaseUtils.removeSuccessPurchase(obj, PaymentNativeFragment.this.mActivity);
                    --PaymentNativeFragment.this.current;
                    PaymentNativeFragment.this.checkPurchaseHistory();
                    LogUtils.e(TAG, "Verify Success - " + obj.getOrder_no());
                }
            }

            public void error(Object o) {
                BaseObj err;
                if (o instanceof VerifyPurchaseErrObj) {
                    err = (VerifyPurchaseErrObj)o;
                    LogUtils.e(TAG, "Verify failed - " + obj.getOrder_no() + " :" + err.getMessage());
                    PaymentNativeFragment.this.checkPurchaseHistory();
                }
                if (o instanceof BaseObj) {
                    err = (BaseObj)o;
                    SakuraTracking.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "http", String.valueOf(err.getStatus()), err.getMessage());
                }
            }
        });
        SakuraTracking.getInstance().trackPaymentBeforVerify(obj.getOrder_no());
        this.listPresenter.add(presenter);
        this.onVerifyPurchase(presenter, obj.getReceipt(), obj.getOrder_no());
    }

    public void onVerifyPurchase(IPaymentPresenter presenter, VerifyPurchaseRequestObj.Receipt receipt, String order_no) {
        VerifyPurchaseRequestObj obj = new VerifyPurchaseRequestObj();
        obj.setOrder_no(order_no);
        obj.setMethod("2");
        obj.setReceipt(receipt);
        obj.setApp_version(Utils.getGameVersion((Context)this.mActivity));
        obj.setSdk_version(Utils.getSDKVersion((Context)this.mActivity));
        obj.setDevice_name(DeviceUtils.getDevice());
        obj.setDevice_os(DeviceUtils.getOSInfo());
        obj.setResolution(DeviceUtils.getResolution((Context)this.mActivity));
        obj.setNetwork(Utils.getNetwork((Context)this.mActivity));
        obj.setAdvertising_id(DeviceUtils.getAdvertisingID((Context)this.mActivity));
        obj.setAppsflyer_id(DeviceUtils.getAppsflyerUID((Context)this.mActivity));
        obj.setLocale(GameConfigs.getInstance().getLang());
        if (presenter != null) {
            presenter.verifyPurchase(obj);
        }
    }

    public static interface PaymentSuccess {
        public void onIapPaymentSuccess(PurchaseHistoryObj var1);

        public void onLocalPaymentSuccess(VerifyPurchaseObj var1);
    }
}

