/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.ui.payment;

import android.content.Context;
import com.sakura.momo.comon.api.ApiUtils;
import com.sakura.momo.comon.api.MyCallback;
import com.sakura.momo.comon.api.request.PaymentRequest;
import com.sakura.momo.comon.game.BaraSdk;
import com.sakura.momo.comon.object.BaseObj;
import com.sakura.momo.comon.object.err.GetListPurchaseErrObj;
import com.sakura.momo.comon.object.err.InitialPurchaseErrObj;
import com.sakura.momo.comon.object.err.RetryPaymentErrObj;
import com.sakura.momo.comon.object.err.VerifyPurchaseErrObj;
import com.sakura.momo.comon.object.request.InitalizePuchaseRequestObj;
import com.sakura.momo.comon.object.request.VerifyPurchaseRequestObj;
import com.sakura.momo.comon.object.response.InitialPurchaseResponseObj;
import com.sakura.momo.comon.object.response.ItemPayResponseObj;
import com.sakura.momo.comon.object.response.RetryPaymentResponseObj;
import com.sakura.momo.comon.object.response.VerifyPurchaseResponseObj;
import com.sakura.momo.comon.presenter.InteractorCallback;
import com.sakura.momo.comon.sharePref.PrefManager;
import com.sakura.momo.comon.utils.LogUtils;
import com.sakura.momo.comon.utils.Utils;
import com.sakura.momo.ui.payment.IPaymentInteractor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PaymentInteractorImpl
implements IPaymentInteractor {
    private static final String TAG = PaymentInteractorImpl.class.getName();
    private InteractorCallback mCallback;
    Call<VerifyPurchaseResponseObj> mVerifyPurchaseResponseObj;
    Call<ItemPayResponseObj> itemPayResponseObjCall;
    Call<InitialPurchaseResponseObj> initialPurchaseResponseObjCall;
    Call<RetryPaymentResponseObj> mRetryPaymentResponseObj;
    private MyCallback<RetryPaymentResponseObj> callbackRetryPayment = new MyCallback<RetryPaymentResponseObj>(){

        @Override
        public void onSuccess(Call<RetryPaymentResponseObj> call, Response<RetryPaymentResponseObj> response) {
            if (response.isSuccessful()) {
                PaymentInteractorImpl.this.mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<RetryPaymentResponseObj> call, Object object) {
            BaseObj obj = (BaseObj)object;
            RetryPaymentErrObj err = new RetryPaymentErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            PaymentInteractorImpl.this.mCallback.error(err);
        }
    };

    public PaymentInteractorImpl(InteractorCallback mCallback) {
        this.mCallback = mCallback;
    }

    @Override
    public void verifyPurchase(VerifyPurchaseRequestObj obj) {
        PaymentRequest request = ApiUtils.getPaymentRequest();
        this.mVerifyPurchaseResponseObj = request.verifyPurchase(obj.getOrder_no(), obj);
        LogUtils.d("RECEIPT", obj.getReceipt().toString());
        this.mVerifyPurchaseResponseObj.enqueue((Callback)new MyCallback<VerifyPurchaseResponseObj>(){

            @Override
            public void onSuccess(Call<VerifyPurchaseResponseObj> call, Response<VerifyPurchaseResponseObj> response) {
                if (response.isSuccessful()) {
                    PaymentInteractorImpl.this.mCallback.success(response.body());
                }
            }

            @Override
            public void onError(Call<VerifyPurchaseResponseObj> call, Object object) {
                BaseObj obj = (BaseObj)object;
                VerifyPurchaseErrObj err = new VerifyPurchaseErrObj();
                err.setMessage(obj.getMessage());
                err.setStatus(obj.getStatus());
                PaymentInteractorImpl.this.mCallback.error(err);
            }
        });
    }

    @Override
    public void getItemList() {
        PaymentRequest request = ApiUtils.getPaymentRequest();
        String method = "2";
        String appVer = Utils.getGameVersion((Context)BaraSdk.getInstance().getApplication());
        String appKey = PrefManager.getAppKey((Context)BaraSdk.getInstance().getApplication());
        String sdkVersion = Utils.stringNormalize(Utils.getSDKVersion((Context)BaraSdk.getInstance().getApplication()));
        this.itemPayResponseObjCall = request.getListItem(method, appKey, appVer, sdkVersion);
        this.itemPayResponseObjCall.enqueue((Callback)new MyCallback<ItemPayResponseObj>(){

            @Override
            public void onSuccess(Call<ItemPayResponseObj> call, Response<ItemPayResponseObj> response) {
                if (response.isSuccessful()) {
                    PaymentInteractorImpl.this.mCallback.success(response.body());
                }
            }

            @Override
            public void onError(Call<ItemPayResponseObj> call, Object object) {
                BaseObj obj = (BaseObj)object;
                GetListPurchaseErrObj err = new GetListPurchaseErrObj();
                err.setMessage(obj.getMessage());
                err.setStatus(obj.getStatus());
                PaymentInteractorImpl.this.mCallback.error(err);
            }
        });
    }

    @Override
    public void initialPurchase(InitalizePuchaseRequestObj initialPurchaseRequestObj) {
        PaymentRequest request = ApiUtils.getPaymentRequest();
        this.initialPurchaseResponseObjCall = request.initialPurchase(initialPurchaseRequestObj);
        this.initialPurchaseResponseObjCall.enqueue((Callback)new MyCallback<InitialPurchaseResponseObj>(){

            @Override
            public void onSuccess(Call<InitialPurchaseResponseObj> call, Response<InitialPurchaseResponseObj> response) {
                if (response.isSuccessful()) {
                    PaymentInteractorImpl.this.mCallback.success(response.body());
                }
            }

            @Override
            public void onError(Call<InitialPurchaseResponseObj> call, Object object) {
                BaseObj obj = (BaseObj)object;
                InitialPurchaseErrObj err = new InitialPurchaseErrObj();
                err.setMessage(obj.getMessage());
                err.setStatus(obj.getStatus());
                PaymentInteractorImpl.this.mCallback.error(err);
            }
        });
    }

    @Override
    public void cancelRequest(String ... tags) {
        if (this.mVerifyPurchaseResponseObj != null) {
            this.mVerifyPurchaseResponseObj.cancel();
        }
    }
}

