/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.ui.payment;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.bara.SakuraSDK;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.quby.R;
import com.sakura.momo.comon.object.ItemPayObj;
import com.sakura.momo.comon.utils.DeviceUtils;

public class PaymentAdapter
extends RecyclerView.Adapter<PaymentViewHolder> {
    ItemPayObj itemPayObj;
    int widthItem;
    int heightItem;
    int width;
    int height;
    Context context;
    OnClickItemPaymentListener onClickItemPaymentListener;

    public PaymentAdapter(Context context, ItemPayObj itemPayObj, OnClickItemPaymentListener onClickItemPaymentListener) {
        this.context = context;
        this.itemPayObj = itemPayObj;
        this.onClickItemPaymentListener = onClickItemPaymentListener;
        this.width = this.getScreenWidthInPixel();
        this.height = this.getScreenHeightInPixel();
        this.widthItem = this.width / itemPayObj.getConfig().getColumns();
        this.heightItem = this.height / itemPayObj.getConfig().getRows();
    }

    @NonNull
    public PaymentViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_payment, parent, false);
        return new PaymentViewHolder(view);
    }

    public void onBindViewHolder(@NonNull PaymentViewHolder holder, int position) {
        final ItemPayObj.Item item = this.itemPayObj.getItems().get(position);
        Log.d((String)PaymentAdapter.class.getSimpleName(), (String)("widthItem: " + this.widthItem + " , heightItem: " + this.heightItem));
        int orientation = this.context.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            LinearLayout.LayoutParams paramsMsg = new LinearLayout.LayoutParams((int)((double)this.widthItem * 0.75), -2);
            paramsMsg.gravity = 17;
            holder.imageView.setLayoutParams((ViewGroup.LayoutParams)paramsMsg);
        } else {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.widthItem, -2);
            params.gravity = 17;
            holder.imageView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        Glide.with((Context)SakuraSDK.getApplicationContext()).asBitmap().load(item.getImage()).apply(((RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.ALL)).fitCenter()).listener((RequestListener)new RequestListener<Bitmap>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource) {
                return false;
            }
        }).into(holder.imageView);
        holder.imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PaymentAdapter.this.onClickItemPaymentListener.onClickItem(v, item);
            }
        });
    }

    public int getItemCount() {
        return this.itemPayObj.getItems().isEmpty() ? 0 : this.itemPayObj.getItems().size();
    }

    public int getScreenWidthInPixel() {
        try {
            return this.context.getResources().getDisplayMetrics().widthPixels;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getScreenHeightInPixel() {
        try {
            return this.context.getResources().getDisplayMetrics().heightPixels - (int)(50.0f * DeviceUtils.getDensity(this.context));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static interface OnClickItemPaymentListener {
        public void onClickItem(View var1, ItemPayObj.Item var2);
    }

    public static class PaymentViewHolder
    extends RecyclerView.ViewHolder {
        ImageView imageView;

        public PaymentViewHolder(@NonNull View itemView) {
            super(itemView);
            this.imageView = (ImageView)itemView.findViewById(R.id.img_item_pay);
        }
    }
}

