/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.ui.other;

import com.sakura.momo.comon.presenter.BaseView;
import com.sakura.momo.comon.presenter.InteractorCallback;
import com.sakura.momo.ui.other.GameInteractorImpl;
import com.sakura.momo.ui.other.IGameInteractor;
import com.sakura.momo.ui.other.IGamePresenter;

public class GamePresenterImpl
implements IGamePresenter {
    private IGameInteractor mInteractor;
    private BaseView mBaseView;
    private final InteractorCallback<Object> mCallback = new InteractorCallback<Object>(){

        public void success(Object x) {
            if (GamePresenterImpl.this.mBaseView != null) {
                GamePresenterImpl.this.mBaseView.hideProgress();
                GamePresenterImpl.this.mBaseView.success(x);
            }
        }

        public void error(Object o) {
            if (GamePresenterImpl.this.mBaseView != null) {
                GamePresenterImpl.this.mBaseView.hideProgress();
                GamePresenterImpl.this.mBaseView.error(o);
            }
        }
    };

    public GamePresenterImpl(BaseView mBaseView) {
        this.mBaseView = mBaseView;
        this.mInteractor = new GameInteractorImpl(this.mCallback);
    }

    @Override
    public void cancelRequest(String ... tags) {
        this.mInteractor.cancelRequest(new String[0]);
    }

    @Override
    public void getMessagesInGame() {
        this.mInteractor.cancelRequest(new String[0]);
        this.mInteractor.getMessagesInGame();
    }

    @Override
    public void saveCharactor(String roleId, String areaId) throws Exception {
        this.mInteractor.cancelRequest(new String[0]);
        this.mInteractor.saveCharactor(roleId, areaId);
        if (this.mBaseView != null) {
            this.mBaseView.showProgress("");
        }
    }

    @Override
    public void saveFCM(String userId, String token) throws Exception {
        this.mInteractor.cancelRequest(new String[0]);
        this.mInteractor.saveFCM(userId, token);
        if (this.mBaseView != null) {
            this.mBaseView.showProgress("");
        }
    }

    @Override
    public void connectFaceBook(String token) throws Exception {
        this.mInteractor.cancelRequest(new String[0]);
        this.mInteractor.connectFaceBook(token);
        if (this.mBaseView != null) {
            this.mBaseView.showProgress("");
        }
    }
}

