/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.ui.login;

import android.app.Activity;
import com.sakura.momo.comon.config.AuthenConfigs;
import com.sakura.momo.comon.object.response.AuthenConfigResponseObj;
import com.sakura.momo.comon.object.response.LoginEmailResponseObj;
import com.sakura.momo.comon.object.response.LoginFacebookResponseObj;
import com.sakura.momo.comon.object.response.LoginGoogleResponseObj;
import com.sakura.momo.comon.object.response.LoginPlayNowResponseObj;
import com.sakura.momo.comon.presenter.BaseView;
import com.sakura.momo.comon.presenter.InteractorCallback;
import com.sakura.momo.ui.login.ILoginInteractor;
import com.sakura.momo.ui.login.ILoginPresenter;
import com.sakura.momo.ui.login.LoginInteractorImpl;

public class LoginPresenterImpl
implements ILoginPresenter {
    private ILoginInteractor mInteractor;
    private BaseView mBaseView;
    private static Activity activity;
    private final InteractorCallback<Object> mLoginCallback = new InteractorCallback<Object>(){

        public void success(Object x) {
            if (LoginPresenterImpl.this.mBaseView != null) {
                if (!(x instanceof LoginFacebookResponseObj || x instanceof LoginGoogleResponseObj || x instanceof LoginEmailResponseObj || x instanceof LoginPlayNowResponseObj)) {
                    LoginPresenterImpl.this.mBaseView.hideProgress();
                }
                LoginPresenterImpl.this.mBaseView.success(x);
            }
        }

        public void error(Object o) {
            if (LoginPresenterImpl.this.mBaseView != null) {
                LoginPresenterImpl.this.mBaseView.hideProgress();
                LoginPresenterImpl.this.mBaseView.error(o);
            }
        }
    };

    public LoginPresenterImpl(BaseView mBaseView) {
        this.mBaseView = mBaseView;
        this.mInteractor = new LoginInteractorImpl(this.mLoginCallback);
    }

    @Override
    public void cancelRequest(String ... tags) {
        this.mInteractor.cancelRequest(new String[0]);
    }

    @Override
    public void loginEmail(String user, String pass) {
        this.mInteractor.cancelRequest(new String[0]);
        this.mInteractor.loginEmail(user, pass);
        if (this.mBaseView != null) {
            this.mBaseView.showProgress("");
        }
    }

    @Override
    public void loginFtFacebook(String token) {
        this.mInteractor.cancelRequest(new String[0]);
        this.mInteractor.loginFtFacebook(token);
        if (this.mBaseView != null) {
            this.mBaseView.showProgress("");
        }
    }

    @Override
    public void loginFtGoogle(String token) {
        this.mInteractor.cancelRequest(new String[0]);
        this.mInteractor.loginFtGoogle(token);
        if (this.mBaseView != null) {
            this.mBaseView.showProgress("");
        }
    }

    @Override
    public void loginPlayNow() {
        this.mInteractor.cancelRequest(new String[0]);
        this.mInteractor.loginPlayNow();
        if (this.mBaseView != null) {
            this.mBaseView.showProgress("");
        }
    }

    @Override
    public void getAuthenConfig() {
        if (AuthenConfigs.getInstance().getAuthenConfigObj() != null) {
            AuthenConfigResponseObj obj = new AuthenConfigResponseObj();
            obj.setData(AuthenConfigs.getInstance().getAuthenConfigObj());
            this.mBaseView.success(obj);
            return;
        }
        this.mInteractor.cancelRequest(new String[0]);
        this.mInteractor.getAuthenConfig();
        if (this.mBaseView != null) {
            this.mBaseView.showProgress("");
        }
    }

    @Override
    public void getUser() {
        this.mInteractor.cancelRequest(new String[0]);
        this.mInteractor.getUser();
        if (this.mBaseView != null) {
            this.mBaseView.showProgress("");
        }
    }

    @Override
    public void getSdkConfig() {
        this.mInteractor.cancelRequest(new String[0]);
        this.mInteractor.getSdkConfig();
        if (this.mBaseView != null) {
            this.mBaseView.showProgress("");
        }
    }
}

