/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.ui.login;

import android.content.Context;
import com.sakura.momo.comon.api.ApiUtils;
import com.sakura.momo.comon.api.MyCallback;
import com.sakura.momo.comon.api.request.GameRequest;
import com.sakura.momo.comon.api.request.LoginRequest;
import com.sakura.momo.comon.game.BaraSdk;
import com.sakura.momo.comon.object.BaseObj;
import com.sakura.momo.comon.object.err.AuthenConfigErrObj;
import com.sakura.momo.comon.object.err.LoginEmailErrObj;
import com.sakura.momo.comon.object.err.LoginFacebookErrObj;
import com.sakura.momo.comon.object.err.LoginGGErrObj;
import com.sakura.momo.comon.object.err.LoginPlayNowErrObj;
import com.sakura.momo.comon.object.err.SdkConfigErrObj;
import com.sakura.momo.comon.object.err.UserErrObj;
import com.sakura.momo.comon.object.response.AuthenConfigResponseObj;
import com.sakura.momo.comon.object.response.LoginEmailResponseObj;
import com.sakura.momo.comon.object.response.LoginFacebookResponseObj;
import com.sakura.momo.comon.object.response.LoginGoogleResponseObj;
import com.sakura.momo.comon.object.response.LoginPlayNowResponseObj;
import com.sakura.momo.comon.object.response.SdkConfigResponseObj;
import com.sakura.momo.comon.object.response.UserResponseObj;
import com.sakura.momo.comon.presenter.InteractorCallback;
import com.sakura.momo.comon.sharePref.PrefManager;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.comon.utils.Utils;
import com.sakura.momo.ui.login.ILoginInteractor;
import java.util.Objects;
import retrofit2.Call;
import retrofit2.Response;

public class LoginInteractorImpl
implements ILoginInteractor {
    private static final String TAG = LoginInteractorImpl.class.getName();
    private InteractorCallback mCallback;
    private Call<LoginEmailResponseObj> mLoginRequest;
    private Call<UserResponseObj> mUserRequest;
    private Call<AuthenConfigResponseObj> mAuthenRequest;
    private Call<LoginPlayNowResponseObj> mLoginPlayNowRequest;
    private Call<SdkConfigResponseObj> mSdkConfigRequest;
    private Call<LoginFacebookResponseObj> mLoginFacebookRequest;
    private Call<LoginGoogleResponseObj> mLoginGGRequest;
    private MyCallback<LoginEmailResponseObj> callbackLoginEmail = new MyCallback<LoginEmailResponseObj>(){

        @Override
        public void onSuccess(Call<LoginEmailResponseObj> call, Response<LoginEmailResponseObj> response) {
            if (response.isSuccessful()) {
                LoginInteractorImpl.this.mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<LoginEmailResponseObj> call, Object object) {
            BaseObj obj = (BaseObj)object;
            LoginEmailErrObj err = new LoginEmailErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            LoginInteractorImpl.this.mCallback.error(err);
        }
    };
    private MyCallback<AuthenConfigResponseObj> callbackAuthen = new MyCallback<AuthenConfigResponseObj>(){

        @Override
        public void onSuccess(Call<AuthenConfigResponseObj> call, Response<AuthenConfigResponseObj> response) {
            if (response.isSuccessful()) {
                LoginInteractorImpl.this.mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<AuthenConfigResponseObj> call, Object object) {
            BaseObj obj = (BaseObj)object;
            AuthenConfigErrObj err = new AuthenConfigErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            LoginInteractorImpl.this.mCallback.error(err);
        }
    };
    private MyCallback<UserResponseObj> callbackUser = new MyCallback<UserResponseObj>(){

        @Override
        public void onSuccess(Call<UserResponseObj> call, Response<UserResponseObj> response) {
            if (response.isSuccessful()) {
                LoginInteractorImpl.this.mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<UserResponseObj> call, Object object) {
            BaseObj obj = (BaseObj)object;
            UserErrObj err = new UserErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            LoginInteractorImpl.this.mCallback.error(err);
        }
    };
    private MyCallback<LoginPlayNowResponseObj> callbackLoginPlayNow = new MyCallback<LoginPlayNowResponseObj>(){

        @Override
        public void onSuccess(Call<LoginPlayNowResponseObj> call, Response<LoginPlayNowResponseObj> response) {
            if (response.isSuccessful()) {
                LoginInteractorImpl.this.mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<LoginPlayNowResponseObj> call, Object object) {
            BaseObj obj = (BaseObj)object;
            LoginPlayNowErrObj err = new LoginPlayNowErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            LoginInteractorImpl.this.mCallback.error(err);
        }
    };
    private MyCallback<SdkConfigResponseObj> callbackGetSdk = new MyCallback<SdkConfigResponseObj>(){

        @Override
        public void onSuccess(Call<SdkConfigResponseObj> call, Response<SdkConfigResponseObj> response) {
            if (response.isSuccessful()) {
                LoginInteractorImpl.this.mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<SdkConfigResponseObj> call, Object object) {
            BaseObj obj = (BaseObj)object;
            SdkConfigErrObj err = new SdkConfigErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            LoginInteractorImpl.this.mCallback.error(err);
        }
    };
    private MyCallback<LoginFacebookResponseObj> callbackLoginFacebook = new MyCallback<LoginFacebookResponseObj>(){

        @Override
        public void onSuccess(Call<LoginFacebookResponseObj> call, Response<LoginFacebookResponseObj> response) {
            if (response.isSuccessful()) {
                LoginInteractorImpl.this.mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<LoginFacebookResponseObj> call, Object object) {
            BaseObj obj = (BaseObj)object;
            LoginFacebookErrObj err = new LoginFacebookErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            LoginInteractorImpl.this.mCallback.error(err);
        }
    };
    private MyCallback<LoginGoogleResponseObj> callbackLoginGG = new MyCallback<LoginGoogleResponseObj>(){

        @Override
        public void onSuccess(Call<LoginGoogleResponseObj> call, Response<LoginGoogleResponseObj> response) {
            if (response.isSuccessful()) {
                LoginInteractorImpl.this.mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<LoginGoogleResponseObj> call, Object object) {
            BaseObj obj = (BaseObj)object;
            LoginGGErrObj err = new LoginGGErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            LoginInteractorImpl.this.mCallback.error(err);
        }
    };

    public LoginInteractorImpl(InteractorCallback mCallback) {
        this.mCallback = mCallback;
    }

    @Override
    public void loginEmail(String user, String pass) {
        LoginRequest request = ApiUtils.getLoginRequest();
        String deviceOs = DeviceUtils.getOSInfo();
        String deviceName = DeviceUtils.getDevice();
        String deviceResolution = Objects.requireNonNull(DeviceUtils.getResolution((Context)BaraSdk.getInstance().getApplication()));
        String deviceNetwork = Utils.getNetwork((Context)BaraSdk.getInstance().getApplication());
        String appVer = Utils.getGameVersion((Context)BaraSdk.getInstance().getApplication());
        String sdkVer = Utils.getSDKVersion((Context)BaraSdk.getInstance().getApplication());
        String appKey = PrefManager.getAppKey((Context)BaraSdk.getInstance().getApplication());
        String appfyerKey = DeviceUtils.getAppsflyerUID((Context)BaraSdk.getInstance().getApplication());
        String advertising_id = DeviceUtils.getAdvertisingID((Context)BaraSdk.getInstance().getApplication());
        this.mLoginRequest = Objects.requireNonNull(request).loginEmail(appKey, appVer, user, pass, deviceOs, deviceName, deviceResolution, deviceNetwork, sdkVer, appfyerKey, advertising_id);
        this.mLoginRequest.enqueue(this.callbackLoginEmail);
    }

    @Override
    public void getAuthenConfig() {
        GameRequest request = ApiUtils.getGameRequest();
        String appVer = Utils.getGameVersion((Context)BaraSdk.getInstance().getApplication());
        String appKey = PrefManager.getAppKey((Context)BaraSdk.getInstance().getApplication());
        this.mAuthenRequest = Objects.requireNonNull(request).getAuthenConfig(appKey, appVer);
        this.mAuthenRequest.enqueue(this.callbackAuthen);
    }

    @Override
    public void getUser() {
        LoginRequest request = ApiUtils.getLoginRequest();
        String deviceOs = DeviceUtils.getOSInfo();
        String deviceName = DeviceUtils.getDevice();
        String deviceResolution = Objects.requireNonNull(DeviceUtils.getResolution((Context)BaraSdk.getInstance().getApplication()));
        String deviceNetwork = Utils.getNetwork((Context)BaraSdk.getInstance().getApplication());
        String appVer = Utils.getGameVersion((Context)BaraSdk.getInstance().getApplication());
        String sdkVer = Utils.getSDKVersion((Context)BaraSdk.getInstance().getApplication());
        String appKey = PrefManager.getAppKey((Context)BaraSdk.getInstance().getApplication());
        this.mUserRequest = Objects.requireNonNull(request).getUser(appKey, appVer, deviceOs, deviceName, deviceResolution, deviceNetwork, sdkVer);
        this.mUserRequest.enqueue(this.callbackUser);
    }

    @Override
    public void loginPlayNow() {
        String deviceId = DeviceUtils.getUniqueDeviceID((Context)BaraSdk.getInstance().getApplication());
        String deviceOs = DeviceUtils.getOSInfo();
        String deviceName = DeviceUtils.getDevice();
        String deviceResolution = Objects.requireNonNull(DeviceUtils.getResolution((Context)BaraSdk.getInstance().getApplication()));
        String deviceNetwork = Utils.getNetwork((Context)BaraSdk.getInstance().getApplication());
        String appVer = Utils.getGameVersion((Context)BaraSdk.getInstance().getApplication());
        String sdkVer = Utils.getSDKVersion((Context)BaraSdk.getInstance().getApplication());
        LoginRequest request = ApiUtils.getLoginRequest();
        String appKey = PrefManager.getAppKey((Context)BaraSdk.getInstance().getApplication());
        String appfyerKey = DeviceUtils.getAppsflyerUID((Context)BaraSdk.getInstance().getApplication());
        String advertising_id = DeviceUtils.getAdvertisingID((Context)BaraSdk.getInstance().getApplication());
        this.mLoginPlayNowRequest = Objects.requireNonNull(request).loginPlayNow(appKey, appVer, deviceId, deviceOs, deviceName, deviceResolution, deviceNetwork, sdkVer, appfyerKey, advertising_id);
        this.mLoginPlayNowRequest.enqueue(this.callbackLoginPlayNow);
    }

    @Override
    public void loginFtFacebook(String token) {
        LoginRequest request = ApiUtils.getLoginRequest();
        String deviceOs = DeviceUtils.getOSInfo();
        String deviceName = DeviceUtils.getDevice();
        String deviceResolution = Objects.requireNonNull(DeviceUtils.getResolution((Context)BaraSdk.getInstance().getApplication()));
        String deviceNetwork = Utils.getNetwork((Context)BaraSdk.getInstance().getApplication());
        String appVer = Utils.getGameVersion((Context)BaraSdk.getInstance().getApplication());
        String sdkVer = Utils.getSDKVersion((Context)BaraSdk.getInstance().getApplication());
        String appKey = PrefManager.getAppKey((Context)BaraSdk.getInstance().getApplication());
        String appfyerKey = DeviceUtils.getAppsflyerUID((Context)BaraSdk.getInstance().getApplication());
        String advertising_id = DeviceUtils.getAdvertisingID((Context)BaraSdk.getInstance().getApplication());
        this.mLoginFacebookRequest = Objects.requireNonNull(request).loginFacebook(appKey, appVer, token, deviceOs, deviceName, deviceResolution, deviceNetwork, sdkVer, appfyerKey, advertising_id);
        this.mLoginFacebookRequest.enqueue(this.callbackLoginFacebook);
    }

    @Override
    public void loginFtGoogle(String token) {
        LoginRequest request = ApiUtils.getLoginRequest();
        String deviceOs = DeviceUtils.getOSInfo();
        String deviceName = DeviceUtils.getDevice();
        String deviceResolution = Objects.requireNonNull(DeviceUtils.getResolution((Context)BaraSdk.getInstance().getApplication()));
        String deviceNetwork = Utils.getNetwork((Context)BaraSdk.getInstance().getApplication());
        String appVer = Utils.getGameVersion((Context)BaraSdk.getInstance().getApplication());
        String sdkVer = Utils.getSDKVersion((Context)BaraSdk.getInstance().getApplication());
        String appKey = PrefManager.getAppKey((Context)BaraSdk.getInstance().getApplication());
        String appfyerKey = DeviceUtils.getAppsflyerUID((Context)BaraSdk.getInstance().getApplication());
        String advertising_id = DeviceUtils.getAdvertisingID((Context)BaraSdk.getInstance().getApplication());
        this.mLoginGGRequest = Objects.requireNonNull(request).loginGoogle(appKey, appVer, token, deviceOs, deviceName, deviceResolution, deviceNetwork, sdkVer, appfyerKey, advertising_id);
        this.mLoginGGRequest.enqueue(this.callbackLoginGG);
    }

    @Override
    public void getSdkConfig() {
        GameRequest request = ApiUtils.getGameRequest();
        String gameVersion = Utils.getGameVersion((Context)BaraSdk.getInstance().getApplication());
        String appKey = PrefManager.getAppKey((Context)BaraSdk.getInstance().getApplication());
        this.mSdkConfigRequest = Objects.requireNonNull(request).getSdkConfig(appKey, gameVersion);
        this.mSdkConfigRequest.enqueue(this.callbackGetSdk);
    }

    @Override
    public void cancelRequest(String ... tags) {
        if (this.mLoginRequest != null) {
            this.mLoginRequest.cancel();
        }
        if (this.mAuthenRequest != null) {
            this.mAuthenRequest.cancel();
        }
        if (this.mUserRequest != null) {
            this.mUserRequest.cancel();
        }
        if (this.mLoginPlayNowRequest != null) {
            this.mLoginPlayNowRequest.cancel();
        }
        if (this.mLoginFacebookRequest != null) {
            this.mLoginFacebookRequest.cancel();
        }
        if (this.mSdkConfigRequest != null) {
            this.mSdkConfigRequest.cancel();
        }
        if (this.mLoginGGRequest != null) {
            this.mLoginGGRequest.cancel();
        }
    }
}

