/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.ui.login;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.bara.SakuraSDK;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.facebook.FacebookException;
import com.facebook.login.LoginResult;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.material.textfield.TextInputEditText;
import com.quby.R;
import com.sakura.momo.comon.api.ApiUtils;
import com.sakura.momo.comon.api.RetrofitClient;
import com.sakura.momo.comon.config.AuthenConfigs;
import com.sakura.momo.comon.config.GameConfigs;
import com.sakura.momo.comon.constants.Constants;
import com.sakura.momo.comon.game.BaraSdk;
import com.sakura.momo.comon.game.BaseDialogFragment;
import com.sakura.momo.comon.listener.IAuthentFBListener;
import com.sakura.momo.comon.listener.IAuthentGoogleListener;
import com.sakura.momo.comon.listener.ILoginListener;
import com.sakura.momo.comon.login.FacebookManager;
import com.sakura.momo.comon.login.GoogleManager;
import com.sakura.momo.comon.object.AuthenConfigObj;
import com.sakura.momo.comon.object.BaseObj;
import com.sakura.momo.comon.object.UserObj;
import com.sakura.momo.comon.object.err.AuthenConfigErrObj;
import com.sakura.momo.comon.object.err.LoginEmailErrObj;
import com.sakura.momo.comon.object.err.LoginFacebookErrObj;
import com.sakura.momo.comon.object.err.LoginGGErrObj;
import com.sakura.momo.comon.object.err.LoginPlayNowErrObj;
import com.sakura.momo.comon.object.err.SdkConfigErrObj;
import com.sakura.momo.comon.object.response.AuthenConfigResponseObj;
import com.sakura.momo.comon.object.response.LoginByRegisterObj;
import com.sakura.momo.comon.object.response.LoginEmailResponseObj;
import com.sakura.momo.comon.object.response.LoginFacebookResponseObj;
import com.sakura.momo.comon.object.response.LoginGoogleResponseObj;
import com.sakura.momo.comon.object.response.LoginPlayNowResponseObj;
import com.sakura.momo.comon.object.response.SdkConfigResponseObj;
import com.sakura.momo.comon.presenter.BaseView;
import com.sakura.momo.comon.tracking.SakuraTracking;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.comon.utils.DialogUtils;
import com.sakura.momo.comon.utils.KeyboardHeightObserver;
import com.sakura.momo.comon.utils.KeyboardHeightProvider;
import com.sakura.momo.comon.utils.LogUtils;
import com.sakura.momo.comon.utils.NetworkUtils;
import com.sakura.momo.comon.utils.StringUtils;
import com.sakura.momo.ui.login.ILoginPresenter;
import com.sakura.momo.ui.login.LoginPresenterImpl;
import com.sakura.momo.ui.login.term.TermDialogFragment;
import com.sakura.momo.ui.register.RegistryFragment;
import java.util.Objects;

public class LoginFragment
extends BaseDialogFragment
implements View.OnClickListener,
BaseView,
IAuthentFBListener,
IAuthentGoogleListener,
KeyboardHeightObserver {
    ImageButton btnFaceBook;
    ImageButton btnPlayNow;
    ImageButton btnGoogle;
    TextInputEditText edtLoginPassword;
    TextInputEditText edtLoginAccount;
    ImageButton btnClose;
    TextView btnLogin;
    TextView tvTerm;
    TextView tvPlayTimeNoti;
    TextView tvRegister;
    TextView btnLoginCenter;
    TextView tvSignal;
    TextView tv_or_login;
    Button buttonOk;
    ImageView iv18Plus;
    ILoginPresenter loginPresenter;
    LinearLayout termContent;
    LinearLayout layout_content_top;
    LinearLayout contentIv18;
    LinearLayout layout_content_bottom;
    LinearLayout btnLoginFacebook2;
    LinearLayout btnGoogle2;
    LinearLayout btnLoginPlayNow2;
    ConstraintLayout layout_content_mid;
    ILoginListener listener;
    TextView tvErrUser;
    TextView tvErrPass;
    TextView tvForgotPass;
    TextView tvHeaderLoginSocial;
    Handler mHandler;
    Runnable mRunnable;
    Constants.RTF_STATUS status;
    LinearLayout layoutKeyboardSpace;
    private KeyboardHeightProvider keyboardProvider;
    int errEmailCount;
    CardView contentPanel;
    private static final String TAG = LoginFragment.class.getSimpleName();
    DialogFragment newFragment;
    ILoginListener registerListener = new ILoginListener(){

        @Override
        public void onLoginSuccess() {
        }

        @Override
        public void onRegisterSuccess(String param) {
            LoginFragment.this.newFragment.dismiss();
            LoginFragment.this.newFragment = null;
            try {
                LoginByRegisterObj obj = LoginByRegisterObj.parse(param);
                obj.getData().setLoginType("Email");
                obj.getData().setLoginOrRegister(obj.getIsRegister());
                LoginFragment.this.onLoginSuccess(obj.getData(), obj.getAccessToken());
                LoginFragment.this.loginPresenter.getSdkConfig();
                if (LoginFragment.this.listener != null) {
                    LoginFragment.this.listener.onRegisterSuccess(param);
                }
            }
            catch (Exception e) {
                DialogUtils.showErrorDialog(LoginFragment.this.mActivity, LoginFragment.this.getString(R.string.err_422));
            }
        }
    };
    private BroadcastReceiver networkChangeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (AuthenConfigs.getInstance().getAuthenConfigObj() == null) {
                LoginFragment.this.loginPresenter.getAuthenConfig();
            }
        }
    };

    public static LoginFragment newInstance(ILoginListener listener) {
        LoginFragment frag = new LoginFragment();
        frag.setListener(listener);
        Bundle bulde = new Bundle();
        frag.setArguments(bulde);
        return frag;
    }

    public void onStart() {
        super.onStart();
        Dialog d = this.getDialog();
        if (d != null) {
            int width = -1;
            int height = -1;
            Objects.requireNonNull(d.getWindow()).setLayout(width, height);
        }
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.fragment_account_container;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    @Override
    public void onResume() {
        super.onResume();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mActivity.registerReceiver(this.networkChangeReceiver, intentFilter);
        this.getDialog().getWindow().clearFlags(8);
        this.loginPresenter.getAuthenConfig();
        this.keyboardProvider.setKeyboardHeightObserver(this);
    }

    public void onDetach() {
        super.onDetach();
        this.keyboardProvider.close();
    }

    public void initView(View v) {
        this.mHandler = new Handler();
        this.loginPresenter = new LoginPresenterImpl(this);
        this.iv18Plus = (ImageView)v.findViewById(R.id.iv18Plus);
        this.layoutKeyboardSpace = (LinearLayout)v.findViewById(R.id.layout_keyboard_space);
        this.edtLoginAccount = (TextInputEditText)v.findViewById(R.id.edtLoginAccount);
        this.edtLoginPassword = (TextInputEditText)v.findViewById(R.id.edtLoginPassword);
        this.tvTerm = (TextView)v.findViewById(R.id.tvTerm);
        this.tvPlayTimeNoti = (TextView)v.findViewById(R.id.tvPlayTimeNoti);
        this.layout_content_top = (LinearLayout)v.findViewById(R.id.layout_content_top);
        this.layout_content_mid = (ConstraintLayout)v.findViewById(R.id.layout_content_mid);
        this.termContent = (LinearLayout)v.findViewById(R.id.termContent);
        this.contentIv18 = (LinearLayout)v.findViewById(R.id.contentIv18);
        this.btnFaceBook = (ImageButton)v.findViewById(R.id.btnFacebook);
        this.btnGoogle = (ImageButton)v.findViewById(R.id.btnGoogle);
        this.btnLogin = (TextView)v.findViewById(R.id.btnLogin);
        this.tvRegister = (TextView)v.findViewById(R.id.tvRegister);
        this.tvSignal = (TextView)v.findViewById(R.id.tvSignal);
        this.tv_or_login = (TextView)v.findViewById(R.id.tv_or_login);
        this.btnPlayNow = (ImageButton)v.findViewById(R.id.btnPlayNow);
        this.btnClose = (ImageButton)v.findViewById(R.id.btnClose);
        this.tvErrUser = (TextView)v.findViewById(R.id.tvErrUser);
        this.tvErrPass = (TextView)v.findViewById(R.id.tvErrPass);
        this.tvForgotPass = (TextView)v.findViewById(R.id.tvForgotPass);
        this.tvHeaderLoginSocial = (TextView)v.findViewById(R.id.tvHeaderLoginSocial);
        this.contentPanel = (CardView)v.findViewById(R.id.contentPanel);
        this.layout_content_bottom = (LinearLayout)v.findViewById(R.id.layout_content_bottom);
        this.btnLoginFacebook2 = (LinearLayout)v.findViewById(R.id.btnLoginFacebook2);
        this.btnGoogle2 = (LinearLayout)v.findViewById(R.id.btnGoogle2);
        this.btnLoginPlayNow2 = (LinearLayout)v.findViewById(R.id.btnLoginPlayNow2);
        this.tvTerm.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.lbl_term)));
        this.edtLoginAccount.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                LoginFragment.this.tvErrUser.setVisibility(8);
            }
        });
        this.edtLoginPassword.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                LoginFragment.this.tvErrPass.setVisibility(8);
            }
        });
        this.edtLoginPassword.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                boolean handled = false;
                if (actionId == 4) {
                    DeviceUtils.hideKeyboardFrom((Context)LoginFragment.this.mActivity, (View)v);
                    LoginFragment.this.onLoginEmail();
                    handled = true;
                }
                return handled;
            }
        });
        this.btnFaceBook.setOnClickListener((View.OnClickListener)this);
        this.btnPlayNow.setOnClickListener((View.OnClickListener)this);
        this.btnLogin.setOnClickListener((View.OnClickListener)this);
        this.btnClose.setOnClickListener((View.OnClickListener)this);
        this.btnGoogle.setOnClickListener((View.OnClickListener)this);
        this.tvTerm.setOnClickListener((View.OnClickListener)this);
        this.tvRegister.setOnClickListener((View.OnClickListener)this);
        this.tvForgotPass.setOnClickListener((View.OnClickListener)this);
        this.layout_content_bottom.setOnClickListener((View.OnClickListener)this);
        this.btnLoginFacebook2.setOnClickListener((View.OnClickListener)this);
        this.btnGoogle2.setOnClickListener((View.OnClickListener)this);
        this.btnLoginPlayNow2.setOnClickListener((View.OnClickListener)this);
        this.errEmailCount = 0;
        this.keyboardProvider = new KeyboardHeightProvider(this.mActivity);
        this.keyboardProvider.start();
    }

    public void showRegisterDialog() {
        this.newFragment = (DialogFragment)this.mActivity.getFragmentManager().findFragmentByTag(RegistryFragment.class.getSimpleName());
        if (this.newFragment == null) {
            this.newFragment = RegistryFragment.newInstance(this.registerListener);
        }
        this.newFragment.setCancelable(true);
        if (this.newFragment.getDialog() != null && this.newFragment.getDialog().isShowing()) {
            return;
        }
        this.newFragment.show(this.mActivity.getFragmentManager(), RegistryFragment.class.getSimpleName());
    }

    public void showTermDialog() {
        DialogFragment newFragment = (DialogFragment)this.mActivity.getFragmentManager().findFragmentByTag(TermDialogFragment.class.getSimpleName());
        if (newFragment == null) {
            newFragment = TermDialogFragment.newInstance(ApiUtils.getUrlTerm((Context)this.mActivity));
        }
        newFragment.setCancelable(true);
        if (newFragment.getDialog() != null && newFragment.getDialog().isShowing()) {
            return;
        }
        newFragment.show(this.mActivity.getFragmentManager(), TermDialogFragment.class.getSimpleName());
    }

    private void onLoginEmail() {
        if (!NetworkUtils.checkNetwork(this.mActivity)) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.error_network));
            return;
        }
        if (GameConfigs.getInstance().isLogin()) {
            return;
        }
        if (this.errEmailCount >= 5) {
            DialogUtils.showErrorInputDialog(this.mActivity, this.mActivity.getString(R.string.err_input_more_than_5), new DialogUtils.DlgCloseListener(){

                @Override
                public void onClose() {
                    LoginFragment.this.errEmailCount = 0;
                    LoginFragment.this.onLoginPlayNow();
                }
            }, new DialogUtils.DlgCloseListener(){

                @Override
                public void onClose() {
                    LoginFragment.this.errEmailCount = 0;
                }
            });
            return;
        }
        SakuraTracking.getInstance().trackClickLoginEmailButton();
        String user = this.edtLoginAccount.getText().toString();
        String pass = this.edtLoginPassword.getText().toString();
        String checkUser = StringUtils.validateUser((Context)this.mActivity, user);
        if (!checkUser.isEmpty()) {
            SakuraTracking.getInstance().trackLoginEmailInputError(1, checkUser);
            this.tvErrUser.setVisibility(0);
            this.tvErrUser.setText((CharSequence)checkUser);
            this.edtLoginAccount.setBackground(this.mActivity.getResources().getDrawable(R.drawable.slt_input_text_login_err));
            this.edtLoginAccount.requestFocus();
            ++this.errEmailCount;
            return;
        }
        String checkPass = StringUtils.validatePassword((Context)this.mActivity, pass);
        if (!checkPass.isEmpty()) {
            SakuraTracking.getInstance().trackLoginEmailInputError(2, checkPass);
            this.tvErrPass.setVisibility(0);
            this.tvErrPass.setText((CharSequence)checkPass);
            this.edtLoginPassword.setBackground(this.mActivity.getResources().getDrawable(R.drawable.slt_input_text_login_err));
            this.edtLoginPassword.requestFocus();
            ++this.errEmailCount;
            return;
        }
        SakuraTracking.getInstance().trackLoginEmailCallApi();
        this.loginPresenter.loginEmail(user, pass);
    }

    private void onLoginPlayNow() {
        if (!NetworkUtils.checkNetwork(this.mActivity)) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.error_network));
            return;
        }
        if (GameConfigs.getInstance().isLogin()) {
            return;
        }
        SakuraTracking.getInstance().trackLoginPlayNowCallApi();
        this.loginPresenter.loginPlayNow();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 9700: {
                GoogleManager.getInstance((Context)this.mActivity).onAuthGoogleResult(data, resultCode);
                break;
            }
            case 64206: {
                FacebookManager.getInstance((Context)this.mActivity).onAuthResult(requestCode, resultCode, data);
                break;
            }
        }
    }

    public void onClick(final View v) {
        if (this.mHandler != null && this.mRunnable != null) {
            this.mHandler.removeCallbacks(this.mRunnable);
        }
        this.mRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DeviceUtils.hideKeyboardFrom((Context)LoginFragment.this.mActivity, v);
                    if (v.getId() == R.id.btnFacebook || v.getId() == R.id.btnLoginFacebook2) {
                        if (LoginFragment.this.status == Constants.RTF_STATUS.AUTHENING) {
                            return;
                        }
                        LoginFragment.this.status = Constants.RTF_STATUS.AUTHENING;
                        LoginFragment.this.authenFacebook();
                    } else if (v.getId() == R.id.btnGoogle || v.getId() == R.id.btnGoogle2) {
                        if (LoginFragment.this.status == Constants.RTF_STATUS.AUTHENING) {
                            return;
                        }
                        LoginFragment.this.status = Constants.RTF_STATUS.AUTHENING;
                        LoginFragment.this.authenGooogle();
                    } else if (v.getId() == R.id.btnLogin) {
                        LoginFragment.this.onLoginEmail();
                    } else if (v.getId() == R.id.btnClose) {
                        SakuraTracking.getInstance().trackLoginScreenClose((View)LoginFragment.this.contentPanel, (View)LoginFragment.this.edtLoginAccount, (View)LoginFragment.this.btnLogin);
                        LoginFragment.this.dismiss();
                    } else if (v.getId() == R.id.btnPlayNow || v.getId() == R.id.btnLoginPlayNow2) {
                        LoginFragment.this.onLoginPlayNow();
                    } else if (v.getId() == R.id.tvTerm) {
                        LoginFragment.this.showTermDialog();
                    } else if (v.getId() == R.id.tvRegister) {
                        SakuraTracking.getInstance().trackClickBtnRegister();
                        LoginFragment.this.showRegisterDialog();
                    } else if (v.getId() == R.id.tvForgotPass) {
                        DialogUtils.showInfoDialog(LoginFragment.this.mActivity, LoginFragment.this.getString(R.string.notice), LoginFragment.this.getString(R.string.info_forget_pass));
                        SakuraTracking.getInstance().trackForgotPassword();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    LoginFragment.this.mHandler = null;
                    LoginFragment.this.mRunnable = null;
                }
            }
        };
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        }
        this.mHandler.postDelayed(this.mRunnable, 150L);
    }

    private void authenFacebook() {
        if (!NetworkUtils.checkNetwork(this.mActivity)) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.error_network));
            return;
        }
        SakuraTracking.getInstance().trackClickLoginFacebookButton();
        if (this.isAdded()) {
            FacebookManager.getInstance((Context)this.mActivity).startAuth((Fragment)this, this);
        }
    }

    private void authenGooogle() {
        if (!NetworkUtils.checkNetwork(this.mActivity)) {
            DialogUtils.showErrorDialog(this.mActivity, this.mActivity.getString(R.string.error_network));
            return;
        }
        SakuraTracking.getInstance().trackClickLoginGoogleButton();
        if (this.isAdded()) {
            GoogleManager.getInstance((Context)this.mActivity).startAuthForResult(this, (IAuthentGoogleListener)this);
        }
    }

    public void show(FragmentManager manager, String tag) {
        super.show(manager, tag);
        SakuraTracking.getInstance().trackLoginScreenOpen();
    }

    public void applyConfig(@NonNull AuthenConfigObj obj) {
        AuthenConfigObj.LoginConfig cf = obj.getLoginConfig();
        if (cf == null) {
            return;
        }
        if (cf.getLogin_google() == 0 & cf.getLogin_facebook() == 0 && cf.getPlay_now() == 0 && cf.getLogin_email() == 0) {
            this.getView().setVisibility(8);
            this.onLoginPlayNow();
        }
        if (cf.getLogin_email() == 0) {
            this.layout_content_top.setVisibility(8);
            this.tv_or_login.setVisibility(8);
        }
        if (obj.getRegisterConfig() == 1) {
            this.btnLogin.setVisibility(0);
            this.tvRegister.setVisibility(0);
        } else {
            this.btnLogin.setVisibility(8);
            this.tvRegister.setVisibility(8);
        }
        this.btnFaceBook.setVisibility(cf.getLogin_facebook() == 0 ? 8 : 0);
        this.btnLoginFacebook2.setVisibility(cf.getLogin_facebook() == 0 ? 8 : 0);
        this.btnGoogle.setVisibility(cf.getLogin_google() == 0 ? 8 : 0);
        this.btnGoogle2.setVisibility(cf.getLogin_google() == 0 ? 8 : 0);
        this.btnPlayNow.setVisibility(cf.getPlay_now() == 0 ? 8 : 0);
        this.btnLoginPlayNow2.setVisibility(cf.getPlay_now() == 0 ? 8 : 0);
        this.layout_content_top.setVisibility(cf.getLogin_email() == 0 ? 8 : 0);
        this.tv_or_login.setVisibility(cf.getLogin_email() == 0 ? 8 : 0);
        this.layout_content_mid.setVisibility(cf.getLogin_email() == 0 ? 8 : 0);
        this.layout_content_bottom.setVisibility(cf.getLogin_email() == 0 ? 0 : 8);
        if (cf.getPlay_now() == 0 && cf.getLogin_google() == 0 && cf.getLogin_facebook() == 0) {
            this.layout_content_mid.setVisibility(8);
        }
        if (obj.getLogoOlder() == null || obj.getLogoOlder().getUrl() == null && obj.getLogoOlder().getText() == null) {
            this.contentIv18.setVisibility(8);
        }
        if (obj.getLogoOlder() != null && obj.getLogoOlder().getUrl() != null) {
            RequestOptions options = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().centerInside()).placeholder(R.drawable.icon_18)).error(R.drawable.icon_18)).priority(Priority.HIGH);
            Glide.with((Activity)this.mActivity).load(obj.getLogoOlder().getUrl()).apply((BaseRequestOptions)options).into(this.iv18Plus);
        } else {
            this.iv18Plus.setVisibility(8);
        }
        if (obj.getLogoOlder() != null && obj.getLogoOlder().getText() != null) {
            this.tvPlayTimeNoti.setText((CharSequence)obj.getLogoOlder().getText());
        }
        ViewGroup.MarginLayoutParams paramBtnGoogle = (ViewGroup.MarginLayoutParams)this.btnGoogle.getLayoutParams();
        ViewGroup.MarginLayoutParams paramBtnFacebook = (ViewGroup.MarginLayoutParams)this.btnFaceBook.getLayoutParams();
        ViewGroup.MarginLayoutParams paramBtnPlayNow = (ViewGroup.MarginLayoutParams)this.btnPlayNow.getLayoutParams();
        if (this.btnFaceBook.getVisibility() == 0 && this.btnGoogle.getVisibility() == 0 && this.btnPlayNow.getVisibility() == 0) {
            paramBtnGoogle.leftMargin = 12;
            paramBtnGoogle.rightMargin = 12;
            this.btnGoogle.setLayoutParams((ViewGroup.LayoutParams)paramBtnGoogle);
        } else if (this.btnFaceBook.getVisibility() == 8 && this.btnGoogle.getVisibility() == 0 && this.btnPlayNow.getVisibility() == 0) {
            paramBtnGoogle.rightMargin = 12;
            this.btnGoogle.setLayoutParams((ViewGroup.LayoutParams)paramBtnGoogle);
        } else if (this.btnGoogle.getVisibility() == 8 && this.btnFaceBook.getVisibility() == 0 && this.btnPlayNow.getVisibility() == 0) {
            paramBtnFacebook.rightMargin = 6;
            paramBtnPlayNow.leftMargin = 6;
            this.btnFaceBook.setLayoutParams((ViewGroup.LayoutParams)paramBtnFacebook);
            this.btnPlayNow.setLayoutParams((ViewGroup.LayoutParams)paramBtnPlayNow);
        } else if (this.btnPlayNow.getVisibility() == 8 && this.btnFaceBook.getVisibility() == 0 && this.btnGoogle.getVisibility() == 0) {
            paramBtnGoogle.leftMargin = 6;
            paramBtnFacebook.rightMargin = 6;
            this.btnFaceBook.setLayoutParams((ViewGroup.LayoutParams)paramBtnFacebook);
            this.btnGoogle.setLayoutParams((ViewGroup.LayoutParams)paramBtnGoogle);
        }
        if (obj.getRegisterConfig() == 0) {
            this.tvRegister.setVisibility(8);
            this.tvSignal.setVisibility(8);
            this.tv_or_login.setVisibility(8);
        }
    }

    @Override
    public void showProgress(String mess) {
        this.showProgressDialog(true, mess);
    }

    @Override
    public void hideProgress() {
        this.showProgressDialog(false, "");
    }

    public void success(Object x) {
        if (x instanceof AuthenConfigResponseObj) {
            AuthenConfigObj obj = ((AuthenConfigResponseObj)x).getData();
            AuthenConfigs.getInstance().setAuthenConfigObj(obj);
            this.applyConfig(obj);
            SakuraTracking.getInstance().trackCallAuthenConfigSuccess();
        } else if (x instanceof LoginPlayNowResponseObj) {
            SakuraTracking.getInstance().trackLoginPlayNowCallApiSuccess();
            LoginPlayNowResponseObj obj = (LoginPlayNowResponseObj)x;
            obj.getData().setLoginType("PlayNow");
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            this.onLoginSuccess(obj.getData(), obj.getAccessToken());
            this.loginPresenter.getSdkConfig();
        } else if (x instanceof LoginEmailResponseObj) {
            SakuraTracking.getInstance().trackLoginEmailCallApiSuccess();
            LoginEmailResponseObj obj = (LoginEmailResponseObj)x;
            obj.getData().setLoginType("Email");
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            this.onLoginSuccess(obj.getData(), obj.getAccessToken());
            this.loginPresenter.getSdkConfig();
        } else if (x instanceof LoginFacebookResponseObj) {
            SakuraTracking.getInstance().trackLoginFacebookCallApiSuccess();
            LoginFacebookResponseObj obj = (LoginFacebookResponseObj)x;
            obj.getData().setLoginType("Facebook");
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            this.onLoginSuccess(obj.getData(), obj.getAccessToken());
            this.loginPresenter.getSdkConfig();
        } else if (x instanceof LoginGoogleResponseObj) {
            SakuraTracking.getInstance().trackLoginGoogleCallApiSuccess();
            LoginGoogleResponseObj obj = (LoginGoogleResponseObj)x;
            obj.getData().setLoginType("Google");
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            this.onLoginSuccess(obj.getData(), obj.getAccessToken());
            this.loginPresenter.getSdkConfig();
        } else if (x instanceof SdkConfigResponseObj) {
            SakuraTracking.getInstance().trackGetSdkConfigSuccess();
            SdkConfigResponseObj obj = (SdkConfigResponseObj)x;
            GameConfigs.getInstance().setSdkConfig(obj.getData());
            LogUtils.d("LifeCycleActivity", "get game info success");
            if (obj.getData() != null && obj.getData().getMaintenance() != null && !TextUtils.isEmpty((CharSequence)obj.getData().getMaintenance().getUrl())) {
                SakuraTracking.getInstance().trackMaintainScreenOpened();
                SakuraSDK.getInstance().getQueuePopups().add("pop_link");
                SakuraSDK.getInstance().showPopup();
            } else {
                BaraSdk.getInstance().onLoginSuccess(this.mActivity, "login");
                if (this.listener != null) {
                    this.listener.onLoginSuccess();
                }
            }
            this.dismiss();
        }
    }

    public void onLoginSuccess(UserObj obj, String token) {
        GameConfigs.getInstance().setUser(obj);
        AuthenConfigs.getInstance().setAccessToken(token);
        RetrofitClient.clearInstant();
        SakuraTracking.getInstance().trackLoginSuccess(GameConfigs.getInstance().getUser().getId(), GameConfigs.getInstance().getUser().getLoginOrRegister(), GameConfigs.getInstance().getUser().getLoginType());
    }

    public void error(Object o) {
        BaseObj apiErrorObj = (BaseObj)o;
        if (apiErrorObj.getStatus() == -100) {
            DialogUtils.showWarningDialog(this.mActivity, "", this.getString(R.string.error_network));
            return;
        }
        if (o instanceof LoginPlayNowErrObj) {
            LoginPlayNowErrObj obj = (LoginPlayNowErrObj)o;
            SakuraTracking.getInstance().trackLoginPlayNowCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showWarningDialog(this.mActivity, "", obj.getMessage());
        } else if (o instanceof LoginEmailErrObj) {
            LoginEmailErrObj obj = (LoginEmailErrObj)o;
            SakuraTracking.getInstance().trackLoginEmailCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showWarningDialog(this.mActivity, "", obj.getMessage());
        } else if (o instanceof LoginFacebookErrObj) {
            LoginFacebookErrObj obj = (LoginFacebookErrObj)o;
            SakuraTracking.getInstance().trackLoginFacebookCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showWarningDialog(this.mActivity, this.getString(R.string.title_dialog_err), obj.getMessage());
        } else if (o instanceof LoginGGErrObj) {
            LoginGGErrObj obj = (LoginGGErrObj)o;
            SakuraTracking.getInstance().trackLoginGoogleCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showWarningDialog(this.mActivity, this.getString(R.string.title_dialog_err), obj.getMessage());
        } else if (o instanceof AuthenConfigErrObj) {
            AuthenConfigObj obj = new AuthenConfigObj();
            AuthenConfigObj.LoginConfig loginConfig = new AuthenConfigObj.LoginConfig();
            obj.setRegisterConfig(1);
            loginConfig.setLogin_apple(1);
            loginConfig.setLogin_email(1);
            loginConfig.setLogin_facebook(0);
            loginConfig.setPlay_now(1);
            loginConfig.setLogin_google(0);
            obj.setLoginConfig(loginConfig);
            this.applyConfig(obj);
            SakuraTracking.getInstance().trackCallAuthenConfigFailed();
        } else if (o instanceof SdkConfigErrObj) {
            SdkConfigErrObj obj = (SdkConfigErrObj)o;
            SakuraTracking.getInstance().trackGetSdkConfigFailed(obj.getStatus());
            if (obj.getStatus() == 401) {
                DialogUtils.showWarningDialog(this.mActivity, "", this.getResources().getString(R.string.title_force_logout));
            } else {
                DialogUtils.showRetryDialog(this.mActivity, obj.getMessage(), new DialogUtils.Listener(){

                    @Override
                    public void onRetry() {
                        LoginFragment.this.loginPresenter.getSdkConfig();
                    }
                });
            }
        }
    }

    @Override
    public void onAuthFBSuccess(LoginResult loginResult) {
        this.status = Constants.RTF_STATUS.DONE;
        LogUtils.d(TAG, "facebook token : " + loginResult.getAccessToken().getToken());
        SakuraTracking.getInstance().trackLoginFacebookCallApi();
        if (GameConfigs.getInstance().isLogin()) {
            return;
        }
        this.loginPresenter.loginFtFacebook(loginResult.getAccessToken().getToken());
    }

    @Override
    public void onAuthFBFailed(FacebookException error) {
        this.status = Constants.RTF_STATUS.DONE;
        DialogUtils.showErrorDialog(this.mActivity, "Auth FB failed : " + error.getMessage());
        if (error != null && error.getMessage() != null) {
            SakuraTracking.getInstance().trackLoginFacebookSdkErr(error.getMessage());
        }
    }

    @Override
    public void onAuthFBCancel() {
        this.status = Constants.RTF_STATUS.DONE;
        LogUtils.d("Login Facebook", " Auth FB cancel");
        SakuraTracking.getInstance().trackCancelLoginFacebook();
    }

    @Override
    public void onAuthGGSuccess(GoogleSignInAccount account, String mToken) {
        this.status = Constants.RTF_STATUS.DONE;
        LogUtils.d(TAG, "google token : " + mToken);
        if (GameConfigs.getInstance().isLogin()) {
            return;
        }
        SakuraTracking.getInstance().trackLoginGoogleCallApi();
        this.loginPresenter.loginFtGoogle(mToken);
    }

    @Override
    public void onAuthGGFailed(int code, String mess) {
        if (code == 12502) {
            GoogleManager.getInstance((Context)this.mActivity).startAuthForResult(this, (IAuthentGoogleListener)this);
        } else {
            this.status = Constants.RTF_STATUS.DONE;
            DialogUtils.showErrorDialog(this.mActivity, "Auth GG failed : " + mess);
        }
    }

    @Override
    public void onAuthGGCancel() {
        this.status = Constants.RTF_STATUS.DONE;
        LogUtils.d(TAG, " Auth GG cancel");
        SakuraTracking.getInstance().trackCancelLoginGoogle();
    }

    public void setListener(ILoginListener listener) {
        this.listener = listener;
    }

    @Override
    public void onKeyboardHeightChanged(int height, int orientation) {
        this.changeKeyboardHeight(height);
        LogUtils.d(TAG, "onKeyboardHeightChanged: " + orientation);
    }

    private void changeKeyboardHeight(int height) {
        try {
            if (height > 100) {
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, height);
                this.layoutKeyboardSpace.setLayoutParams((ViewGroup.LayoutParams)params);
                this.layoutKeyboardSpace.setVisibility(0);
                return;
            }
            this.layoutKeyboardSpace.setVisibility(8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPause() {
        super.onPause();
        this.keyboardProvider.setKeyboardHeightObserver(null);
        this.mActivity.unregisterReceiver(this.networkChangeReceiver);
    }

    public void onSaveInstanceState(Bundle outState) {
    }
}

