/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.comon.utils;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.sakura.momo.comon.utils.LogUtils;

public class NetworkUtils {
    public static final String TAG = NetworkUtils.class.getSimpleName();
    public static int TYPE_WIFI = 1;
    public static int TYPE_MOBILE = 2;
    public static int TYPE_NOT_CONNECTED = 0;

    public static int getConnectivityStatus(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        if (null != activeNetwork) {
            if (activeNetwork.getType() == 1) {
                LogUtils.d(TAG, "activeNetwork TYPE_WIFI");
                return TYPE_WIFI;
            }
            if (activeNetwork.getType() == 0) {
                LogUtils.d(TAG, "activeNetwork TYPE_MOBILE");
                return TYPE_MOBILE;
            }
        }
        return TYPE_NOT_CONNECTED;
    }

    public static boolean isConnect(Context context) {
        NetworkInfo networkInfo;
        boolean isCon = false;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm != null && (networkInfo = cm.getActiveNetworkInfo()) != null && networkInfo.isConnected()) {
            isCon = true;
        }
        return isCon;
    }

    public static boolean checkNetwork(final Activity activity) {
        boolean isCon = NetworkUtils.isConnect((Context)activity);
        if (!isCon) {
            DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (activity != null && !activity.isFinishing()) {
                        activity.startActivity(new Intent("android.settings.WIRELESS_SETTINGS"));
                        activity.finish();
                    }
                }
            };
        }
        return isCon;
    }
}

