/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.comon.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.util.Log;
import android.view.View;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerTrackingRequestListener;
import com.sakura.momo.comon.config.GameConfigs;
import com.sakura.momo.comon.game.BaraSdk;
import com.sakura.momo.comon.object.VerifyPurchaseObj;
import com.sakura.momo.comon.sharePref.PrefManager;
import com.sakura.momo.comon.tracking.AppsFyer;
import com.sakura.momo.comon.tracking.Firebase;
import com.sakura.momo.comon.utils.LogUtils;
import java.util.HashMap;
import java.util.Map;

public class SakuraTracking {
    public static String TAG = "=====Tracking=====";
    private String appsflyerDevkey = "W3k5j6miEBKbGBbteanNPM";
    private AppsFyer appsFyer;
    private Context context;
    private Firebase firebase;
    private long beginTime;
    private static SakuraTracking sakuraTracking;
    AppsFlyerConversionListener conversionListener = new AppsFlyerConversionListener(){

        public void onConversionDataSuccess(Map<String, Object> conversionData) {
            for (String attrName : conversionData.keySet()) {
                if (!attrName.equals("is_first_launch") || !((Boolean)conversionData.get(attrName)).booleanValue()) continue;
                LogUtils.d(TAG, "Start track event first launcher");
                SakuraTracking.this.trackFirstLaunch();
            }
        }

        public void onConversionDataFail(String errorMessage) {
            LogUtils.d(TAG, "error getting conversion data: " + errorMessage);
        }

        public void onAppOpenAttribution(Map<String, String> attributionData) {
            for (String attrName : attributionData.keySet()) {
                LogUtils.d(TAG, "attribute: " + attrName + " = " + attributionData.get(attrName));
            }
        }

        public void onAttributionFailure(String errorMessage) {
            LogUtils.d(TAG, "error onAttributionFailure : " + errorMessage);
        }
    };

    public void init(Application application) {
        this.context = application;
        this.appsFyer = AppsFyer.newInstance(application, "W3k5j6miEBKbGBbteanNPM", this.conversionListener);
        this.firebase = Firebase.newInstance(application);
    }

    public static SakuraTracking getInstance() {
        if (sakuraTracking == null) {
            sakuraTracking = new SakuraTracking();
        }
        return sakuraTracking;
    }

    public void trackFirstLaunch() {
        this.beginTime = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time_first_launcher", this.beginTime);
        this.trackEvent("event_first_launched", map);
    }

    public void trackAppLaunch() {
        this.beginTime = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time_app_launcher", String.valueOf(this.beginTime));
        this.trackEvent("event_app_launched", map);
    }

    public void trackFromWeb(String label, String value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TYPE_LOGIN", value);
        this.trackEvent(label, map);
    }

    public void trackLogoutSuccess(int userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ft_user_id", String.valueOf(userId));
        this.trackEvent("event_logout_success", map);
    }

    public void trackPaymentScreenOpened() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String character_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_AREA_ID", "");
        String user_id = "";
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("ft_user_id", user_id);
        hashMap.put("ft_role_id", character_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("event_payment_screen_opened", hashMap);
    }

    public void trackPaymentLoadScreenSuccess() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String character_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_AREA_ID", "");
        String user_id = "";
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("ft_user_id", user_id);
        hashMap.put("ft_role_id", character_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("event_payment_screen_load_success", hashMap);
    }

    public void trackRetryPurchaseFail(String code, String message) {
        long current = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("err_code", String.valueOf(code));
        hashMap.put("message", String.valueOf(message));
        this.trackEvent("ft_payment_retry_purchase_fail", hashMap);
    }

    public void trackPaymentLoadScreenFail(String error_code, String error_message) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String character_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_AREA_ID", "");
        String user_id = "";
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("ft_user_id", user_id);
        hashMap.put("ft_role_id", character_id);
        hashMap.put("ft_area_id", area_id);
        hashMap.put("error_code", error_code);
        hashMap.put("error_message", error_message);
        this.trackEvent("event_payment_screen_load_fail", hashMap);
    }

    public void trackPaymentBeforVerify(String order_no) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String character_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_AREA_ID", "");
        String user_id = "";
        long currentTime = System.currentTimeMillis();
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("ft_user_id", user_id);
        hashMap.put("ft_role_id", character_id);
        hashMap.put("ft_area_id", area_id);
        hashMap.put("order_no", order_no);
        hashMap.put("timestamp", String.valueOf(currentTime));
        PrefManager.saveLong((Context)BaraSdk.getInstance().getApplication(), "event_payment_before_verify", currentTime);
        this.trackEvent("event_payment_before_verify", hashMap);
    }

    public void trackPaymentVerifySuccess(VerifyPurchaseObj obj) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String character_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_ROLE_ID", "");
            String area_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_AREA_ID", "");
            String user_id = "";
            long currentTime = System.currentTimeMillis();
            long startCall = PrefManager.getLong((Context)BaraSdk.getInstance().getApplication(), "event_payment_before_verify", currentTime);
            long deta_call = currentTime - startCall;
            try {
                user_id = user_id + GameConfigs.getInstance().getUser().getId();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            hashMap.put("ft_user_id", user_id);
            hashMap.put("ft_role_id", character_id);
            hashMap.put("ft_area_id", area_id);
            hashMap.put("order_no", obj.getOrder_no());
            hashMap.put("timestamp", String.valueOf(currentTime));
            hashMap.put("delta_call", String.valueOf(deta_call));
            double price = 0.01 * (double)obj.getPlatform_price();
            hashMap.put("af_revenue", price);
            hashMap.put("af_content_type", "category_rev");
            hashMap.put("af_content_id", "123456");
            hashMap.put("af_currency", "USD");
            hashMap.put("af_order_id", obj.getOrder_no());
            this.trackEventAF("af_purchase", hashMap);
            HashMap<String, Object> hashMapFB = new HashMap<String, Object>();
            hashMapFB.put("ft_user_id", user_id);
            hashMapFB.put("ft_role_id", character_id);
            hashMapFB.put("ft_area_id", area_id);
            hashMapFB.put("order_no", obj.getOrder_no());
            hashMapFB.put("timestamp", String.valueOf(currentTime));
            hashMapFB.put("delta_call", String.valueOf(deta_call));
            hashMapFB.put("coupon", "SummerPromo");
            hashMapFB.put("currency", "USD");
            hashMapFB.put("value", price);
            hashMapFB.put("transaction_id", obj.getOrder_no());
            this.trackEventFireBase("purchase", hashMapFB);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPaymentVerifyFail(String order_no, String type_error, String err_code, String err_mesage) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String character_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_AREA_ID", "");
        String user_id = "";
        long currentTime = System.currentTimeMillis();
        long startCall = PrefManager.getLong((Context)BaraSdk.getInstance().getApplication(), "event_payment_before_verify", currentTime);
        long deta_call = currentTime - startCall;
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("ft_user_id", user_id);
        hashMap.put("ft_role_id", character_id);
        hashMap.put("ft_area_id", area_id);
        hashMap.put("order_no", order_no);
        hashMap.put("type_error", type_error);
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("delta_call", String.valueOf(deta_call));
        hashMap.put("error_code", err_code);
        hashMap.put("error_message", err_mesage);
        this.trackEvent("event_payment_verify_fail", hashMap);
    }

    public void trackLocalPaymentVerifyFail(VerifyPurchaseObj verifyPurchaseObj) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String character_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)BaraSdk.getInstance().getApplication(), "MANCT_AREA_ID", "");
        String user_id = "";
        long currentTime = System.currentTimeMillis();
        long startCall = PrefManager.getLong((Context)BaraSdk.getInstance().getApplication(), "event_payment_before_verify", currentTime);
        long deta_call = currentTime - startCall;
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("ft_user_id", user_id);
        hashMap.put("ft_role_id", character_id);
        hashMap.put("ft_area_id", area_id);
        hashMap.put("order_no", verifyPurchaseObj.getOrder_no());
        hashMap.put("type_error", "");
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("delta_call", String.valueOf(deta_call));
        hashMap.put("error_code", verifyPurchaseObj.getStatus());
        hashMap.put("error_message", verifyPurchaseObj.getDescription());
        this.trackEvent("event_payment_verify_fail", hashMap);
    }

    public void trackStartExtractData(Activity activity) {
        Log.d((String)TAG, (String)"trackStartExtractData: ");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("timestamp", String.valueOf(currentTime));
        PrefManager.saveLong(this.context, "BEGIN_ACTION_TIME", currentTime);
        this.trackEvent("event_extract_started", hashMap);
    }

    public void trackFinishExtractData() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("delta_extract", String.valueOf(PrefManager.getLong(this.context, "BEGIN_ACTION_TIME", currentTime)));
        PrefManager.saveLong(this.context, "BEGIN_ACTION_TIME", 0L);
        this.trackEvent("event_extract_finished", hashMap);
    }

    public void trackDownloadResourceStarted() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        map.put("delta", String.valueOf(delta));
        map.put("timestamp", String.valueOf(currentTime));
        PrefManager.saveLong(this.context, "BEGIN_ACTION_TIME", currentTime);
        this.trackEvent("event_resource_started", map);
    }

    public void trackDownloadResourceFinished() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        map.put("timestamp", String.valueOf(currentTime));
        map.put("delta", String.valueOf(delta));
        map.put("delta_extract", String.valueOf(PrefManager.getLong(this.context, "BEGIN_ACTION_TIME", currentTime)));
        PrefManager.saveSetting((Context)BaraSdk.getInstance().getApplication(), "event_resource_finished", currentTime);
        this.trackEvent("event_resource_finished", map);
    }

    public void trackExtractCDNFinished(Activity activity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        long delta_resource = currentTime - PrefManager.getLong((Context)BaraSdk.getInstance().getApplication(), "event_resource_finished", currentTime);
        map.put("timestamp", String.valueOf(currentTime));
        map.put("delta", String.valueOf(delta));
        map.put("delta_resource", String.valueOf(delta_resource));
        this.trackEvent("event_extract_cdn_finished", map);
    }

    public void trackSession() {
        long endTime = System.currentTimeMillis();
        long deltaTime = endTime - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ft_start_time", String.valueOf(this.beginTime));
        hashMap.put("ft_end_time ", String.valueOf(endTime));
        hashMap.put("ft_length_second", String.valueOf(deltaTime));
        this.trackEvent("session", hashMap);
    }

    public void trackLastSession(Context ct) {
        int minute = PrefManager.getInt(ct, "SESSION_OUT_TIME", 10);
        long milisecond = minute * 60 * 1000;
        long begin = PrefManager.getLong(ct, "LAST_SESSION_START", 0L);
        long endTime = PrefManager.getLong(ct, "LAST_SESSION_END", 0L);
        long deltaTime = PrefManager.getLong(ct, "LAST_SESSION_DETAl", 0L);
        if (begin == 0L || endTime == 0L) {
            return;
        }
        if (deltaTime < milisecond) {
            return;
        }
        if (this.beginTime - endTime < milisecond) {
            this.beginTime = begin;
            return;
        }
        LogUtils.d(TAG, "Begin: " + begin + " - End : " + endTime + " - Detal : " + deltaTime);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ft_start_time", String.valueOf(begin));
        hashMap.put("ft_end_time ", String.valueOf(endTime));
        hashMap.put("ft_length_second", String.valueOf(deltaTime));
        this.trackEvent("session", hashMap);
        this.clearSession(ct);
    }

    public void saveSession(Context ct) {
        long endTime = System.currentTimeMillis();
        long deltaTime = endTime - this.beginTime;
        PrefManager.saveSetting(ct, "LAST_SESSION_START", this.beginTime);
        PrefManager.saveSetting(ct, "LAST_SESSION_END", endTime);
        PrefManager.saveSetting(ct, "LAST_SESSION_DETAl", deltaTime);
    }

    public void clearSession(Context ct) {
        PrefManager.saveSetting(ct, "LAST_SESSION_START", 0);
        PrefManager.saveSetting(ct, "LAST_SESSION_END", 0);
        PrefManager.saveSetting(ct, "LAST_SESSION_DETAl", 0);
    }

    public void trackLoginSuccess(int userId, String type, String loginOrRegisterType) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        long start_open_login = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", currentTime);
        long deta_login = currentTime - start_open_login;
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("delta_login", String.valueOf(deta_login));
        hashMap.put("ft_user_id", String.valueOf(userId));
        hashMap.put("ft_type", type);
        hashMap.put("ft_login_or_register_type", loginOrRegisterType);
        this.trackEvent("af_login", hashMap);
    }

    public void trackClickBtnEnterGame(String serverId) {
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("ft_server_id", String.valueOf(serverId));
        this.trackEvent("event_enter_game_btn_clicked", hashMap);
    }

    public void trackCharactorCreated(Activity activity, int user_id, String role_id, String area_id) {
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("event_character_created", hashMap);
    }

    public void trackCharactorCreatedSuccess(int user_id, String role_id, String area_id) {
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("event_character_created_call_api_success", hashMap);
    }

    public void trackCharactorCreatedFailed(int user_id, String role_id, String area_id) {
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("event_character_created_call_api_fail", hashMap);
    }

    public void trackTutorialCompletion(int user_id, String role_id, String area_id) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("af_tutorial_completion", hashMap);
    }

    public void trackLevelAchieved(Activity activity, int user_id, String role_id, String area_id, String af_level) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        hashMap.put("af_level ", af_level);
        this.trackEvent("af_level_achieved", hashMap);
        if (GameConfigs.getInstance().getSdkConfig() == null) {
            return;
        }
        if (af_level.equals(String.valueOf(GameConfigs.getInstance().getSdkConfig().getTutorialLevel()))) {
            SakuraTracking.getInstance().trackTutorialCompletion(GameConfigs.getInstance().getUser().getId(), role_id, area_id);
        }
    }

    public void trackVipAchieved(int user_id, String role_id, String area_id, String ft_vip) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        hashMap.put("ft_vip", ft_vip);
        this.trackEvent("event_vip_achieved", hashMap);
    }

    public void trackLoginScreenOpen() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        PrefManager.saveLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.trackEvent("event_login_screen_opened", hashMap);
    }

    public void trackClickLoginEmailButton() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_login_email_btn_clicked", hashMap);
    }

    public void trackLoginEmailInputError(int errCode, String errMessage) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", errMessage);
        this.trackEvent("event_login_screen_login_email_input_error", hashMap);
    }

    public void trackLoginEmailCallApi() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_login_email_api_call", hashMap);
    }

    public void trackLoginEmailCallApiSuccess() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
    }

    public void trackLoginEmailCallApiFail(int errCode, String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", mess);
        this.trackEvent("event_login_screen_login_email_api_call_fail", hashMap);
    }

    public void trackClickLoginFacebookButton() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_login_facebook_btn_clicked", hashMap);
    }

    public void trackCancelLoginFacebook() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_login_facebook_user_canceled", hashMap);
    }

    public void trackLoginFacebookSdkErr(String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("error_message", mess);
        this.trackEvent("event_login_screen_login_facebook_have_error", hashMap);
    }

    public void trackLoginFacebookCallApi() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_login_facebook_api_call", hashMap);
    }

    public void trackLoginFacebookCallApiSuccess() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
    }

    public void trackLoginFacebookCallApiFail(int errCode, String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", mess);
        this.trackEvent("event_login_screen_login_facebook_api_call_fail", hashMap);
    }

    public void trackClickLoginGoogleButton() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_login_google_btn_clicked", hashMap);
    }

    public void trackCancelLoginGoogle() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_login_google_user_canceled", hashMap);
    }

    public void trackLoginGoogleSdkErr(int errCode, String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", mess);
        this.trackEvent("event_login_screen_login_google_have_error", hashMap);
    }

    public void trackLoginGoogleCallApi() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_login_google_api_call", hashMap);
    }

    public void trackLoginGoogleCallApiSuccess() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
    }

    public void trackLoginGoogleCallApiFail(int errCode, String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", mess);
        this.trackEvent("event_login_screen_login_google_api_call_fail", hashMap);
    }

    public void trackLoginPlayNowCallApi() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_login_playnow_btn_clicked", hashMap);
    }

    public void trackLoginPlayNowCallApiSuccess() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
    }

    public void trackLoginPlayNowCallApiFail(int errCode, String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", mess);
        this.trackEvent("event_login_screen_login_playnow_api_call_fail", hashMap);
    }

    public void trackGetSdkConfigSuccess() {
        long current = System.currentTimeMillis();
        long start_time = PrefManager.getLong((Context)BaraSdk.getInstance().getApplication(), "event_load_game_config_call_api_success", System.currentTimeMillis());
        long deltaTime = current - start_time;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta_call", String.valueOf(deltaTime));
        this.trackEvent("event_load_game_config_call_api_success", hashMap);
    }

    public void trackGetSdkConfigFailed(int code) {
        long current = System.currentTimeMillis();
        long start_time = PrefManager.getLong((Context)BaraSdk.getInstance().getApplication(), "event_load_game_config_call_api_fail", System.currentTimeMillis());
        long deltaTime = current - start_time;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta_call", String.valueOf(code));
        this.trackEvent("event_load_game_config_call_api_fail", hashMap);
    }

    public void trackClickBtnRegister() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_register_btn_clicked", hashMap);
    }

    public void trackRegisterLoadSuccess() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_register_form_load_success", hashMap);
    }

    public void trackRegisterSubmitForm() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("event_login_screen_register_form_submited", hashMap);
    }

    public void trackLoginScreenClose(View form, View text, View button) {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long delta_login = current - PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(delta_login));
        hashMap.put("d_form", form.getX() + "-" + form.getY() + "-" + form.getWidth() + "-" + form.getHeight());
        hashMap.put("d_text", text.getX() + "-" + text.getY() + "-" + text.getWidth() + "-" + text.getHeight());
        hashMap.put("d_button", button.getX() + "-" + button.getY() + "-" + button.getWidth() + "-" + button.getHeight());
        this.trackEvent("event_login_screen_close_btn_clicked", hashMap);
    }

    public void trackCallAuthenConfigSuccess() {
        long current = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        this.trackEvent("event_get_authen_api_call_success", hashMap);
    }

    public void trackMaintainScreenOpened() {
        long current = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        this.trackEvent("event_maintain_screen_opened", hashMap);
    }

    public void trackCallAuthenConfigFailed() {
        long current = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        this.trackEvent("event_get_authen_api_call_fail", hashMap);
    }

    public void trackClickOverlayPermission() {
        this.trackEvent("event_overlay_click_permission", null);
    }

    public void trackStartPermisison() {
        this.trackEvent("event_start_permisison", null);
    }

    public void trackEndPermisison() {
        this.trackEvent("event_end_permission", null);
    }

    public void trackClickBtnRegisterInForm() {
        long current = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        long deltaTime = current - this.beginTime;
        hashMap.put("delta", String.valueOf(deltaTime));
        this.trackEvent("event_login_screen_forgot_password_btn_clicked", hashMap);
    }

    public void trackForgotPassword() {
        long current = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        long deltaTime = current - this.beginTime;
        hashMap.put("delta", String.valueOf(deltaTime));
        this.trackEvent("event_login_screen_forgot_password_btn_clicked", hashMap);
    }

    public String getAppsflyerDevkey() {
        return this.appsflyerDevkey;
    }

    public void trackEvent(final String eventName, HashMap<String, Object> map) {
        LogUtils.d(TAG, eventName);
        this.appsFyer.trackEventWithCountFailed(eventName, map, new AppsFlyerTrackingRequestListener(){

            public void onTrackingRequestSuccess() {
                LogUtils.d(TAG + ">SENT", eventName + " sent");
            }

            public void onTrackingRequestFailure(String s) {
                LogUtils.e(TAG + ">SENT", eventName + " send failed");
            }
        });
        this.firebase.firebaseEventTrack(eventName, map);
    }

    private void trackEventAF(final String eventName, HashMap<String, Object> map) {
        LogUtils.d(TAG, eventName);
        this.appsFyer.trackEventWithCountFailed(eventName, map, new AppsFlyerTrackingRequestListener(){

            public void onTrackingRequestSuccess() {
                LogUtils.d(TAG + ">SENT", eventName + " sent");
            }

            public void onTrackingRequestFailure(String s) {
                LogUtils.e(TAG + ">SENT", eventName + " send failed");
            }
        });
    }

    private void trackEventFireBase(String eventName, HashMap<String, Object> map) {
        LogUtils.d(TAG, eventName);
        this.firebase.firebaseEventTrack(eventName, map);
    }
}

