/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.comon.js.command;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.Html;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.bara.SakuraSDK;
import com.bara.component.FacebookManager;
import com.bara.gui.SakuraImageGaleryActivity;
import com.bara.gui.dialog.SakuraDialogWebviewFragment;
import com.bara.utils.Res;
import com.facebook.share.widget.GameRequestDialog;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.quby.R;
import com.sakura.momo.comon.config.GameConfigs;
import com.sakura.momo.comon.tracking.SakuraTracking;
import com.sakura.momo.comon.utils.PermissionUtils;
import com.sakura.momo.comon.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONObject;

public final class CmdDashboard {
    private static final String TAG = CmdDashboard.class.getSimpleName();
    private static CmdDashboard INSTANCE;
    private FirebaseAnalytics mFirebaseAnalytics;
    private HashMap<String, Object> reminderCache = new HashMap();
    private SakuraDialogWebviewFragment webFragment;
    private HashMap<String, Bitmap> issuePhotos;

    private CmdDashboard() {
    }

    public static CmdDashboard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdDashboard();
        }
        return INSTANCE;
    }

    public void handleResult(Activity activity, int requestCode, int resultCode, Intent data) {
        try {
            switch (requestCode) {
                case 20002: {
                    if (data.getStringExtra("data") == null) break;
                    String[] imagesPath = data.getStringExtra("data").split("\\|");
                    for (int i = 0; i < imagesPath.length; ++i) {
                        Log.d((String)TAG, (String)("handleResult: " + imagesPath[i]));
                        this.handleIssuePhoto(activity, imagesPath[i]);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleIssuePhoto(Activity activity, String imagePath) {
        try {
            Bitmap bitmap = this.getCompressedBitmapFromPath(activity, imagePath);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)byteArrayOutputStream);
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            String encoded = Base64.encodeToString((byte[])byteArray, (int)0);
            String key = "img" + Calendar.getInstance().getTimeInMillis();
            String jsFunction = String.format("getImageData('%s', '%s');", encoded, key);
            Log.d((String)TAG, (String)("js function: " + jsFunction));
            this.webFragment.invokeJavascript(jsFunction);
            if (this.issuePhotos == null) {
                this.issuePhotos = new HashMap();
            }
            this.issuePhotos.put(key, bitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Bitmap getCompressedBitmapFromPath(Activity activity, String imagePath) {
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            o.inSampleSize = 6;
            BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)o);
            int REQUIRED_SIZE = 75;
            int scale = 1;
            while (o.outWidth / scale / 2 >= 75 && o.outHeight / scale / 2 >= 75) {
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)o2);
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(-1);
        }
        return bitmap;
    }

    public void openContact(Activity activity, String params) {
        Log.i((String)TAG, (String)("nQENmzOB:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String support_email = obj.getString("support_email");
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("mailto:" + support_email)));
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobSendSMS(Activity activity, String params) {
        Log.i((String)TAG, (String)("SendSMS:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String body = obj.getString("body");
            Intent smsVIntent = new Intent("android.intent.action.VIEW");
            smsVIntent.setType("vnd.android-dir/mms-sms");
            smsVIntent.putExtra("sms_body", body);
            activity.startActivity(smsVIntent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobSendEmail(Activity activity, String params) {
        Log.i((String)TAG, (String)("SendEmail:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String subject = obj.getString("subject");
            String body = obj.getString("body");
            Intent email = new Intent("android.intent.action.SEND", Uri.parse((String)"mailto:"));
            email.setType("text/plain");
            email.putExtra("android.intent.extra.EMAIL", "");
            email.putExtra("android.intent.extra.SUBJECT", subject);
            email.putExtra("android.intent.extra.TEXT", (CharSequence)Html.fromHtml((String)body));
            activity.startActivity(Intent.createChooser((Intent)email, (CharSequence)"Choose an email client from..."));
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void openBrowser(Activity activity, String params) {
        Log.i((String)TAG, (String)("OpenBrowser:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String url = obj.getString("url");
            if (!url.contains("http://") || !url.contains("https://")) {
                url = "http://" + url;
            }
            this.myOpenBrowser(activity, Uri.parse((String)url));
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void openDialogWebView(Activity activity, String params) {
        Log.i((String)TAG, (String)("openDialogWebView:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String url = "";
            String title = "";
            if (obj.has("link")) {
                url = obj.getString("link");
            }
            if (obj.has("title")) {
                title = obj.getString("title");
            }
            Intent intent = new Intent("com.quby.broadcast");
            LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    private void myOpenBrowser(Activity activity, Uri uri) {
        Log.i((String)TAG, (String)("myOpenBrowser:" + uri));
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void refreshBugForm(Activity activity, String params, SakuraDialogWebviewFragment dialogWebviewFragment) {
        Log.i((String)TAG, (String)("RefreshBugForm:" + params));
        try {
            dialogWebviewFragment.dismiss();
            if (Utils.isJSONValid(params)) {
                JSONObject jsonObject = new JSONObject(params);
                int isRefresh = 0;
                if (jsonObject.has("is_refresh")) {
                    isRefresh = jsonObject.getInt("is_refresh");
                }
                if (isRefresh == 1) {
                    Intent intent = new Intent("com.quby.broadcast");
                    intent.putExtra("category_from_bug", "refresh_from_bug");
                    LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).sendBroadcast(intent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openFBFanpage(Activity activity, String params) {
        Log.i((String)TAG, (String)("SRAWoDvA:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String pageid = obj.getString("pageid");
            String callbackUrl = null;
            boolean isSocial = false;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            if (obj.has("isSocial")) {
                isSocial = obj.getBoolean("isSocial");
            }
            try {
                activity.getPackageManager().getPackageInfo("com.facebook.katana", 0);
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("fb://page/" + pageid)));
                activity.startActivity(intent);
            }
            catch (Exception e) {
                this.myOpenBrowser(activity, Uri.parse((String)("https://m.facebook.com/profile.php?id=" + pageid)));
            }
            if (!TextUtils.isEmpty((CharSequence)callbackUrl)) {
                Activity activity2 = activity;
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void openFBGroup(Activity activity, String params) {
        Log.i((String)TAG, (String)("bpmyEufN:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String groupid = obj.getString("groupid");
            try {
                activity.getPackageManager().getPackageInfo("com.facebook.katana", 0);
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("fb://group/" + groupid)));
                activity.startActivity(intent);
            }
            catch (Exception e) {
                this.myOpenBrowser(activity, Uri.parse((String)("https://facebook.com/groups/" + groupid)));
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobOpenModal(Activity activity, String params) {
        Log.i((String)TAG, (String)("OpenModal:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent("com.quby.broadcast");
            intent.putExtra("category", "dashboard");
            intent.putExtra("urls", "[{'action':'" + obj.getString("url") + "'}]");
            LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).sendBroadcast(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void makePhoneCall(Activity activity, String params) {
        Log.i((String)TAG, (String)("makePhoneCall:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent("android.intent.action.DIAL");
            intent.setData(Uri.parse((String)("tel:" + obj.getString("number"))));
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public static void mobCopyToClipboard(Activity activity, String params) {
        try {
            int sdk = Build.VERSION.SDK_INT;
            JSONObject obj = new JSONObject(params);
            String data = obj.getString("data").trim();
            if (sdk < 11) {
                android.text.ClipboardManager clipboard = (android.text.ClipboardManager)activity.getSystemService("clipboard");
                clipboard.setText((CharSequence)data);
            } else {
                ClipboardManager clipboard = (ClipboardManager)activity.getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"clipboard", (CharSequence)data);
                clipboard.setPrimaryClip(clip);
            }
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.copied), (int)1).show();
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void getIssue(Activity activity, SakuraDialogWebviewFragment webFragment, String params) {
        Log.i((String)TAG, (String)("getIssue:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            long issueId = Long.parseLong(obj.getString("id"));
            if (issueId != 0L) {
                if (this.issuePhotos != null) {
                    ArrayList<Bitmap> listBitmap = new ArrayList<Bitmap>();
                    for (Map.Entry<String, Bitmap> entry : this.issuePhotos.entrySet()) {
                        String key = entry.getKey();
                        Bitmap bitmap = entry.getValue();
                        listBitmap.add(bitmap);
                    }
                }
                this.issuePhotos = null;
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void clearImageData(Activity activity) {
        Log.d((String)TAG, (String)"clearImageData");
        if (this.issuePhotos == null) {
            return;
        }
        if (this.issuePhotos.isEmpty()) {
            return;
        }
        this.issuePhotos.clear();
    }

    public void selectImage(Activity activity, SakuraDialogWebviewFragment webFragment, String params) {
        try {
            Log.d((String)TAG, (String)("selectImage: " + params));
            if (this.issuePhotos != null && this.issuePhotos.size() > 2) {
                AlertDialog.Builder alert = new AlertDialog.Builder((Context)activity);
                alert.setMessage((CharSequence)Res.string((Context)activity, R.string.alert_image_validate));
                alert.setNegativeButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog = alert.create();
                dialog.setCancelable(false);
                dialog.show();
                return;
            }
            this.webFragment = webFragment;
            boolean grantedReadStorage = PermissionUtils.hasPermission("android.permission.READ_EXTERNAL_STORAGE");
            if (!grantedReadStorage) {
                PermissionUtils.requestPermission(SakuraSDK.currentActivity, "android.permission.READ_EXTERNAL_STORAGE");
            }
            if (grantedReadStorage) {
                Intent intent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                intent.setType("image/*");
                activity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Choose photo"), 20002);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectImage2(Activity activity, SakuraDialogWebviewFragment webFragment, String params) {
        try {
            Log.d((String)TAG, (String)("selectImage 2: " + params));
            if (this.issuePhotos != null && this.issuePhotos.size() > 3) {
                AlertDialog.Builder alert = new AlertDialog.Builder((Context)activity);
                alert.setMessage((CharSequence)Res.string((Context)activity, R.string.alert_image_validate));
                alert.setNegativeButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog = alert.create();
                dialog.setCancelable(false);
                dialog.show();
                return;
            }
            this.webFragment = webFragment;
            boolean grantedReadStorage = PermissionUtils.hasPermission("android.permission.READ_EXTERNAL_STORAGE");
            if (!grantedReadStorage) {
                PermissionUtils.requestPermission(SakuraSDK.currentActivity, "android.permission.READ_EXTERNAL_STORAGE");
            }
            if (grantedReadStorage) {
                Bundle bundle = new Bundle();
                int limit = 3;
                if (this.issuePhotos != null) {
                    limit = 3 - this.issuePhotos.size();
                }
                bundle.putInt("limit", limit);
                Intent intent = new Intent((Context)activity, SakuraImageGaleryActivity.class);
                intent.putExtra("bundle", bundle);
                activity.startActivityForResult(intent, 20002);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void chooseFriend(Activity activity, String params) {
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            String url = callbackUrl;
            FacebookManager.InviteGameContent parameter = new FacebookManager.InviteGameContent();
            parameter.setTitle("Invite friend play game");
            parameter.setMessage("Play game with me");
            FacebookManager.getInstance().inviteGameRequest(activity, parameter, new FacebookManager.InviteGameCallback(){

                @Override
                public void onSuccess(GameRequestDialog.Result data) {
                    Log.i((String)TAG, (String)"invite onSuccess");
                    List list = data.getRequestRecipients();
                    HashMap<String, String> maps = new HashMap<String, String>();
                    String str = "";
                    for (int i = 0; i < list.size(); ++i) {
                        str = str + (String)list.get(i) + ",";
                    }
                    Log.d((String)"STR", (String)("str:" + str));
                    String id2 = null;
                    if (GameConfigs.getInstance().getUser() != null && GameConfigs.getInstance().getUser().getAccount() != null) {
                        id2 = GameConfigs.getInstance().getUser().getAccount().getAccountId();
                        maps.put("account_id", id2);
                    }
                    maps.put("fbid_friends", str);
                }

                @Override
                public void onError(Throwable t) {
                    Log.i((String)TAG, (String)"invite onError");
                }

                @Override
                public void onCancel() {
                    Log.i((String)TAG, (String)"invite onCancel");
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackingDetailWeb(Activity activity, String params) {
        try {
            Log.d((String)TAG, (String)("params : " + params));
            this.mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)activity);
            JSONObject json = new JSONObject(params);
            String typeEvent = json.getString("type");
            String title = json.getString("title");
            Bundle bundle = new Bundle();
            bundle.putString("type", typeEvent);
            bundle.putString("title", title);
            this.mFirebaseAnalytics.logEvent("event_track_detail_web", bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackingFromWeb(Activity activity, String params) {
        try {
            Log.d((String)TAG, (String)("label : params - " + params));
            JSONObject json = new JSONObject(params);
            String label = json.getString("label");
            String value = json.getString("value");
            JSONObject jsonChild = new JSONObject(value);
            String name = jsonChild.getString("name");
            Log.d((String)TAG, (String)("label :" + label + " , name : " + name));
            SakuraTracking.getInstance().trackFromWeb(label, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRequestPermissionsResult(Activity activity, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            switch (requestCode) {
                case 992: {
                    try {
                        JSONObject jsonObject = new JSONObject();
                        String startDate = Utils.convertLongToDate((Long)this.reminderCache.get("eventStartTimeInMiliSec"));
                        jsonObject.put("start_date", (Object)startDate);
                        String endDate = Utils.convertLongToDate((Long)this.reminderCache.get("eventEndTimeInMiliSec"));
                        jsonObject.put("end_date", (Object)endDate);
                        jsonObject.put("event_title", (Object)String.valueOf(this.reminderCache.get("eventTitle")));
                        jsonObject.put("description", (Object)String.valueOf(this.reminderCache.get("desc")));
                        jsonObject.put("deeplink", (Object)String.valueOf(this.reminderCache.get("deeplink")));
                        this.setUpReminder(activity, jsonObject.toString());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.noti_after_user_deny_permission), (int)0).show();
        }
    }

    public void setUpReminder(Activity activity, String params) {
        try {
            long eventEndTimeInMiliSec = 0L;
            long eventStartTimeInMiliSec = 0L;
            String eventTitle = "";
            String desc = "";
            String deeplink = "";
            Log.d((String)TAG, (String)("eventEndTime 2: " + params));
            JSONObject jsonObject = new JSONObject(params);
            if (jsonObject.has("start_date")) {
                eventStartTimeInMiliSec = Long.parseLong(jsonObject.getString("start_date"));
            }
            if (jsonObject.has("end_date")) {
                eventEndTimeInMiliSec = Long.parseLong(jsonObject.getString("end_date"));
            }
            if (jsonObject.has("event_title")) {
                eventTitle = jsonObject.getString("event_title");
            }
            if (jsonObject.has("deeplink")) {
                deeplink = jsonObject.getString("deeplink");
            }
            if (jsonObject.has("description")) {
                desc = jsonObject.getString("description");
            }
            Log.d((String)TAG, (String)("eventEndTime : " + eventEndTimeInMiliSec + " , currentTime : " + System.currentTimeMillis()));
            if (eventEndTimeInMiliSec <= System.currentTimeMillis()) {
                Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.event_end), (int)0).show();
                return;
            }
            if (ActivityCompat.checkSelfPermission((Context)activity, (String)"android.permission.WRITE_CALENDAR") != 0) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.WRITE_CALENDAR", "android.permission.READ_CALENDAR"}, (int)992);
                if (this.reminderCache != null) {
                    this.reminderCache.clear();
                    this.reminderCache = new HashMap();
                    this.reminderCache.put("eventTitle", eventTitle);
                    this.reminderCache.put("eventStartTimeInMiliSec", eventStartTimeInMiliSec);
                    this.reminderCache.put("eventEndTimeInMiliSec", eventEndTimeInMiliSec);
                    this.reminderCache.put("desc", desc);
                    this.reminderCache.put("deeplink", deeplink);
                }
                return;
            }
            String eventUriString = "content://com.android.calendar/events";
            ContentValues eventValues = new ContentValues();
            eventValues.put("calendar_id", Integer.valueOf(1));
            eventValues.put("title", eventTitle);
            if (desc != null) {
                eventValues.put("description", desc + " Open link from browser: " + deeplink);
            } else {
                eventValues.put("description", "Open link from browser: " + deeplink);
            }
            eventValues.put("eventLocation", Utils.getApplicationName((Context)activity));
            eventValues.put("dtstart", Long.valueOf(eventStartTimeInMiliSec));
            eventValues.put("dtend", Long.valueOf(eventEndTimeInMiliSec));
            Calendar cal = Calendar.getInstance();
            TimeZone tz = cal.getTimeZone();
            eventValues.put("eventTimezone", tz.getDisplayName());
            eventValues.put("hasAlarm", Integer.valueOf(1));
            Uri eventUri = activity.getApplicationContext().getContentResolver().insert(Uri.parse((String)eventUriString), eventValues);
            assert (eventUri != null);
            long eventID = Long.parseLong(eventUri.getLastPathSegment());
            String reminderUriString = "content://com.android.calendar/reminders";
            ContentValues reminderValues = new ContentValues();
            reminderValues.put("event_id", Long.valueOf(eventID));
            reminderValues.put("minutes", Integer.valueOf(5));
            reminderValues.put("method", Integer.valueOf(1));
            activity.getApplicationContext().getContentResolver().insert(Uri.parse((String)reminderUriString), reminderValues);
            Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.event_scheduled), (int)0).show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.calendar_not_found), (int)0).show();
        }
    }
}

