/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.comon.game;

import android.app.Activity;
import android.app.Application;
import android.app.DialogFragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.appsflyer.AppsFlyerLib;
import com.bara.SakuraHelper;
import com.bara.SakuraSDK;
import com.facebook.login.widget.ProfilePictureView;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.quby.R;
import com.sakura.momo.comon.api.RetrofitClient;
import com.sakura.momo.comon.cmd.CmdPaymentV3;
import com.sakura.momo.comon.config.AuthenConfigs;
import com.sakura.momo.comon.config.GameConfigs;
import com.sakura.momo.comon.game.IBaraSdk;
import com.sakura.momo.comon.listener.IBlockIpListener;
import com.sakura.momo.comon.listener.ILoginListener;
import com.sakura.momo.comon.listener.ILogoutListener;
import com.sakura.momo.comon.listener.IMesssageListener;
import com.sakura.momo.comon.listener.IPaymentListener;
import com.sakura.momo.comon.listener.ISaveCharactorListener;
import com.sakura.momo.comon.login.FacebookManager;
import com.sakura.momo.comon.login.GoogleManager;
import com.sakura.momo.comon.object.AuthenConfigObj;
import com.sakura.momo.comon.object.BaseObj;
import com.sakura.momo.comon.object.MessInGameObj;
import com.sakura.momo.comon.object.PurchaseHistoryObj;
import com.sakura.momo.comon.object.VerifyPurchaseObj;
import com.sakura.momo.comon.object.response.AuthenConfigResponseObj;
import com.sakura.momo.comon.object.response.MessInGameResponseObj;
import com.sakura.momo.comon.presenter.BaseView;
import com.sakura.momo.comon.sharePref.PrefManager;
import com.sakura.momo.comon.tracking.SakuraTracking;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.comon.utils.LogUtils;
import com.sakura.momo.comon.utils.ToastUtils;
import com.sakura.momo.comon.utils.Utils;
import com.sakura.momo.ui.block.BlockFragment;
import com.sakura.momo.ui.login.LoginFragment;
import com.sakura.momo.ui.login.LoginPresenterImpl;
import com.sakura.momo.ui.notification.HanaFirebaseMessagingService;
import com.sakura.momo.ui.other.GamePresenterImpl;
import com.sakura.momo.ui.payment.PaymentNativeFragment;
import java.util.ArrayList;
import java.util.Timer;

public class BaraSdk
implements IBaraSdk {
    private static Application sApp;
    private static BaraSdk TaunSdk;
    private static SakuraSDK sakuraSDK;
    Handler mHandler;
    Runnable mRunable;
    private Timer timerAsync;
    private BlockFragment dialogFragment;
    DialogFragment paymentNativeFragment;

    @Override
    public Application getApplication() {
        return sApp;
    }

    public static BaraSdk getInstance() {
        if (TaunSdk == null) {
            TaunSdk = new BaraSdk();
            sakuraSDK = SakuraSDK.getInstance();
        }
        return TaunSdk;
    }

    public void initSdk(Activity activity) {
        sakuraSDK.init(activity);
        DeviceUtils.initAdvertising(activity, new DeviceUtils.Listener(){

            @Override
            public void onGetAds() {
            }
        });
        this.checkIpRequest(activity);
    }

    @Override
    public void init(@NonNull Application application, String appkey, String facebookId) {
        sApp = application;
        SakuraTracking.getInstance().init(sApp);
        SakuraTracking.getInstance().trackAppLaunch();
        SakuraTracking.getInstance().trackLastSession((Context)sApp);
        GameConfigs.getInstance().setAppKey(appkey);
        GameConfigs.getInstance().initFacebook(facebookId);
        this.mHandler = new Handler();
        this.timerAsync = new Timer();
    }

    @Override
    public void login(final Activity activity, final ILoginListener listener) {
        if (GameConfigs.getInstance().isLogin()) {
            String mess = activity.getResources().getString(R.string.lbl_already_login);
            ToastUtils.showShortToast((Context)activity, mess);
            return;
        }
        LoginPresenterImpl pr = new LoginPresenterImpl(new BaseView(){

            @Override
            public void showProgress(String message) {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Utils.showLoading(activity, true);
                    }
                });
            }

            @Override
            public void hideProgress() {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Utils.showLoading(activity, false);
                    }
                });
            }

            public void success(Object x) {
                if (x instanceof AuthenConfigResponseObj) {
                    AuthenConfigObj obj = ((AuthenConfigResponseObj)x).getData();
                    AuthenConfigs.getInstance().setAuthenConfigObj(obj);
                }
                BaraSdk.this.showFormLogin(activity, new ILoginListener(){

                    @Override
                    public void onLoginSuccess() {
                        AppsFlyerLib.getInstance().setCustomerUserId(GameConfigs.getInstance().getUser().getId() + "");
                        BaraSdk.this.saveFCM(activity);
                        if (listener != null) {
                            listener.onLoginSuccess();
                        }
                        Log.d((String)ProfilePictureView.TAG, (String)("userId : " + GameConfigs.getInstance().getUser().getId()));
                    }

                    @Override
                    public void onRegisterSuccess(String param) {
                    }
                });
            }

            public void error(Object o) {
                BaraSdk.this.showFormLogin(activity, listener);
            }
        });
        pr.getAuthenConfig();
    }

    @Override
    public void showFormLogin(final Activity activity, final ILoginListener listener) {
        if (this.mHandler != null && this.mRunable != null) {
            this.mHandler.removeCallbacks(this.mRunable);
        }
        this.mRunable = new Runnable(){

            @Override
            public void run() {
                DialogFragment newFragment = (DialogFragment)activity.getFragmentManager().findFragmentByTag(LoginFragment.class.getSimpleName());
                if (newFragment == null) {
                    newFragment = LoginFragment.newInstance(listener);
                }
                newFragment.setCancelable(false);
                if (newFragment.getDialog() != null && newFragment.getDialog().isShowing()) {
                    return;
                }
                newFragment.show(activity.getFragmentManager(), LoginFragment.class.getSimpleName());
            }
        };
        this.mHandler.postDelayed(this.mRunable, 200L);
    }

    @Override
    public void logOut(Activity activity) {
        sakuraSDK.logout();
        if (GameConfigs.getInstance().getUser() != null || GameConfigs.getInstance().isLogin()) {
            if (GameConfigs.getInstance().getUser() != null) {
                SakuraTracking.getInstance().trackLogoutSuccess(GameConfigs.getInstance().getUser().getId());
            }
            RetrofitClient.clearInstant();
            GameConfigs.clearInstance();
            GoogleManager.getInstance((Context)sApp).logout();
            FacebookManager.getInstance((Context)sApp).logout();
            PrefManager.saveBoolean((Context)sApp, "SAVE_FCM_NON_TOKEN" + AuthenConfigs.getInstance().getAccessToken(), false);
            PrefManager.saveSetting((Context)sApp, "MANCT_ROLE_ID", "");
            PrefManager.saveSetting((Context)sApp, "MANCT_AREA_ID", "");
            PrefManager.saveAccessToken((Context)sApp, "");
            AppsFlyerLib.getInstance().setCustomerUserId("");
            SakuraHelper.hideNotiFloatButton();
            SakuraSDK.getInstance().logout();
            String mess = activity.getResources().getString(R.string.lbl_log_out_success);
            ToastUtils.showShortToast((Context)activity, mess);
        } else {
            String mess = activity.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showShortToast((Context)activity, mess);
        }
    }

    public void logOut(Activity activity, ILogoutListener logoutListener) {
        this.logOut(activity);
        if (logoutListener != null) {
            logoutListener.onLogoutSuccess();
        }
    }

    @Override
    public void onLoginSuccess(Activity activity, String tab) {
        if (GameConfigs.getInstance().getUser() != null && GameConfigs.getInstance().getUser().getName() != null) {
            String name = GameConfigs.getInstance().getUser().getName();
            name = TextUtils.isEmpty((CharSequence)name) ? "" : " " + name + "!";
            String mess = activity.getResources().getString(R.string.welcome) + name;
            ToastUtils.showShortToast((Context)activity, mess);
        }
        if (GameConfigs.getInstance().getSdkConfig() != null) {
            SakuraHelper.showNotiFloatButton(GameConfigs.getInstance().getSdkConfig().getEx());
        }
    }

    @Override
    public void getMessagesInGame(final Activity activity, final IMesssageListener messsageListener) {
        if (!GameConfigs.getInstance().isLogin()) {
            String mess = activity.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showShortToast((Context)activity, mess);
            return;
        }
        GamePresenterImpl gamePresenter = new GamePresenterImpl(new BaseView(){

            @Override
            public void showProgress(String mess) {
                Utils.showLoading(activity, true);
            }

            @Override
            public void hideProgress() {
                Utils.showLoading(activity, false);
            }

            public void success(Object x) {
                ArrayList<MessInGameObj> obj;
                if (x instanceof MessInGameResponseObj && messsageListener != null && (obj = ((MessInGameResponseObj)x).getData()) != null && obj.size() > 0) {
                    messsageListener.onSuccess(obj);
                }
            }

            public void error(Object o) {
                BaseObj baseObj = (BaseObj)o;
                ToastUtils.showShortToast((Context)activity, baseObj.getMessage());
            }
        });
        gamePresenter.getMessagesInGame();
    }

    @Override
    public void saveCharacter(final Activity activity, final String roleId, final String areaId, final ISaveCharactorListener listener) {
        if (!GameConfigs.getInstance().isLogin()) {
            String mess = activity.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showShortToast((Context)activity, mess);
            return;
        }
        PrefManager.saveSetting((Context)activity, "MANCT_ROLE_ID", roleId);
        PrefManager.saveSetting((Context)activity, "MANCT_AREA_ID", areaId);
        LogUtils.d(ProfilePictureView.TAG, "ROLE_ID :" + roleId);
        LogUtils.d(ProfilePictureView.TAG, "AREA_ID :" + roleId);
        LogUtils.d("saveCharacter", "ROLE_ID :" + roleId + " - AREA_ID :" + roleId);
        GamePresenterImpl gamePresenter = new GamePresenterImpl(new BaseView(){

            @Override
            public void showProgress(String mess) {
                Utils.showLoading(activity, true);
            }

            @Override
            public void hideProgress() {
                Utils.showLoading(activity, false);
            }

            public void success(Object x) {
                if (x instanceof BaseObj && listener != null) {
                    SakuraTracking.getInstance().trackCharactorCreatedSuccess(GameConfigs.getInstance().getUser().getId(), roleId, areaId);
                    listener.onSuccess();
                }
            }

            public void error(Object o) {
                BaseObj baseObj = (BaseObj)o;
                ToastUtils.showShortToast((Context)activity, baseObj.getMessage());
                SakuraTracking.getInstance().trackCharactorCreatedFailed(GameConfigs.getInstance().getUser().getId(), roleId, areaId);
            }
        });
        SakuraTracking.getInstance().trackCharactorCreated(activity, GameConfigs.getInstance().getUser().getId(), roleId, areaId);
        try {
            gamePresenter.saveCharactor(roleId, areaId);
        }
        catch (Exception e) {
            LogUtils.d(ProfilePictureView.TAG, e.getMessage());
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (sakuraSDK != null) {
            sakuraSDK.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void onDestroy() {
        if (sakuraSDK != null) {
            this.timerAsync.cancel();
            sakuraSDK.onDestroySDK();
        }
    }

    @Override
    public void shareImageToFacebook(Activity activity, Bitmap image) {
        if (sakuraSDK != null) {
            sakuraSDK.shareImageToFacebook(activity, image);
        }
    }

    @Override
    public void showTextScroll(ArrayList<MessInGameObj> listNoti) {
        if (sakuraSDK != null) {
            sakuraSDK.showTextScroll(listNoti);
        }
    }

    @Override
    public void onRequestPermissionsResult(Activity gameActivity, int requestCode, String[] permissions, int[] grantResults) {
        if (sakuraSDK != null) {
            sakuraSDK.onRequestPermissionsResult(gameActivity, requestCode, permissions, grantResults);
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        if (sakuraSDK != null) {
            sakuraSDK.onWindowFocusChanged(hasFocus);
        }
    }

    @Override
    public void onBackPressed() {
        sakuraSDK.onBackPressed();
    }

    @Override
    public void payment(final Activity activity, final String state, final IPaymentListener listener) {
        if (this.mHandler != null && this.mRunable != null) {
            this.mHandler.removeCallbacks(this.mRunable);
        }
        this.mRunable = new Runnable(){

            @Override
            public void run() {
                try {
                    Log.i((String)ProfilePictureView.TAG, (String)("payment:" + state));
                    if (!GameConfigs.getInstance().isLogin()) {
                        String mess = activity.getResources().getString(R.string.lbl_not_login);
                        ToastUtils.showShortToast((Context)activity, mess);
                    } else {
                        String role_id = PrefManager.getString((Context)activity, "MANCT_ROLE_ID", "");
                        String area_id = PrefManager.getString((Context)activity, "MANCT_AREA_ID", "");
                        if (TextUtils.isEmpty((CharSequence)role_id) || TextUtils.isEmpty((CharSequence)area_id)) {
                            ToastUtils.showShortToast((Context)activity, activity.getString(R.string.err_empty_charactor));
                            return;
                        }
                        BaraSdk.this.paymentNativeFragment = (DialogFragment)activity.getFragmentManager().findFragmentByTag(PaymentNativeFragment.class.getSimpleName());
                        if (BaraSdk.this.paymentNativeFragment == null) {
                            BaraSdk.this.paymentNativeFragment = PaymentNativeFragment.newInstance(state, new PaymentNativeFragment.PaymentSuccess(){

                                @Override
                                public void onIapPaymentSuccess(PurchaseHistoryObj obj) {
                                    CmdPaymentV3.getInstance().verifyPayment(activity, obj, listener);
                                }

                                @Override
                                public void onLocalPaymentSuccess(VerifyPurchaseObj verifyPurchaseObj) {
                                    listener.onPaymentSuccess(verifyPurchaseObj);
                                }
                            });
                        }
                        if (BaraSdk.this.paymentNativeFragment.getDialog() != null && BaraSdk.this.paymentNativeFragment.getDialog().isShowing()) {
                            return;
                        }
                        BaraSdk.this.paymentNativeFragment.show(activity.getFragmentManager(), PaymentNativeFragment.class.getSimpleName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.mHandler.postDelayed(this.mRunable, 200L);
    }

    public void checkIpRequest(Activity activity) {
        this.dialogFragment = (BlockFragment)activity.getFragmentManager().findFragmentByTag(BlockFragment.class.getSimpleName());
        if (this.dialogFragment == null) {
            this.dialogFragment = BlockFragment.newInstance(new IBlockIpListener(){

                @Override
                public void hideBlock() {
                    if (BaraSdk.this.dialogFragment.getDialog() != null && BaraSdk.this.dialogFragment.getDialog().isShowing()) {
                        BaraSdk.this.dialogFragment.dismiss();
                    }
                }
            });
        }
        this.dialogFragment.setCancelable(true);
        this.dialogFragment.show(activity.getFragmentManager(), BlockFragment.class.getSimpleName());
    }

    public void saveFCM(final Activity activity) {
        if (GameConfigs.getInstance().isLogin() && !PrefManager.getBoolean((Context)sApp, "SAVE_FCM_NON_TOKEN" + AuthenConfigs.getInstance().getAccessToken(), false)) {
            FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<InstanceIdResult>(){

                public void onSuccess(InstanceIdResult instanceIdResult) {
                    String firebaseToken = instanceIdResult.getToken();
                    LogUtils.d(ProfilePictureView.TAG, "Firebase Token/regId: " + firebaseToken);
                    if (GameConfigs.getInstance().getAppKey() != null && GameConfigs.getInstance().getUser() != null) {
                        int userId = GameConfigs.getInstance().getUser().getId();
                        HanaFirebaseMessagingService.getInstance().sendRegistrationToServer(activity, String.valueOf(userId), firebaseToken);
                    }
                }
            });
        } else if (!PrefManager.getBoolean((Context)sApp, "SAVE_FCM_NON_TOKEN", false)) {
            FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<InstanceIdResult>(){

                public void onSuccess(InstanceIdResult instanceIdResult) {
                    String firebaseToken = instanceIdResult.getToken();
                    LogUtils.d(ProfilePictureView.TAG, "Firebase Token/regId: " + firebaseToken);
                    if (GameConfigs.getInstance().getAppKey() != null) {
                        HanaFirebaseMessagingService.getInstance().sendRegistrationToServer(activity, "", firebaseToken);
                    }
                }
            });
        }
    }
}

