/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.comon.config;

import android.content.Context;
import android.text.TextUtils;
import com.bara.SakuraSDK;
import com.sakura.momo.comon.game.BaraSdk;
import com.sakura.momo.comon.login.FacebookManager;
import com.sakura.momo.comon.object.SdkConfigObj;
import com.sakura.momo.comon.object.UserObj;
import com.sakura.momo.comon.sharePref.PrefManager;
import com.sakura.momo.comon.utils.DeviceUtils;

public class GameConfigs {
    private static GameConfigs gameConfigs;
    private String appKey;
    private String adsKey;
    private SdkConfigObj sdkConfig;
    private boolean show_qc;
    private String FCM_APP_API_KEY = "d5f66e393eaab40f72e6b7d3ca5f32f275db5bd5";
    UserObj user;

    public static GameConfigs getInstance() {
        if (gameConfigs == null) {
            gameConfigs = new GameConfigs();
        }
        return gameConfigs;
    }

    private GameConfigs() {
    }

    public static void clearInstance() {
        GameConfigs.getInstance().setUser(null);
        GameConfigs.getInstance().setSdkConfig(null);
    }

    public String getAppKey() {
        if (this.appKey == null) {
            return PrefManager.getAppKey((Context)BaraSdk.getInstance().getApplication());
        }
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
        PrefManager.saveAppKey((Context)BaraSdk.getInstance().getApplication(), appKey);
    }

    public String getAdsKey() {
        if (this.adsKey == null) {
            return PrefManager.getAdsKey((Context)BaraSdk.getInstance().getApplication());
        }
        return this.adsKey;
    }

    public void setAdsKey(String adsKey) {
        this.adsKey = this.appKey;
        PrefManager.saveAdsKey((Context)BaraSdk.getInstance().getApplication(), adsKey);
    }

    public UserObj getUser() {
        if (this.user == null) {
            return PrefManager.getUser((Context)BaraSdk.getInstance().getApplication());
        }
        return this.user;
    }

    public void setUser(UserObj user) {
        this.user = user;
        PrefManager.saveUser((Context)BaraSdk.getInstance().getApplication(), user);
    }

    public SdkConfigObj getSdkConfig() {
        return this.sdkConfig;
    }

    public void setSdkConfig(SdkConfigObj sdkConfig) {
        if (sdkConfig == null) {
            this.sdkConfig = null;
            return;
        }
        this.sdkConfig = sdkConfig;
        if (sdkConfig.getEx() != null && sdkConfig.getEx().isShowLogo()) {
            SakuraSDK.getInstance().requestOverlayPermission(SakuraSDK.activity);
        }
        GameConfigs.getInstance().setShow_qc(true);
        PrefManager.saveBoolean((Context)BaraSdk.getInstance().getApplication(), "shared_pref_db_enabled", true);
        PrefManager.saveSetting((Context)BaraSdk.getInstance().getApplication(), "SESSION_OUT_TIME", sdkConfig.getSessionOutTime());
    }

    public boolean isLogin() {
        return !TextUtils.isEmpty((CharSequence)PrefManager.getAccessToken((Context)BaraSdk.getInstance().getApplication()));
    }

    public void initFacebook(String facebookAppId) {
        FacebookManager.getInstance((Context)BaraSdk.getInstance().getApplication()).init(facebookAppId);
    }

    public boolean getShow_qc() {
        return this.show_qc;
    }

    public void setShow_qc(boolean show_qc) {
        this.show_qc = show_qc;
    }

    public SdkConfigObj.Pop getPopup() {
        if (this.sdkConfig == null || this.sdkConfig.getPop() == null) {
            return new SdkConfigObj.Pop();
        }
        return this.sdkConfig.getPop();
    }

    public String getLang() {
        return DeviceUtils.getLanguage();
    }

    public SdkConfigObj.GoogleIAB getGgIABConfig() {
        return this.sdkConfig == null ? null : new SdkConfigObj.GoogleIAB();
    }

    public String getFcmApiKey() {
        return this.FCM_APP_API_KEY;
    }
}

