/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.comon.cmd;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.quby.R;
import com.sakura.momo.comon.config.GameConfigs;
import com.sakura.momo.comon.listener.IPaymentListener;
import com.sakura.momo.comon.object.BaseObj;
import com.sakura.momo.comon.object.PurchaseHistoryObj;
import com.sakura.momo.comon.object.err.VerifyPurchaseErrObj;
import com.sakura.momo.comon.object.request.VerifyPurchaseRequestObj;
import com.sakura.momo.comon.object.response.VerifyPurchaseResponseObj;
import com.sakura.momo.comon.presenter.BaseView;
import com.sakura.momo.comon.tracking.SakuraTracking;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.comon.utils.DialogUtils;
import com.sakura.momo.comon.utils.LogUtils;
import com.sakura.momo.comon.utils.PurchaseUtils;
import com.sakura.momo.comon.utils.Utils;
import com.sakura.momo.ui.payment.PaymentPresenterImpl;
import java.util.ArrayList;

public class CmdPaymentV3 {
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_IAB = 1;
    private static final int TYPE_PAYPAL = 2;
    private static final String TAG = CmdPaymentV3.class.getSimpleName();
    private BillingClient billingClient;
    Context context;
    private static CmdPaymentV3 INSTANCE;

    public static CmdPaymentV3 getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdPaymentV3();
        }
        return INSTANCE;
    }

    private CmdPaymentV3() {
    }

    public void initIABv3(Context context, BillingClientStateListener billingClientStateListener, PurchasesUpdatedListener purchasesUpdatedListener) {
        if (context != null) {
            this.context = context;
        }
        if (this.billingClient == null) {
            this.billingClient = BillingClient.newBuilder((Context)context).setListener(purchasesUpdatedListener).enablePendingPurchases().build();
        } else {
            Log.d((String)TAG, (String)"BillingClient is not null");
        }
        if (!this.billingClient.isReady()) {
            Log.d((String)TAG, (String)"BillingClient: Start connection...");
            this.billingClient.startConnection(billingClientStateListener);
        } else {
            Log.d((String)TAG, (String)"BillingClient: Started connection");
        }
    }

    public void querySkuDetails(String productID, SkuDetailsResponseListener skuDetailsResponseListener) {
        Log.d((String)TAG, (String)"querySkuDetails");
        ArrayList<String> skus = new ArrayList<String>();
        skus.add(productID);
        SkuDetailsParams params = SkuDetailsParams.newBuilder().setType("inapp").setSkusList(skus).build();
        Log.i((String)TAG, (String)"querySkuDetailsAsync");
        this.billingClient.querySkuDetailsAsync(params, skuDetailsResponseListener);
    }

    public int launchBillingFlow(Activity activity, SkuDetails skuDetail) {
        if (!this.billingClient.isReady()) {
            Log.e((String)TAG, (String)"launchBillingFlow: BillingClient is not ready");
        }
        BillingFlowParams billingFlowParams = BillingFlowParams.newBuilder().setSkuDetails(skuDetail).build();
        BillingResult billingResult = this.billingClient.launchBillingFlow(activity, billingFlowParams);
        int responseCode = billingResult.getResponseCode();
        String debugMessage = billingResult.getDebugMessage();
        Log.d((String)TAG, (String)("launchBillingFlow: BillingResponse " + responseCode + " " + debugMessage));
        return responseCode;
    }

    public void consumeAsyncPurchase(Purchase purchase, ConsumeResponseListener consumeResponseListener) {
        ConsumeParams consumeParams = ConsumeParams.newBuilder().setPurchaseToken(purchase.getPurchaseToken()).build();
        this.billingClient.consumeAsync(consumeParams, consumeResponseListener);
    }

    public void billingEndConnection() {
        if (this.billingClient.isReady()) {
            Log.d((String)TAG, (String)"BillingClient can only be used once -- closing connection");
            this.billingClient.endConnection();
            this.billingClient = null;
        }
    }

    public void queryHistory(PurchaseHistoryResponseListener listener) {
        if (this.billingClient != null && listener != null) {
            this.billingClient.queryPurchaseHistoryAsync("inapp", listener);
        }
    }

    public void verifyPayment(final Activity mActivity, final PurchaseHistoryObj historyObj, final IPaymentListener iPaymentListener) {
        final VerifyPurchaseRequestObj obj = new VerifyPurchaseRequestObj();
        obj.setOrder_no(historyObj.getOrder_no());
        obj.setMethod("2");
        obj.setReceipt(historyObj.getReceipt());
        obj.setApp_version(Utils.getGameVersion((Context)mActivity));
        obj.setSdk_version(Utils.getSDKVersion((Context)mActivity));
        obj.setDevice_name(DeviceUtils.getDevice());
        obj.setDevice_os(DeviceUtils.getOSInfo());
        obj.setResolution(DeviceUtils.getResolution((Context)mActivity));
        obj.setNetwork(Utils.getNetwork((Context)mActivity));
        obj.setAdvertising_id(DeviceUtils.getAdvertisingID((Context)mActivity));
        obj.setAppsflyer_id(DeviceUtils.getAppsflyerUID((Context)mActivity));
        obj.setLocale(GameConfigs.getInstance().getLang());
        PaymentPresenterImpl presenter = new PaymentPresenterImpl(new BaseView(){

            @Override
            public void showProgress(String message) {
                Utils.showLoading(mActivity, true);
            }

            @Override
            public void hideProgress() {
                Utils.showLoading(mActivity, false);
            }

            public void success(Object x) {
                if (x instanceof VerifyPurchaseResponseObj) {
                    VerifyPurchaseResponseObj responseObj = (VerifyPurchaseResponseObj)x;
                    if (responseObj.getData().getStatus() == 3 || responseObj.getData().getStatus() == 2 || responseObj.getData().getStatus() == 17) {
                        LogUtils.e(TAG, "Verify Success - " + historyObj.getOrder_no());
                        PurchaseUtils.removeSuccessPurchase(historyObj, mActivity);
                        SakuraTracking.getInstance().trackPaymentVerifySuccess(responseObj.getData());
                        if (iPaymentListener != null) {
                            iPaymentListener.onPaymentSuccess(responseObj.getData());
                        }
                    } else {
                        SakuraTracking.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "code", String.valueOf(responseObj.getData().getStatus()), responseObj.getData().getDescription());
                        DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.err_verify_purchase), new DialogUtils.DlgCloseListener(){

                            @Override
                            public void onClose() {
                            }
                        });
                    }
                }
            }

            public void error(Object o) {
                BaseObj apiErrorObj = (BaseObj)o;
                SakuraTracking.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "http", String.valueOf(apiErrorObj.getStatus()), apiErrorObj.getMessage());
                if (apiErrorObj.getStatus() == -100) {
                    DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.error_network));
                    return;
                }
                if (o instanceof VerifyPurchaseErrObj) {
                    VerifyPurchaseErrObj obj2 = (VerifyPurchaseErrObj)o;
                    if (obj2.getStatus() == 401) {
                        DialogUtils.showExpireDialog(mActivity);
                    } else {
                        final int count_time = mActivity.getIntent().getIntExtra("count_time", 0);
                        if (count_time <= 2) {
                            DialogUtils.showPaymentRetryDialog(mActivity, obj2.getMessage(), new DialogUtils.Listener(){

                                @Override
                                public void onRetry() {
                                    mActivity.getIntent().putExtra("count_time", count_time + 1);
                                    CmdPaymentV3.this.verifyPayment(mActivity, historyObj, iPaymentListener);
                                }
                            });
                        } else {
                            DialogUtils.showErrorDialog(mActivity, obj2.getMessage(), new DialogUtils.DlgCloseListener(){

                                @Override
                                public void onClose() {
                                }
                            });
                        }
                    }
                }
            }
        });
        SakuraTracking.getInstance().trackPaymentBeforVerify(historyObj.getOrder_no());
        presenter.verifyPurchase(obj);
    }
}

