/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.comon.api;

import android.content.Context;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.sakura.momo.comon.game.BaraSdk;
import com.sakura.momo.comon.object.BaseObj;
import com.sakura.momo.comon.utils.LogUtils;
import com.sakura.momo.comon.utils.NetworkUtils;
import java.io.IOException;
import java.util.Objects;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class MyCallback<T extends BaseObj>
implements Callback<T> {
    public static final String TAG = MyCallback.class.getSimpleName();

    public void onResponse(@NonNull Call<T> call, Response<T> response) {
        if (!response.isSuccessful() && response.errorBody() != null && response.code() == 200) {
            String errorMessage = null;
            try {
                Gson gson = new Gson();
                errorMessage = response.errorBody().string();
                BaseObj apiErrorObj = (BaseObj)gson.fromJson(errorMessage, BaseObj.class);
                apiErrorObj.setStatus(response.code());
                this.onError(call, apiErrorObj);
            }
            catch (IOException e) {
                BaseObj apiErrorObj = new BaseObj();
                apiErrorObj.setStatus(response.code());
                apiErrorObj.setMessage(e.getMessage());
                this.onError(call, apiErrorObj);
                LogUtils.printStackTrace(e);
            }
            catch (Exception e) {
                BaseObj apiErrorObj = new BaseObj();
                apiErrorObj.setStatus(response.code());
                apiErrorObj.setMessage(e.getMessage());
                BaseObj.createError("server error", apiErrorObj.getStatus() + "=> " + errorMessage);
                this.onError(call, apiErrorObj);
                LogUtils.printStackTrace(e);
            }
            return;
        }
        BaseObj t = (BaseObj)response.body();
        if (t == null) {
            BaseObj apiErrorObj = new BaseObj();
            try {
                JSONObject jObjError = new JSONObject(Objects.requireNonNull(response.errorBody()).string());
                if (jObjError.has("message")) {
                    apiErrorObj.setMessage(jObjError.getString("message"));
                }
            }
            catch (Exception e) {
                apiErrorObj.setMessage(response.message());
            }
            apiErrorObj.setStatus(response.code());
            BaseObj.createError("null", "No data");
            LogUtils.e(TAG, "Error4: ======> " + apiErrorObj.getStatus());
            this.onError(call, apiErrorObj);
            return;
        }
        if (t instanceof BaseObj & response.code() == 200) {
            this.onSuccess(call, response);
        } else {
            BaseObj apiErrorObj = new BaseObj();
            apiErrorObj.setMessage(response.message());
            apiErrorObj.setStatus(response.code());
            this.onError(call, apiErrorObj);
        }
    }

    public void onFailure(@NonNull Call<T> call, Throwable t) {
        if (t.getMessage() != null) {
            LogUtils.e("Error113", t.getMessage());
        }
        BaseObj apiErrorObj = null;
        if (!NetworkUtils.isConnect((Context)BaraSdk.getInstance().getApplication())) {
            apiErrorObj = BaseObj.createError("", "No Connect");
            apiErrorObj.setStatus(-100);
            this.onError(call, apiErrorObj);
        } else if (!call.isCanceled()) {
            apiErrorObj = BaseObj.createError("", t.getMessage());
            this.onError(call, apiErrorObj);
        }
        if (apiErrorObj != null) {
            LogUtils.e(TAG, "Error4: ======> " + apiErrorObj.getStatus());
        }
    }

    public abstract void onSuccess(Call<T> var1, Response<T> var2);

    public abstract void onError(Call<T> var1, Object var2);
}

