/*
 * Decompiled with CFR 0.152.
 */
package com.sakura.momo.comon.api;

import android.content.Context;
import android.text.TextUtils;
import com.sakura.momo.comon.api.RetrofitClient;
import com.sakura.momo.comon.api.request.GameRequest;
import com.sakura.momo.comon.api.request.LoginRequest;
import com.sakura.momo.comon.api.request.NotificationRequest;
import com.sakura.momo.comon.api.request.PaymentRequest;
import com.sakura.momo.comon.config.AuthenConfigs;
import com.sakura.momo.comon.config.GameConfigs;
import com.sakura.momo.comon.object.request.VerifyPurchaseRequestObj;
import com.sakura.momo.comon.sharePref.PrefManager;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.comon.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import retrofit2.Retrofit;

public class ApiUtils {
    public static LoginRequest getLoginRequest() {
        if (RetrofitClient.getInstance() == null) {
            return null;
        }
        return (LoginRequest)RetrofitClient.getInstance().create(LoginRequest.class);
    }

    public static GameRequest getGameRequest() {
        if (RetrofitClient.getInstance() == null) {
            return null;
        }
        return (GameRequest)RetrofitClient.getInstance().create(GameRequest.class);
    }

    public static NotificationRequest getNotificationRequest() {
        Retrofit rft = RetrofitClient.getInteractInstance("https://interact.bacanasa.com/");
        if (rft == null) {
            return null;
        }
        return (NotificationRequest)rft.create(NotificationRequest.class);
    }

    public static PaymentRequest getPaymentRequest() {
        Retrofit rft = RetrofitClient.getPaymentInstance("https://yap.bacanasa.com/");
        if (rft == null) {
            return null;
        }
        return (PaymentRequest)rft.create(PaymentRequest.class);
    }

    public static String getUrlWvRegister(Context ct) {
        String appKey = PrefManager.getAppKey(ct);
        String appVersion = Utils.getGameVersion(ct);
        String url = PrefManager.getString(ct, "APP_UR", "https://eroc.bacanasa.com/") + "hn/bakaa/{app_key}/{app_version}/danggkiy/emaiill";
        url = url + "?sdk_version=" + Utils.stringNormalize(Utils.getSDKVersion(ct));
        url = url + "&device_network=" + Utils.stringNormalize(Utils.getNetwork(ct));
        url = url + "&appsflyer_id=" + DeviceUtils.getAppsflyerUID(ct);
        url = url + "&advertising_id=" + DeviceUtils.getAdvertisingID(ct);
        url = url + "&device_os=" + Utils.stringNormalize(DeviceUtils.getOSInfo());
        url = url + "&device_name=" + Utils.stringNormalize(DeviceUtils.getDevice());
        return url.replace("{app_key}", appKey).replace("{app_version}", appVersion);
    }

    public static String getUrlWvPayment(Context ct, String state) {
        VerifyPurchaseRequestObj obj = new VerifyPurchaseRequestObj();
        obj.setMethod("2");
        HashMap<String, String> params = new HashMap<String, String>();
        Set set = params.entrySet();
        params.put("x_request", GameConfigs.getInstance().getAppKey());
        params.put("device_id", DeviceUtils.getUniqueDeviceID(ct));
        params.put("method", "2");
        params.put("character_id", PrefManager.getString(ct, "MANCT_ROLE_ID", ""));
        params.put("area_id", PrefManager.getString(ct, "MANCT_AREA_ID", ""));
        params.put("app_version", Utils.getGameVersion(ct));
        params.put("sdk_version", Utils.getSDKVersion(ct));
        params.put("device_name", DeviceUtils.getDevice());
        params.put("device_os", DeviceUtils.getOSInfo());
        params.put("resolution", DeviceUtils.getResolution(ct));
        params.put("network", Utils.getNetwork(ct));
        params.put("advertising_id", DeviceUtils.getAdvertisingID(ct));
        params.put("appsflyer_id", DeviceUtils.getAppsflyerUID(ct));
        params.put("locale", GameConfigs.getInstance().getLang());
        params.put("access_token", AuthenConfigs.getInstance().getAccessToken());
        String url = "https://yap.bacanasa.com/wv/sdk/items";
        url = !TextUtils.isEmpty((CharSequence)state) ? url + "?payload=" + state : url + "?hl=en";
        for (Map.Entry param : set) {
            if (TextUtils.isEmpty((CharSequence)((CharSequence)param.getValue()))) continue;
            url = url + "&" + (String)param.getKey() + "=" + (String)param.getValue();
        }
        return url.replace(" ", "%20");
    }

    public static String getUrlTerm(Context ct) {
        String appKey = PrefManager.getAppKey(ct);
        String appVersion = Utils.getGameVersion(ct);
        String url = PrefManager.getString(ct, "APP_UR", "https://eroc.bacanasa.com/") + "hn/bakaa/{app_key}/{app_version}/policy";
        return url.replace("{app_key}", appKey).replace("{app_version}", appVersion);
    }

    public static String getUrlBlockIP(Context context) {
        String url = "https://eroc.bacanasa.com/hn/bakaa/{app_Key}/{app_Version}/showwConfigure";
        String appKey = PrefManager.getAppKey(context);
        String appVersion = Utils.getGameVersion(context);
        return url.replace("{app_Key}", appKey).replace("{app_Version}", appVersion);
    }
}

