/*
 * Decompiled with CFR 0.152.
 */
package com.bara.utils;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import androidx.core.app.TaskStackBuilder;
import com.bara.model.NtfModel;
import com.bara.utils.Preference;
import com.bara.utils.Res;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.google.gson.Gson;
import com.quby.R;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.comon.utils.Utils;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NotificationUtils {
    static ArrayList<NtfModel> listNtf = new ArrayList();
    private static String TAG = "NotificationUtils";
    private Class mainClass;
    private Context context;
    private String title;
    private String message;
    private String imageUrl;
    private int smallIcon;
    private String deeplink;
    private String urlDeepLink;
    private String typeLink;
    private String urlBanner;
    private static NotificationUtils instance;

    public void showNotification() {
        String name = "channel";
        String description = "channel des";
        Log.i((String)TAG, (String)("showNotification:title=" + this.title + ";msg=" + this.message));
        try {
            Log.i((String)TAG, (String)("mainClass:" + this.mainClass));
            if (this.mainClass == null) {
                try {
                    String className = Preference.getString(this.context, "shared_pref_main_activity");
                    this.mainClass = Class.forName(className);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            Drawable ico = this.context.getApplicationInfo().loadIcon(this.context.getPackageManager());
            Bitmap bitmap = Utils.drawableToBitmap(ico);
            int bitmapSize = (int)Math.min(64.0f * DeviceUtils.getDensity(this.context), (float)bitmap.getWidth());
            CharSequence appTitle = this.context.getApplicationInfo().loadLabel(this.context.getPackageManager());
            NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
            bigTextStyle.setBigContentTitle((CharSequence)this.title);
            bigTextStyle.bigText((CharSequence)this.message);
            bigTextStyle.setSummaryText(appTitle);
            NotificationManager mNotificationManager = (NotificationManager)this.context.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                int importance = 4;
                NotificationChannel mChannel = mNotificationManager.getNotificationChannel(this.title);
                if (mChannel == null) {
                    mChannel = new NotificationChannel(this.title, (CharSequence)name, importance);
                    mChannel.setDescription(description);
                    mChannel.enableVibration(true);
                    mChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
                    mNotificationManager.createNotificationChannel(mChannel);
                }
            }
            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context, this.title).setWhen(System.currentTimeMillis()).setContentText((CharSequence)this.message).setContentTitle((CharSequence)this.title).setSmallIcon(NotificationUtils.getDrawableSmall(this.context)).setLargeIcon(Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmapSize, (int)bitmapSize, (boolean)false)).setAutoCancel(true).setTicker((CharSequence)this.title).setNumber(NotificationUtils.countNtfs(this.context)).setStyle((NotificationCompat.Style)bigTextStyle).setDefaults(7);
            Intent resultIntent = new Intent(this.context, this.mainClass);
            resultIntent.setFlags(0x14000000);
            resultIntent.putExtra("title", this.title);
            resultIntent.putExtra("message", this.message);
            resultIntent.putExtra("deep_link", this.deeplink);
            TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)this.context);
            stackBuilder.addParentStack(this.mainClass);
            stackBuilder.addNextIntent(resultIntent);
            PendingIntent resultPendingIntent = PendingIntent.getActivity((Context)this.context.getApplicationContext(), (int)959, (Intent)resultIntent, (int)0x8000000);
            mBuilder.setContentIntent(resultPendingIntent);
            mNotificationManager.notify(1, mBuilder.build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showNotificationWithImage() {
        String name = "channel with image";
        String description = "channel img des";
        Log.i((String)TAG, (String)("showNotification:title=" + this.title + ";msg=" + this.message));
        try {
            Log.i((String)TAG, (String)("mainClass:" + this.mainClass));
            if (this.mainClass == null) {
                try {
                    String className = Preference.getString(this.context, "shared_pref_main_activity");
                    this.mainClass = Class.forName(className);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            Drawable ico = this.context.getApplicationInfo().loadIcon(this.context.getPackageManager());
            Bitmap bitmap = Utils.drawableToBitmap(ico);
            int bitmapSize = (int)Math.min(64.0f * DeviceUtils.getDensity(this.context), (float)bitmap.getWidth());
            Bitmap bigPictureBitmap = (Bitmap)Glide.with((Context)this.context).asBitmap().load(this.imageUrl).apply(new RequestOptions().centerCrop()).into(512, 256).get();
            NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
            bigPictureStyle.setSummaryText((CharSequence)this.message);
            bigPictureStyle.bigPicture(bigPictureBitmap);
            bigPictureStyle.setBigContentTitle((CharSequence)this.title);
            NotificationManager mNotificationManager = (NotificationManager)this.context.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                int importance = 4;
                NotificationChannel mChannel = mNotificationManager.getNotificationChannel(this.title);
                if (mChannel == null) {
                    mChannel = new NotificationChannel(this.title, (CharSequence)name, importance);
                    mChannel.setDescription(description);
                    mChannel.enableVibration(true);
                    mChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
                    mNotificationManager.createNotificationChannel(mChannel);
                }
            }
            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context, this.title).setWhen(System.currentTimeMillis()).setContentText((CharSequence)this.message).setContentTitle((CharSequence)this.title).setSmallIcon(NotificationUtils.getDrawableSmall(this.context)).setLargeIcon(Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmapSize, (int)bitmapSize, (boolean)false)).setAutoCancel(true).setTicker((CharSequence)this.title).setNumber(NotificationUtils.countNtfs(this.context)).setStyle((NotificationCompat.Style)bigPictureStyle).setDefaults(7);
            Intent resultIntent = new Intent(this.context, this.mainClass);
            resultIntent.setFlags(0x14000000);
            resultIntent.putExtra("title", this.title);
            resultIntent.putExtra("message", this.message);
            resultIntent.putExtra("deep_link", this.deeplink);
            TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)this.context);
            stackBuilder.addParentStack(this.mainClass);
            stackBuilder.addNextIntent(resultIntent);
            PendingIntent resultPendingIntent = PendingIntent.getActivity((Context)this.context.getApplicationContext(), (int)959, (Intent)resultIntent, (int)0x8000000);
            mBuilder.setContentIntent(resultPendingIntent);
            mNotificationManager.notify(1, mBuilder.build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getDrawableSmall(Context c) {
        return Res.drawableResource(c, R.drawable.ic_stat_mob);
    }

    public static ArrayList<NtfModel> getListNtfFromAfterAuth() {
        try {
            return listNtf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return listNtf;
        }
    }

    public static void setListNtfFromAfterAuth(ArrayList<NtfModel> listNtfs) {
        try {
            listNtf = listNtfs;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addNtf(Context c, NtfModel ntfModel) {
        try {
            String ntfsString = Preference.getString(c, "shared_pref_notificatons");
            ArrayList<NtfModel> listNtfs = new ArrayList<NtfModel>();
            try {
                if (ntfsString != null || !ntfsString.equals("")) {
                    Log.d((String)TAG, (String)("ntfsString : " + ntfsString));
                    JSONArray ntfs = new JSONArray(ntfsString);
                    if (ntfs.length() > 0) {
                        for (int i = 0; i < ntfs.length(); ++i) {
                            JSONObject obj = new JSONObject();
                            obj = ntfs.getJSONObject(i);
                            NtfModel ntf = new NtfModel();
                            ntf = (NtfModel)new Gson().fromJson(obj.toString(), NtfModel.class);
                            listNtfs.add(ntf);
                        }
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            listNtfs.add(ntfModel);
            String strNtf = new Gson().toJson(listNtfs);
            Preference.save(c, "shared_pref_notificatons", strNtf);
            Log.d((String)TAG, (String)("NotificationId : " + strNtf));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeNtf(Context c, int id2) {
        Log.d((String)TAG, (String)("removeNotificationId" + id2));
        try {
            String ntfsString = Preference.getString(c, "shared_pref_notificatons");
            JSONArray ntfs = new JSONArray(ntfsString);
            JSONArray newNtfs = new JSONArray();
            ArrayList<NtfModel> newlistNtfs = new ArrayList<NtfModel>();
            for (int i = 0; i < ntfs.length(); ++i) {
                JSONObject jsObj = new JSONObject();
                jsObj = ntfs.getJSONObject(i);
                NtfModel ntf = new NtfModel();
                ntf.setId(jsObj.getInt("id"));
                ntf.setTitle(jsObj.getString("title"));
                ntf.setNoti(jsObj.getBoolean("noti"));
                if (id2 == ntf.getId()) continue;
                newlistNtfs.add(ntf);
                newNtfs = new JSONArray(new Gson().toJson(newlistNtfs));
            }
            Log.d((String)TAG, (String)("NotificationId remove():" + newNtfs.toString()));
            Preference.save(c, "shared_pref_notificatons", newNtfs.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static boolean hasNtf(Context c) {
        Log.d((String)TAG, (String)("NTF : " + !NotificationUtils.getNtfs(c).isEmpty()));
        return !NotificationUtils.getNtfs(c).isEmpty();
    }

    public static boolean hasNtf(Context c, int id2) {
        try {
            ArrayList<Object> ntfModels = new ArrayList();
            ntfModels = NotificationUtils.getNtfs(c);
            for (NtfModel ntfModel : ntfModels) {
                if (ntfModel.getId() != id2) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ArrayList<NtfModel> getNtfs(Context c) {
        try {
            String ntfsString = Preference.getString(c, "shared_pref_notificatons");
            Log.d((String)TAG, (String)("ntfsString : " + ntfsString));
            if (ntfsString != null || !ntfsString.equals("")) {
                JSONArray ntfs = new JSONArray(ntfsString);
                ArrayList<NtfModel> ntfModels = new ArrayList<NtfModel>();
                for (int i = ntfs.length() - 1; i >= 0; --i) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject = ntfs.getJSONObject(i);
                    NtfModel ntfModel = new NtfModel();
                    ntfModel.setId(jsonObject.getInt("id"));
                    ntfModel.setTitle(jsonObject.getString("title"));
                    ntfModel.setNoti(jsonObject.getBoolean("noti"));
                    ntfModels.add(ntfModel);
                }
                return ntfModels;
            }
            return new ArrayList<NtfModel>();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new ArrayList<NtfModel>();
        }
    }

    public static int countNtfs(Context c) {
        try {
            return NotificationUtils.getNtfs(c).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public NotificationUtils(Context context) {
        this.context = context;
    }

    public static NotificationUtils getInstance(Context context) {
        if (instance == null) {
            instance = new NotificationUtils(context);
        }
        return instance;
    }

    public NotificationUtils setMainClass(Class mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public NotificationUtils setImageUrl(String url) {
        this.imageUrl = url;
        return this;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public Context getContext() {
        return this.context;
    }

    public NotificationUtils setContext(Context context) {
        this.context = context;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public NotificationUtils setTitle(String title) {
        this.title = title != null ? title : "";
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public NotificationUtils setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getDeeplink() {
        return this.deeplink;
    }

    public NotificationUtils setDeeplink(String deeplink) {
        this.deeplink = deeplink;
        return this;
    }

    public int getSmallIcon() {
        return this.smallIcon;
    }

    public NotificationUtils setSmallIcon(int smallIcon) {
        this.smallIcon = smallIcon;
        return this;
    }
}

