/*
 * Decompiled with CFR 0.152.
 */
package com.bara.model.giftimage;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import com.bara.model.giftimage.ImageData;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class GifData {
    private final String TAG = "GifData";
    private int numberImageLoaded = 0;
    private ArrayList<ImageData> images;
    private int secondsToRun;
    private long milisecondsToRefesh;
    private long startTime;

    public static GifData parse(String jsonDataString) throws Exception {
        GifData gifData = new GifData();
        JSONObject jsonGifData = new JSONObject(jsonDataString);
        ArrayList<ImageData> images = new ArrayList<ImageData>();
        JSONArray imagesDataObj = jsonGifData.optJSONArray("images");
        for (int i = 0; i < imagesDataObj.length(); ++i) {
            images.add(new ImageData(imagesDataObj.optString(i)));
        }
        gifData.setImages(images);
        gifData.setMilisecondsToRefesh(jsonGifData.optLong("millisecondsToRefresh"));
        gifData.setSecondsToRun(jsonGifData.optInt("secondsToRun"));
        return gifData;
    }

    private void increeNumberImageLoaded() {
        ++this.numberImageLoaded;
    }

    private void resetNumberImageLoaded() {
        this.numberImageLoaded = 0;
    }

    public void fetchFrameImages(Context context, final FetchDataListener fetchDataListener) {
        if (this.images == null) {
            return;
        }
        final int imageSize = this.images.size();
        int i = 0;
        while (i < imageSize) {
            final int index = i++;
            Glide.with((Context)context).asBitmap().load(this.images.get(index).getUrl()).into((Target)new SimpleTarget<Bitmap>(){

                public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                    try {
                        GifData.this.increeNumberImageLoaded();
                        if (GifData.this.numberImageLoaded == imageSize) {
                            GifData.this.resetNumberImageLoaded();
                            if (fetchDataListener != null) {
                                fetchDataListener.done(GifData.this);
                            }
                        }
                    }
                    catch (Exception e) {
                        fetchDataListener.fail(e.getMessage());
                    }
                }

                public void onLoadFailed(@Nullable Drawable errorDrawable) {
                    if (fetchDataListener != null) {
                        String errorMessage = "Load image fail!  - " + ((ImageData)GifData.this.images.get(index)).getUrl();
                        fetchDataListener.fail(errorMessage);
                    }
                }
            });
        }
    }

    public ArrayList<ImageData> getImages() {
        return this.images;
    }

    public void setImages(ArrayList<ImageData> images) {
        this.images = images;
    }

    public int getSecondsToRun() {
        return this.secondsToRun;
    }

    public void setSecondsToRun(int secondsToRun) {
        this.secondsToRun = secondsToRun;
    }

    public long getMilisecondsToRefesh() {
        return this.milisecondsToRefesh;
    }

    public void setMilisecondsToRefesh(long milisecondsToRefesh) {
        this.milisecondsToRefesh = milisecondsToRefesh;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public static interface FetchDataListener {
        public void done(GifData var1);

        public void fail(String var1);
    }
}

