/*
 * Decompiled with CFR 0.152.
 */
package com.bara.model;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.bara.model.TimerObject;
import com.bara.utils.FloatButtonTimerHelper;
import com.bara.utils.TimeUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Calendar;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TimerData {
    public static final String TAG = TimerData.class.getSimpleName();
    private ArrayList<TimerObject> listTimerObject;

    public static TimerData parse(JSONArray timerObjs) throws JSONException {
        Log.d((String)TAG, (String)("TimerData::parse: " + timerObjs));
        if (timerObjs == null) {
            return new TimerData();
        }
        ArrayList<TimerObject> listTimer = new ArrayList<TimerObject>();
        long now = Calendar.getInstance().getTimeInMillis();
        for (int i = 0; i < timerObjs.length(); ++i) {
            try {
                JSONObject timerObj = timerObjs.optJSONObject(i);
                long startTimeMils = TimeUtils.getMilisecondByTimestamp(timerObj.optLong("start"));
                long endTimeMilis = TimeUtils.getMilisecondByTimestamp(timerObj.optLong("end"));
                int id2 = timerObj.getInt("id");
                if (startTimeMils <= 0L || endTimeMilis <= 0L) {
                    Log.d((String)TAG, (String)String.format("Time value <= 0. Skip!", new Object[0]));
                    continue;
                }
                if (endTimeMilis < now) {
                    Log.d((String)TAG, (String)String.format("EndTime(%s) < Now(%s) => Expired!", endTimeMilis, now));
                    continue;
                }
                TimerObject timer = new TimerObject();
                timer.setId(id2);
                timer.setStartTime(startTimeMils);
                timer.setEndTime(endTimeMilis);
                listTimer.add(timer);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        TimerData timerData = new TimerData();
        timerData.setListTimerObject(listTimer);
        return timerData;
    }

    public void removeData(Activity activity, TimerObject timer, ArrayList<TimerObject> listTimers) {
        for (int i = 0; i < listTimers.size(); ++i) {
            if (listTimers.get(i).getId() != timer.getId()) continue;
            listTimers.remove(i);
        }
        TimerData timerData = new TimerData();
        timerData.setListTimerObject(listTimers);
        this.saveData((Context)activity, timerData);
    }

    public void saveData(Context context, TimerData timerData) {
        Log.i((String)TAG, (String)("saveData: " + new Gson().toJson((Object)timerData)));
        FloatButtonTimerHelper.saveFloatButtonTimer(context, new Gson().toJson((Object)timerData));
    }

    public ArrayList<TimerObject> getListTimerObject() {
        return this.listTimerObject;
    }

    public void setListTimerObject(ArrayList<TimerObject> listTimerObject) {
        this.listTimerObject = listTimerObject;
    }
}

