/*
 * Decompiled with CFR 0.152.
 */
package com.bara.gui.float18button;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.Transformation;
import android.widget.ImageView;
import com.bara.utils.Preference;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.quby.R;
import com.sakura.momo.comon.object.SdkConfigObj;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.comon.utils.LogUtils;

@SuppressLint(value={"InflateParams", "ClickableViewAccessibility"})
public class NotiFloatGestureView {
    private static final String TAG = NotiFloatGestureView.class.getSimpleName();
    private static final int ANIMAION_TIME_FADE_OUT = 300;
    private static final int ANIMAION_TIME_FADE_IN = 200;
    private static final int IDLE_TIME = 4000;
    private static final int IDLE_TIME2 = 1000;
    static final int ANIMAION_TIME_MOVE_TO_EDGE = 200;
    static final int BUTTON_SIZE = 35;
    Activity activity;
    View rootView;
    View floatArea;
    EventListener listener;
    GestureDetector gestureDetector;
    ImageView floatButton;
    int buttonSize;
    int movableWidth;
    int movableHeight;
    float density;
    long timeTouchDown;
    long timeTouchUp;
    float deltaX;
    float deltaY;
    private Handler idleHandler = new Handler();
    private View animationLayout;
    private View layoutFloat;
    private boolean fadeOuted;
    private boolean isHideFloatButton = false;
    WindowManager windowManager;
    WindowManager.LayoutParams params;
    SdkConfigObj.Ex ex;
    private View.OnTouchListener mOnTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            boolean comsumed = true;
            try {
                NotiFloatGestureView.this.gestureDetector.onTouchEvent(event);
                NotiFloatGestureView.this.handlerFadeOut();
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        NotiFloatGestureView.this.timeTouchDown = System.currentTimeMillis();
                        NotiFloatGestureView.this.onTouchDown(event);
                        break;
                    }
                    case 1: {
                        NotiFloatGestureView.this.onTouchUp(event);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 2: {
                        NotiFloatGestureView.this.onTouchMove(event);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return comsumed;
        }
    };
    GestureListener mGestureListener = new GestureListener();
    private Runnable mIdleRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                NotiFloatGestureView.this.fadeOut(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private Runnable mIdleRunnable2 = new Runnable(){

        @Override
        public void run() {
            NotiFloatGestureView.this.fadeOut2(true);
        }
    };

    public NotiFloatGestureView(Activity a, SdkConfigObj.Ex ex) {
        this.activity = a;
        this.ex = ex;
        this.density = DeviceUtils.getDensity((Context)a);
        this.movableWidth = DeviceUtils.getScreenWidthInPixels((Context)a);
        this.movableHeight = DeviceUtils.getScreenHeightInPixels((Context)a);
        this.buttonSize = (int)(35.0f * this.density);
        this.gestureDetector = new GestureDetector((Context)a, (GestureDetector.OnGestureListener)new GestureListener());
        this.initView();
        this.attachView();
    }

    public void initView() {
        String urlIcon;
        this.rootView = LayoutInflater.from((Context)this.activity).inflate(R.layout.float_area_noti, null);
        this.floatArea = this.rootView.findViewById(R.id.layout_float_noti);
        this.animationLayout = this.rootView.findViewById(R.id.ll_image18);
        this.layoutFloat = this.rootView.findViewById(R.id.rl_image18);
        this.floatButton = (ImageView)this.rootView.findViewById(R.id.img_float_noti);
        this.floatArea.getLayoutParams().width = this.buttonSize;
        this.floatArea.setOnTouchListener(this.mOnTouchListener);
        if (this.ex != null && this.ex.getLogoUrl() != null && !TextUtils.isEmpty((CharSequence)(urlIcon = this.ex.getLogoUrl()))) {
            Log.d((String)TAG, (String)("urlIcon : " + urlIcon));
            RequestOptions options = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().centerInside()).placeholder(R.drawable.logotuoi)).error(R.drawable.logotuoi)).priority(Priority.HIGH);
            Glide.with((Activity)this.activity).load(urlIcon).apply((BaseRequestOptions)options).into(this.floatButton);
        }
    }

    public void attachView() {
        try {
            this.windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
            this.params = Build.VERSION.SDK_INT >= 26 ? new WindowManager.LayoutParams(-2, -2, 2038, 8, -2) : new WindowManager.LayoutParams(-2, -2, 2002, 8, -2);
            this.params.gravity = 51;
            this.params.x = Preference.getInt((Context)this.activity, "params_x", 0);
            this.params.y = Preference.getInt((Context)this.activity, "params_y", 0);
            Log.d((String)TAG, (String)("Toa do : " + this.params.x + " , " + this.params.y));
            this.windowManager.addView(this.rootView, (ViewGroup.LayoutParams)this.params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEventListener(EventListener listener) {
        this.listener = listener;
    }

    public void setMovableWidth(int width) {
        this.movableWidth = width;
    }

    public void setMovableHeight(int height) {
        this.movableHeight = height;
    }

    public int getSize() {
        return 35;
    }

    public int getSizeInPixels() {
        return this.buttonSize;
    }

    public int getX() {
        if (this.rootView == null) {
            return 0;
        }
        return this.params.x;
    }

    public int getY() {
        if (this.rootView == null) {
            return 0;
        }
        return this.params.y;
    }

    public void moveTo(int x, int y) {
        this.moveTo(x, y, false);
    }

    public void moveTo(int x, int y, boolean isAnimated) {
        try {
            this.params.x = x;
            this.params.y = y;
            this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
            if (this.listener != null) {
                this.listener.onMove(this.params.x, this.params.y);
                this.listener.onTouchUp(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveToEdge(boolean isAnimated) {
        try {
            if (isAnimated) {
                Animation animation = new Animation(){

                    protected void applyTransformation(float interpolatedTime, Transformation t) {
                        super.applyTransformation(interpolatedTime, t);
                        try {
                            float left = NotiFloatGestureView.this.params.x;
                            float right = (float)(NotiFloatGestureView.this.movableWidth - NotiFloatGestureView.this.buttonSize) - left;
                            NotiFloatGestureView.this.params.x = left <= right ? (int)(left - left * interpolatedTime) : (int)(left - (left - (float)NotiFloatGestureView.this.movableWidth) * interpolatedTime);
                            NotiFloatGestureView.this.windowManager.updateViewLayout(NotiFloatGestureView.this.rootView, (ViewGroup.LayoutParams)NotiFloatGestureView.this.params);
                            if (NotiFloatGestureView.this.listener != null) {
                                NotiFloatGestureView.this.listener.onMove(NotiFloatGestureView.this.params.x, NotiFloatGestureView.this.params.y);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                animation.setDuration(200L);
                animation.setInterpolator((Interpolator)new OvershootInterpolator(0.5f));
                this.floatArea.startAnimation(animation);
            } else {
                float left = this.params.x;
                float right = (float)(this.movableWidth - this.buttonSize) - left;
                this.params.x = left <= right ? 0 : this.movableWidth - this.buttonSize;
                this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
                if (this.listener != null) {
                    this.listener.onMove(this.params.x, this.params.y);
                }
            }
            Preference.save((Context)this.activity, "params_x", this.params.x);
            Preference.save((Context)this.activity, "params_y", this.params.y);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchDown(MotionEvent event) {
        try {
            this.fadeIn(true);
            this.deltaX = event.getX();
            this.deltaY = event.getY();
            if (this.listener != null) {
                this.listener.onTouchDown(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchMove(MotionEvent event) {
        try {
            float left = event.getRawX() - this.deltaX;
            float top = event.getRawY() - this.deltaY;
            left = Math.max(0.0f, Math.min((float)this.movableWidth, left));
            top = Math.max(0.0f, Math.min((float)this.movableHeight, top));
            this.params.x = (int)left;
            this.params.y = (int)top;
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)this.params);
            this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
            if (this.listener != null) {
                this.listener.onTouchMove(event);
                this.listener.onMove(this.params.x, this.params.y);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchUp(MotionEvent event) {
        if (this.listener != null) {
            this.listener.onTouchUp(event);
        }
    }

    public void show() {
        try {
            this.isHideFloatButton = false;
            this.rootView.setVisibility(0);
            this.idleHandler.removeCallbacksAndMessages(null);
            this.fadeIn(false);
            this.handlerFadeOut();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hide() {
        try {
            if (this.rootView != null) {
                this.isHideFloatButton = true;
                this.rootView.setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        try {
            this.rootView.setVisibility(8);
            this.windowManager.removeView(this.rootView);
            this.rootView = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fadeIn(boolean isAnimated) {
        try {
            this.idleHandler.removeCallbacksAndMessages(null);
            if (isAnimated) {
                this.animationLayout.animate().setDuration(200L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).alpha(1.0f);
            } else {
                this.animationLayout.setAlpha(1.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handlerFadeOut() {
        Log.d((String)TAG, (String)"handlerFadeOut: ");
        if (this.idleHandler == null) {
            this.idleHandler = new Handler();
        }
        this.idleHandler.removeCallbacksAndMessages(null);
        this.idleHandler.postDelayed(this.mIdleRunnable, 4000L);
    }

    public void fadeOut(boolean isAnimated) {
        LogUtils.d(TAG, "fadeOut 1");
        try {
            if (isAnimated) {
                Log.d((String)TAG, (String)"GO HERE 1 ");
                this.animationLayout.clearAnimation();
                this.animationLayout.animate().setDuration(300L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).setListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator arg0) {
                    }

                    public void onAnimationRepeat(Animator arg0) {
                    }

                    public void onAnimationEnd(Animator arg0) {
                        Log.d((String)TAG, (String)("AnimationLayout X: " + NotiFloatGestureView.this.animationLayout.getX()));
                        Log.d((String)TAG, (String)String.format("float layout: %sx%s - animate: %sx%s", Float.valueOf(NotiFloatGestureView.this.layoutFloat.getX()), Float.valueOf(NotiFloatGestureView.this.layoutFloat.getY()), Float.valueOf(NotiFloatGestureView.this.animationLayout.getX()), Float.valueOf(NotiFloatGestureView.this.animationLayout.getY())));
                        NotiFloatGestureView.this.layoutFloat.clearAnimation();
                        NotiFloatGestureView.this.animationLayout.clearAnimation();
                        NotiFloatGestureView.this.layoutFloat.refreshDrawableState();
                    }

                    public void onAnimationCancel(Animator arg0) {
                    }
                }).alpha(0.5f);
            } else {
                Log.d((String)TAG, (String)"GO HERE 2 ");
            }
            this.fadeOuted = true;
            this.idleHandler.postDelayed(this.mIdleRunnable2, 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fadeOut2(boolean isAnimated) {
        Log.d((String)TAG, (String)"fadeOut 2");
        try {
            if (!this.isHideFloatButton) {
                if (isAnimated) {
                    this.animationLayout.animate().setDuration(300L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).alpha(0.5f);
                } else {
                    this.animationLayout.setAlpha(0.5f);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (NotiFloatGestureView.this.listener != null) {
                NotiFloatGestureView.this.listener.onClick(e);
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
        }
    }

    static interface EventListener {
        public void onTouchUp(MotionEvent var1);

        public void onTouchDown(MotionEvent var1);

        public void onTouchMove(MotionEvent var1);

        public void onClick(MotionEvent var1);

        public void onMove(int var1, int var2);
    }
}

