/*
 * Decompiled with CFR 0.152.
 */
package com.bara.gui.dialog;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import com.bara.SakuraSDK;
import com.bara.gui.SakuraWebView;
import com.bara.model.MUrl;
import com.bara.utils.EncryptionUtils;
import com.bara.utils.Preference;
import com.quby.R;
import com.sakura.momo.comon.config.AuthenConfigs;
import com.sakura.momo.comon.config.GameConfigs;
import com.sakura.momo.comon.js.JsHandler;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.comon.utils.Utils;
import com.sakura.momo.comon.utils.WvUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.ExecutionException;

public class SakuraHaveBackButtonFragment
extends DialogFragment {
    private static final String KEY_URL = "url";
    private static final String KEY_POST_PARAMS = "post_params";
    private Activity activity = SakuraSDK.activity;
    private View layoutRoot;
    private ProgressBar progessBar;
    private SakuraWebView webView;
    private ImageButton btnClose;
    private ImageButton btnBack;
    private Bundle args = new Bundle();
    private JsHandler jsHandler;
    private MUrl mUrl;
    private Stack<MUrl> historyBackstack = new Stack();
    private static HashMap<String, MUrl> cachedUrls = new HashMap();
    private DialogInterface.OnDismissListener mOnDismissListener;
    boolean doubleBackToExitPressedOnce = false;

    public SakuraHaveBackButtonFragment() {
    }

    @SuppressLint(value={"ValidFragment"})
    public SakuraHaveBackButtonFragment(String url) {
        this(new MUrl(url));
    }

    @SuppressLint(value={"ValidFragment"})
    public SakuraHaveBackButtonFragment(MUrl url) {
        this.args.putParcelable(KEY_URL, (Parcelable)url);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(2, 0x1030011);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().getAttributes().windowAnimations = R.style.DialogAnimation;
        return dialog;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Preference.save((Context)this.activity, "shared_pref_show_dashboard", true);
        this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (event != null && keyCode == 4 && event.getAction() == 1) {
                    SakuraHaveBackButtonFragment.this.onBackPressed();
                    return true;
                }
                return false;
            }
        });
        this.layoutRoot = inflater.inflate(R.layout.fragment_backbutton_dialog, container, false);
        this.btnBack = (ImageButton)this.layoutRoot.findViewById(R.id.btn_back);
        this.btnClose = (ImageButton)this.layoutRoot.findViewById(R.id.btn_close);
        this.progessBar = (ProgressBar)this.layoutRoot.findViewById(R.id.progress_bar);
        this.webView = (SakuraWebView)this.layoutRoot.findViewById(R.id.webview);
        this.initHeaderBar();
        this.initWebView();
        return this.layoutRoot;
    }

    private void initHeaderBar() {
        this.btnBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SakuraHaveBackButtonFragment.this.onBackPressed();
            }
        });
        this.btnClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SakuraHaveBackButtonFragment.this.dismiss();
                Preference.remove((Context)SakuraHaveBackButtonFragment.this.activity, "shared_pref_show_dashboard");
            }
        });
    }

    private void updateHeaderBar() {
        try {
            if (this.isAdded()) {
                this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (SakuraHaveBackButtonFragment.this.canGoBack()) {
                            SakuraHaveBackButtonFragment.this.btnBack.setVisibility(0);
                        } else {
                            SakuraHaveBackButtonFragment.this.btnBack.setVisibility(4);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView() {
        try {
            this.webView.clearCache(true);
            this.webView.setInitialScale((int)DeviceUtils.getDensity((Context)this.getActivity()));
            this.webView.setLayerType(1, null);
            this.webView.setBackgroundColor(0);
            WebSettings webSettings = this.webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setBuiltInZoomControls(false);
            webSettings.setAllowFileAccess(true);
            webSettings.setDatabaseEnabled(true);
            webSettings.setCacheMode(-1);
            webSettings.setLoadWithOverviewMode(true);
            webSettings.setUseWideViewPort(true);
            webSettings.setLoadsImagesAutomatically(true);
            this.webView.setWebChromeClient(new WebChromeClient(){

                public void onProgressChanged(WebView view, int progress) {
                    progress = Math.max(1, progress);
                    SakuraHaveBackButtonFragment.this.progessBar.setProgress(progress);
                    if (progress >= 75) {
                        SakuraHaveBackButtonFragment.this.hideProgressBar();
                    } else {
                        SakuraHaveBackButtonFragment.this.showProgressBar();
                    }
                    SakuraHaveBackButtonFragment.this.updateHeaderBar();
                }
            });
            this.webView.setWebViewClient(new WebViewClient(){

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if (SakuraHaveBackButtonFragment.this.getActivity() != null) {
                        // empty if block
                    }
                    if (Utils.isPlfUrl(url) && !url.contains("appkey=" + GameConfigs.getInstance().getAppKey())) {
                        try {
                            SakuraHaveBackButtonFragment.this.loadUrlWithMobHeaders(url);
                            return true;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            e.printStackTrace();
                        }
                    }
                    return super.shouldOverrideUrlLoading(view, url);
                }

                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    try {
                        Uri uri = Uri.parse((String)url);
                        String strClearHistoryBackstack = uri.getQueryParameter("clearHistoryBackstack");
                        if (!TextUtils.isEmpty((CharSequence)strClearHistoryBackstack)) {
                            boolean shoulClearHistoryBackstack;
                            boolean bl = shoulClearHistoryBackstack = Integer.parseInt(Objects.requireNonNull(strClearHistoryBackstack)) != 0;
                            if (shoulClearHistoryBackstack) {
                                SakuraHaveBackButtonFragment.this.historyBackstack.clear();
                            }
                        }
                        Log.d((String)"check url", (String)("url:" + url + " ; item url:"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SakuraHaveBackButtonFragment.this.addToBackstack(url);
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    super.onReceivedError(view, errorCode, description, failingUrl);
                    WvUtil.showErrorPage((Context)SakuraHaveBackButtonFragment.this.getActivity(), SakuraHaveBackButtonFragment.this.webView, failingUrl);
                }

                @TargetApi(value=23)
                public void onReceivedError(WebView view, WebResourceRequest req, WebResourceError rerr) {
                    this.onReceivedError(view, rerr.getErrorCode(), rerr.getDescription().toString(), req.getUrl().toString());
                }

                public void onPageFinished(WebView view, String url) {
                    SakuraHaveBackButtonFragment.this.hideProgressBar();
                    SakuraHaveBackButtonFragment.this.updateHeaderBar();
                }
            });
            this.jsHandler = new JsHandler(SakuraSDK.activity, this);
            this.webView.addJavascriptInterface(this.jsHandler, "JsHandler");
            this.mUrl = (MUrl)this.args.getParcelable(KEY_URL);
            HashMap postParams = (HashMap)this.args.getSerializable(KEY_POST_PARAMS);
            if (this.mUrl != null) {
                if (postParams != null) {
                    try {
                        this.postUrlWithMobHeaders(this.mUrl, postParams);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        this.loadUrlWithMobHeaders(this.mUrl);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUrl(MUrl url) {
        if (this.isAdded()) {
            try {
                this.args.clear();
                this.webView.stopLoading();
                this.webView.loadUrl(url.getPath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadUrlWithMobHeaders(String url) throws InterruptedException, ExecutionException {
        MUrl mUrl = cachedUrls.get(url);
        if (mUrl == null) {
            mUrl = new MUrl(url);
        }
        this.loadUrlWithMobHeaders(mUrl);
    }

    public void loadUrlWithMobHeaders(MUrl url) throws InterruptedException, ExecutionException {
        if (!this.isAdded()) {
            this.args.putParcelable(KEY_URL, (Parcelable)url);
            return;
        }
        if (Utils.isPlfUrl(url)) {
            Context context = this.getActivity().getApplicationContext();
            Uri uri = url.toUri();
            if (uri.getQueryParameter("appkey") == null) {
                uri = uri.buildUpon().appendQueryParameter("appkey", GameConfigs.getInstance().getAppKey()).build();
            }
            if (url.isEcrypted() && uri.getQueryParameter("sign") == null) {
                uri = uri.buildUpon().appendQueryParameter("sign", EncryptionUtils.getSignedString(context)).build();
            }
            SakuraHaveBackButtonFragment.setCookieToURLWebview(this.webView.getContext(), url.getPath());
            HashMap<String, String> extraHeaders = new HashMap<String, String>();
            String token = AuthenConfigs.getInstance().getAccessToken();
            if (token != null && !TextUtils.isEmpty((CharSequence)token)) {
                extraHeaders.put("Authorization", "Bearer " + token);
            }
            this.webView.stopLoading();
            this.webView.loadUrl(uri.toString(), extraHeaders);
        } else {
            this.loadUrl(url);
        }
    }

    private void postUrl(MUrl url) {
        try {
            this.webView.postUrl(url.getPath(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postUrlWithMobHeaders(MUrl url, HashMap<String, String> postParams) throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        this.postUrlWithMobHeaders(url, postParams, "");
    }

    public void postUrlWithMobHeaders(MUrl url, HashMap<String, String> postParams, String a) throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        if (!this.isAdded()) {
            this.args.putParcelable(KEY_URL, (Parcelable)url);
            this.args.putSerializable(KEY_POST_PARAMS, postParams);
            return;
        }
        if (Utils.isPlfUrl(url)) {
            Uri uri = url.toUri();
            String postUrl = uri.toString();
            String postData = "hl=en";
            for (String key : postParams.keySet()) {
                postData = postData + "&" + key + "=" + URLEncoder.encode(postParams.get(key), "UTF-8");
            }
            SakuraHaveBackButtonFragment.setCookieToURLWebview(this.webView.getContext(), postUrl);
            this.webView.postUrl(postUrl, postData.getBytes());
        } else {
            this.postUrl(url);
        }
    }

    public static void setCookieToURLWebview(Context context, String url) {
        try {
            HashSet cookies = (HashSet)Preference.getStringSet(context, "game_shared_pref_cookies", new HashSet<String>());
            CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance((Context)context);
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.setAcceptCookie(true);
            for (String cookie : cookies) {
                cookieManager.setCookie(url, cookie);
            }
            cookieSyncManager.sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        if (this.canGoBack()) {
            this.goBack();
        } else {
            this.dismiss();
            Preference.remove((Context)this.activity, "shared_pref_show_dashboard");
        }
    }

    private boolean canGoBack() {
        return this.historyBackstack.size() > 1;
    }

    private void goBack() {
        try {
            this.historyBackstack.pop();
            this.loadUrlWithMobHeaders(this.historyBackstack.peek());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showProgressBar() {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SakuraHaveBackButtonFragment.this.progessBar.setVisibility(0);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideProgressBar() {
        try {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    SakuraHaveBackButtonFragment.this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            SakuraHaveBackButtonFragment.this.progessBar.setVisibility(8);
                        }
                    });
                }
            }, 500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isClearHistoryBackstack(String url) {
        try {
            Uri uri = Uri.parse((String)url);
            String strIsClearHistoryBackstack = uri.getQueryParameter("clearHistoryBackstack");
            if (!TextUtils.isEmpty((CharSequence)strIsClearHistoryBackstack)) {
                return Integer.parseInt(strIsClearHistoryBackstack) != 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isRedirectUrl(String url) {
        try {
            Uri uri = Uri.parse((String)url);
            String strIsRedirect = uri.getQueryParameter("isRedirect");
            if (!TextUtils.isEmpty((CharSequence)strIsRedirect)) {
                return Integer.parseInt(strIsRedirect) != 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void addToBackstack(String url) {
        try {
            MUrl mUrl = cachedUrls.get(url);
            if (mUrl == null) {
                mUrl = new MUrl(url);
            }
            this.addToBackstack(mUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addToBackstack(MUrl url) {
        if (url.getPath().equalsIgnoreCase("about:blank")) {
            return;
        }
        try {
            if (this.historyBackstack.isEmpty()) {
                if (url != null) {
                    this.historyBackstack.push(url);
                    if (this.isClearHistoryBackstack(url.getPath())) {
                        this.historyBackstack.pop();
                    }
                }
            } else {
                Uri uri = url.toUri();
                Uri lastUri = this.historyBackstack.peek().toUri();
                if (lastUri.getPath() == null) {
                    this.historyBackstack.pop();
                    this.addToBackstack(url);
                } else if (!lastUri.getPath().equalsIgnoreCase(uri.getPath()) && url != null) {
                    if (this.isRedirectUrl(url.getPath())) {
                        this.historyBackstack.pop();
                    }
                    this.historyBackstack.push(url);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

