/*
 * Decompiled with CFR 0.152.
 */
package com.bara.gui.dialog;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.bara.SakuraHelper;
import com.bara.SakuraSDK;
import com.bara.gui.SakuraWebViewDetail;
import com.bara.gui.dialog.SakuraConfirmDialog;
import com.bara.gui.dialog.SakuraDialogWebviewFragment;
import com.bara.model.MUrl;
import com.bara.utils.Preference;
import com.bara.utils.Res;
import com.quby.R;
import com.sakura.momo.comon.config.AuthenConfigs;
import com.sakura.momo.comon.config.GameConfigs;
import com.sakura.momo.comon.js.JsHandler;
import com.sakura.momo.comon.object.SdkConfigObj;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.comon.utils.LogUtils;
import com.sakura.momo.comon.utils.Utils;
import com.sakura.momo.comon.utils.WvUtil;
import java.util.HashMap;
import java.util.HashSet;

public class SakuraDialogStartWebFragment
extends DialogFragment {
    private static final String TAG = SakuraDialogWebviewFragment.class.getName();
    private Activity activity;
    private SakuraWebViewDetail webView;
    private ProgressBar mProgressView;
    private ImageButton dialogCloseButton;
    public static final String DIALOG_WEBVIEW_TYPE_WEBVIEW_DETAIL = "webview_detail";
    public static final String DIALOG_WEBVIEW_TYPE_ADS = "webview_ads";
    private String type;
    private int orientation;
    private String webview_detail_url;
    private String webview_detail_title;
    private JsHandler jsHandler;
    private boolean saveReaded;
    private View dialogView;
    private int selectButton = 0;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private SakuraDialogWebviewFragment.EventListener eventListeners;
    private static HashMap<String, MUrl> cachedUrls;
    boolean isCheck;
    private BroadcastReceiver mMessageReceiver;
    private final int DefaultKeyboardDP = 100;
    private final int EstimatedKeyboardDP;
    private int heightDiff;
    private boolean wasOpened;

    public SakuraDialogStartWebFragment() {
        cachedUrls = new HashMap();
        this.isCheck = false;
        this.mMessageReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    if (action == null) {
                        return;
                    }
                    switch (action) {
                        case "UploadBitmap": {
                            try {
                                String result = intent.getExtras().getString("result");
                                Log.d((String)TAG, (String)("onReceive: " + result));
                                if (SakuraDialogStartWebFragment.this.webView != null) {
                                    String jsFunction = String.format("loadImage('%s');", result);
                                    Log.d((String)TAG, (String)("onReceive: " + jsFunction));
                                    SakuraDialogStartWebFragment.this.invokeJavascript(jsFunction);
                                    break;
                                }
                                Log.d((String)TAG, (String)"onReceive: webview = null");
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    String message = intent.getStringExtra("message");
                    Log.d((String)"receiver", (String)("Got message: " + message));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.DefaultKeyboardDP = 100;
        this.EstimatedKeyboardDP = 100 + (Build.VERSION.SDK_INT >= 21 ? 48 : 0);
        this.heightDiff = 0;
    }

    @SuppressLint(value={"ValidFragment"})
    public SakuraDialogStartWebFragment(Activity activity, boolean isShowAds, boolean saveRead) {
        cachedUrls = new HashMap();
        this.isCheck = false;
        this.mMessageReceiver = new /* invalid duplicate definition of identical inner class */;
        this.DefaultKeyboardDP = 100;
        this.EstimatedKeyboardDP = 100 + (Build.VERSION.SDK_INT >= 21 ? 48 : 0);
        this.heightDiff = 0;
        this.activity = activity;
        this.saveReaded = saveRead;
        this.type = DIALOG_WEBVIEW_TYPE_ADS;
        this.setStyle(1, R.style.Theme_AppCompat_Translucent_FullScreen);
    }

    @SuppressLint(value={"ValidFragment"})
    public SakuraDialogStartWebFragment(Activity activity, String title, String url) {
        cachedUrls = new HashMap();
        this.isCheck = false;
        this.mMessageReceiver = new /* invalid duplicate definition of identical inner class */;
        this.DefaultKeyboardDP = 100;
        this.EstimatedKeyboardDP = 100 + (Build.VERSION.SDK_INT >= 21 ? 48 : 0);
        this.heightDiff = 0;
        Log.d((String)TAG, (String)("Reload 1 : " + url));
        this.activity = activity;
        this.webview_detail_url = url;
        this.webview_detail_title = title;
        this.type = DIALOG_WEBVIEW_TYPE_WEBVIEW_DETAIL;
        this.setType(this.type);
        this.setStyle(1, R.style.Theme_AppCompat_Translucent_FullScreen);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.orientation = DeviceUtils.getScreenOrientation((Context)this.getActivity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPause() {
        LocalBroadcastManager.getInstance((Context)this.activity.getApplicationContext()).unregisterReceiver(this.mMessageReceiver);
        super.onPause();
    }

    public void onResume() {
        LocalBroadcastManager.getInstance((Context)this.activity.getApplicationContext()).registerReceiver(this.mMessageReceiver, new IntentFilter("UploadBitmap"));
        super.onResume();
        this.handlerBackButton();
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            this.dialogCloseButton = (ImageButton)this.dialogView.findViewById(R.id.btn_dialog_close);
            this.mProgressView = (ProgressBar)this.dialogView.findViewById(R.id.loading_progress);
            this.webView = (SakuraWebViewDetail)this.dialogView.findViewById(R.id.dialog_webview);
            WindowManager.LayoutParams params = this.getDialog().getWindow().getAttributes();
            params.height = -1;
            params.width = -1;
            this.getDialog().getWindow().setAttributes(params);
            this.getDialog().getWindow().setSoftInputMode(48);
            this.initWebview();
            Log.d((String)TAG, (String)("onCreateDialog: activity name: " + this.activity.getClass().getName()));
            this.dialogCloseButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SakuraDialogStartWebFragment.this.closeDialog();
                }
            });
            if (this.type.equals(DIALOG_WEBVIEW_TYPE_ADS)) {
                this.showMobAds();
            } else if (this.type.equals(DIALOG_WEBVIEW_TYPE_WEBVIEW_DETAIL)) {
                this.dialogCloseButton.setVisibility(0);
                this.showWebViewDetail(this.webview_detail_title, this.webview_detail_url);
            }
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity(), R.style.Theme_AppCompat_Translucent);
            builder.setView(this.dialogView);
            SakuraSDK.getInstance().unRegisterSensor();
            this.setKeyboardListener();
            SdkConfigObj game = GameConfigs.getInstance().getSdkConfig();
            if (game != null && game.getEx() != null && game.getEx().isShowLogo()) {
                SakuraHelper.hideNotiFloatButton();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.dialogView = inflater.inflate(R.layout.dialog_after_login, null);
        return this.dialogView;
    }

    public void onDetach() {
        super.onDetach();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    private void closeDialog() {
        try {
            SdkConfigObj game;
            if (Preference.getBoolean((Context)this.activity, "shared_pref_hide_float_button", true) && this.type.equals(DIALOG_WEBVIEW_TYPE_ADS) && (game = GameConfigs.getInstance().getSdkConfig()) != null && game.getEx() != null && game.getEx().isShowLogo()) {
                SakuraHelper.showNotiFloatButton(game.getEx());
            }
            if (this.isCheck) {
                this.webView.getSettings().setJavaScriptEnabled(true);
                this.webView.evaluateJavascript("checkFormData()", (ValueCallback)new ValueCallback<String>(){

                    public void onReceiveValue(String s) {
                        Log.d((String)TAG, (String)("onReceiveValue: " + s));
                        if (s != null) {
                            if (s.contains("1")) {
                                SakuraConfirmDialog dialog = new SakuraConfirmDialog(SakuraDialogStartWebFragment.this.activity, Res.string((Context)SakuraDialogStartWebFragment.this.activity, R.string.do_you_want_close), SakuraDialogStartWebFragment.this.activity.getString(R.string.ok), Res.string((Context)SakuraDialogStartWebFragment.this.activity, R.string.cancel), new SakuraConfirmDialog.EventListener(){

                                    @Override
                                    public void onConfirmClick(View v) {
                                        SakuraDialogStartWebFragment.this.dismiss();
                                    }

                                    @Override
                                    public void onCancelClick(View v) {
                                    }
                                });
                                dialog.show(SakuraDialogStartWebFragment.this.activity.getFragmentManager(), "tag_fragment_confirm");
                            } else {
                                SakuraDialogStartWebFragment.this.dismiss();
                            }
                        }
                    }
                });
            } else {
                this.dismiss();
            }
            if (Preference.getBoolean((Context)this.activity, "save_ads", false)) {
                Preference.save((Context)this.activity, "save_ads", false);
                SakuraSDK.getInstance().showPopup();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "JavascriptInterface", "ClickableViewAccessibility"})
    private void initWebview() {
        try {
            this.webView.getSettings().setJavaScriptEnabled(true);
            this.webView.setBackgroundColor(0);
            this.webView.setInitialScale((int)DeviceUtils.getDensity((Context)this.getActivity()));
            WebSettings webSettings = this.webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setLightTouchEnabled(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setBuiltInZoomControls(false);
            webSettings.setAllowFileAccess(true);
            webSettings.setDatabaseEnabled(true);
            webSettings.setCacheMode(-1);
            webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
            this.webView.setScrollBarStyle(0);
            webSettings.setDomStorageEnabled(true);
            webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
            webSettings.setUseWideViewPort(true);
            webSettings.setSaveFormData(true);
            webSettings.setLoadWithOverviewMode(true);
            webSettings.setUseWideViewPort(true);
            webSettings.setLoadsImagesAutomatically(true);
            this.jsHandler = new JsHandler(this.activity, this);
            this.webView.addJavascriptInterface(this.jsHandler, "JsHandler");
            this.jsHandler.mobAppSDKexecute("mobGetError", "");
            this.webView.setWebChromeClient(new WebChromeClient(){

                public void onProgressChanged(WebView view, int progress) {
                    if (SakuraDialogStartWebFragment.this.eventListeners != null) {
                        SakuraDialogStartWebFragment.this.eventListeners.onProgressChanged(view, progress);
                    }
                }
            });
            this.webView.setOnScrollChangedListener(new SakuraWebViewDetail.OnPropertyChangedListener(){

                @Override
                public void onScroll(int l, int t, int oldl, int oldt) {
                    if (SakuraDialogStartWebFragment.this.eventListeners != null) {
                        SakuraDialogStartWebFragment.this.eventListeners.onScrollChanged(SakuraDialogStartWebFragment.this.webView, l, t, oldl, oldt);
                    }
                }

                @Override
                public void onSizeChanged(int w, int h, int ow, int oh) {
                    if (SakuraDialogStartWebFragment.this.eventListeners != null) {
                        SakuraDialogStartWebFragment.this.eventListeners.onSizeChanged(SakuraDialogStartWebFragment.this.webView, w, h, ow, oh);
                    }
                }
            });
            this.webView.setWebViewClient(new WebViewClient(){
                long startLoadPage = 0L;
                long endLoadPage = 0L;

                @TargetApi(value=21)
                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                    SakuraDialogStartWebFragment.this.showProgress(true);
                    String url = request.getUrl().toString();
                    if (Utils.isPlfUrl(url) && !url.contains("appkey=" + GameConfigs.getInstance().getAppKey())) {
                        Log.i((String)TAG, (String)"loadUrlWithMobHeaders from shouldOverrideUrlLoading() ");
                        SakuraDialogStartWebFragment.this.loadUrlWithMobHeaders(url);
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, request);
                }

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    SakuraDialogStartWebFragment.this.showProgress(true);
                    if (Utils.isPlfUrl(url) && !url.contains("appkey=" + GameConfigs.getInstance().getAppKey())) {
                        Log.i((String)TAG, (String)"loadUrlWithMobHeaders from shouldOverrideUrlLoading() ");
                        SakuraDialogStartWebFragment.this.loadUrlWithMobHeaders(url);
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, url);
                }

                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    try {
                        SakuraDialogStartWebFragment.this.showProgress(true);
                        LogUtils.d(TAG, "onPageStarted: url=" + url);
                        super.onPageStarted(view, url, favicon);
                        if (SakuraDialogStartWebFragment.this.eventListeners != null) {
                            SakuraDialogStartWebFragment.this.eventListeners.onPageStarted(view, url, favicon);
                        }
                        this.startLoadPage = System.currentTimeMillis();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onPageFinished(WebView view, String url) {
                    SakuraDialogStartWebFragment.this.showProgress(false);
                    LogUtils.d(TAG, "onPageFinished: ");
                    try {
                        super.onPageFinished(view, url);
                        if (SakuraDialogStartWebFragment.this.eventListeners != null) {
                            SakuraDialogStartWebFragment.this.eventListeners.onPageFinished(view, url);
                        }
                        this.endLoadPage = System.currentTimeMillis();
                        long l = this.endLoadPage - this.startLoadPage;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @RequiresApi(api=21)
                public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                    Log.d((String)TAG, (String)"onReceivedError: ");
                    try {
                        SakuraDialogStartWebFragment.this.showProgress(false);
                        SakuraDialogStartWebFragment.this.selectButton = 4;
                        if (!SakuraDialogStartWebFragment.this.isConnected()) {
                            SakuraDialogStartWebFragment.this.dialogView.setVisibility(8);
                            SakuraDialogStartWebFragment.this.showDialog();
                        } else {
                            SakuraDialogStartWebFragment.this.selectButton = 5;
                            SakuraDialogStartWebFragment.this.dialogView.setVisibility(8);
                        }
                        SakuraDialogStartWebFragment.this.showProgress(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    Log.d((String)TAG, (String)"onReceivedError: ");
                    SakuraDialogStartWebFragment.this.selectButton = 4;
                    SakuraDialogStartWebFragment.this.showProgress(false);
                    if (!SakuraDialogStartWebFragment.this.isConnected()) {
                        SakuraDialogStartWebFragment.this.dialogView.setVisibility(8);
                        SakuraDialogStartWebFragment.this.showDialog();
                    } else {
                        WvUtil.showErrorPage((Context)SakuraDialogStartWebFragment.this.getActivity(), view, failingUrl);
                    }
                    SakuraDialogStartWebFragment.this.showProgress(false);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handlerBackButton() {
        try {
            this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

                @SuppressLint(value={"SetJavaScriptEnabled"})
                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (event != null && keyCode == 4 && event.getAction() == 1) {
                        SdkConfigObj.Pop mobPopup = GameConfigs.getInstance().getPopup();
                        String url = mobPopup.getUrl();
                        if (url != null && url.contains("btnc=1")) {
                            Log.d((String)TAG, (String)("handlerBackButton: url " + url));
                            SakuraDialogStartWebFragment.this.closeDialog();
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show(FragmentManager manager, String tag) {
        try {
            super.show(manager, tag);
            Log.d((String)TAG, (String)("Show " + TAG));
            Intent intent = new Intent("com.quby.broadcast");
            intent.putExtra("category", "isShowPopupLink");
            LocalBroadcastManager.getInstance((Context)this.getActivity()).sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        super.dismiss();
        try {
            Log.d((String)TAG, (String)("Show " + TAG));
            Intent intent = new Intent("com.quby.broadcast");
            intent.putExtra("category", "hideShowPopupLink");
            LocalBroadcastManager.getInstance((Context)this.getActivity()).sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @TargetApi(value=13)
    private void showProgress(final boolean show) {
        try {
            int shortAnimTime = this.activity.getResources().getInteger(0x10E0000);
            this.mProgressView.setVisibility(show ? 0 : 8);
            this.mProgressView.animate().setDuration((long)shortAnimTime).alpha(show ? 1.0f : 0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    SakuraDialogStartWebFragment.this.mProgressView.setVisibility(show ? 0 : 8);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showWebViewDetail(String title, String url) {
        Log.d((String)TAG, (String)("onCreateDialog: url " + url));
        try {
            this.isCheck = url.contains("isCheck=1");
            Log.i((String)TAG, (String)"loadUrlWithMobHeaders from showWebViewDetail() ");
            this.loadUrlWithMobHeaders(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showMobAds() {
        try {
            SdkConfigObj.Pop mobPopup = GameConfigs.getInstance().getPopup();
            String url = mobPopup.getUrl();
            SdkConfigObj sdk = GameConfigs.getInstance().getSdkConfig();
            if (sdk != null && sdk.getMaintenance() != null && !TextUtils.isEmpty((CharSequence)sdk.getMaintenance().getUrl())) {
                url = sdk.getMaintenance().getUrl();
            }
            if (url.contains("btnc=0") || mobPopup.getCanClose() == 0) {
                this.dialogCloseButton.setVisibility(8);
            } else {
                this.dialogCloseButton.setVisibility(0);
            }
            this.loadUrlWithMobHeaders(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void postUrl(MUrl url) {
        this.postUrl(url.getPath());
    }

    private void postUrl(String url) {
        try {
            this.webView.postUrl(url, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadUrlWithMobHeaders(String url) {
        try {
            Log.d((String)TAG, (String)("loadUrlWithMobHeaders: " + url));
            if (Utils.isPlfUrl(url)) {
                Context context = this.activity.getApplicationContext();
                Uri uri = Uri.parse((String)url);
                SakuraDialogStartWebFragment.setCookieToURLWebview(context, url);
                HashMap<String, String> extraHeaders = new HashMap<String, String>();
                String token = AuthenConfigs.getInstance().getAccessToken();
                if (token != null && !TextUtils.isEmpty((CharSequence)token)) {
                    extraHeaders.put("Authorization", "Bearer " + token);
                }
                this.webView.stopLoading();
                this.webView.loadUrl(uri.toString(), extraHeaders);
            } else {
                this.loadUrl(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setCookieToURLWebview(Context context, String url) {
        try {
            HashSet cookies = (HashSet)Preference.getStringSet(context, "game_shared_pref_cookies", new HashSet<String>());
            CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance((Context)context);
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.setAcceptCookie(true);
            for (String cookie : cookies) {
                Log.d((String)TAG, (String)("loadUrlWithMobHeaders form cookie : " + cookie));
                cookieManager.setCookie(url, cookie);
            }
            cookieSyncManager.sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUrl(String url) {
        try {
            if (this.isAdded()) {
                this.webView.stopLoading();
                this.webView.loadUrl(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void invokeJavascript(String script) {
        this.webView.loadUrl("javascript:" + script);
    }

    public boolean isConnected() {
        try {
            ConnectivityManager cm = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            LogUtils.d(TAG, "isConn : " + isConnected);
            return isConnected;
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            LogUtils.e(TAG, "error : " + ex.getMessage());
            return false;
        }
    }

    public void showDialog() {
        try {
            AlertDialog.Builder dialog = new AlertDialog.Builder((Context)this.activity);
            dialog.setTitle((CharSequence)"M\u1ea5t k\u1ebft n\u1ed1i");
            dialog.setPositiveButton((CharSequence)"Th\u1eed l\u1ea1i", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (SakuraDialogStartWebFragment.this.isConnected()) {
                        switch (SakuraDialogStartWebFragment.this.selectButton) {
                            case 1: {
                                SakuraDialogStartWebFragment.this.webView.goBack();
                                break;
                            }
                            case 2: {
                                SakuraDialogStartWebFragment.this.webView.goForward();
                                break;
                            }
                            case 3: {
                                SakuraDialogStartWebFragment.this.webView.reload();
                                break;
                            }
                            case 4: {
                                SakuraDialogStartWebFragment.this.webView.reload();
                                SakuraDialogStartWebFragment.this.dialogView.setVisibility(0);
                                break;
                            }
                            case 5: {
                                SakuraDialogStartWebFragment.this.webView.reload();
                                SakuraDialogStartWebFragment.this.dialogView.setVisibility(0);
                                break;
                            }
                        }
                        dialog.dismiss();
                    } else {
                        SakuraDialogStartWebFragment.this.showDialog();
                    }
                }
            });
            dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    if (SakuraDialogStartWebFragment.this.selectButton == 4) {
                        SakuraDialogStartWebFragment.this.dismiss();
                    }
                }
            });
            dialog.setMessage((CharSequence)this.getString(R.string.error_network));
            dialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setKeyboardListener() {
        try {
            final View activityRootView = ((ViewGroup)this.activity.findViewById(0x1020002)).getChildAt(0);
            activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){
                private final Rect r = new Rect();

                public void onGlobalLayout() {
                    boolean isShown;
                    int estimatedKeyboardHeight = (int)TypedValue.applyDimension((int)1, (float)SakuraDialogStartWebFragment.this.EstimatedKeyboardDP, (DisplayMetrics)activityRootView.getResources().getDisplayMetrics());
                    activityRootView.getWindowVisibleDisplayFrame(this.r);
                    SakuraDialogStartWebFragment.this.heightDiff = activityRootView.getRootView().getHeight() - (this.r.bottom - this.r.top);
                    Resources res = SakuraDialogStartWebFragment.this.activity.getResources();
                    int heightDiffPixel = (int)TypedValue.applyDimension((int)1, (float)SakuraDialogStartWebFragment.this.heightDiff, (DisplayMetrics)res.getDisplayMetrics());
                    boolean bl = isShown = SakuraDialogStartWebFragment.this.heightDiff >= estimatedKeyboardHeight;
                    if (isShown == SakuraDialogStartWebFragment.this.wasOpened) {
                        Log.d((String)"Keyboard state", (String)"Ignoring global layout change...");
                        return;
                    }
                    SakuraDialogStartWebFragment.this.wasOpened = isShown;
                    if (isShown) {
                        if (SakuraDialogStartWebFragment.this.webView != null) {
                            SakuraDialogStartWebFragment.this.webView.getSettings().setJavaScriptEnabled(true);
                            String script = "getHeightKeyBoard(" + SakuraDialogStartWebFragment.this.orientation + ")";
                            SakuraDialogStartWebFragment.this.webView.evaluateJavascript(script, (ValueCallback)new ValueCallback<String>(){

                                public void onReceiveValue(String value) {
                                }
                            });
                        }
                    } else {
                        SakuraDialogStartWebFragment.this.webView.getSettings().setJavaScriptEnabled(true);
                        Log.d((String)TAG, (String)"closeKeyBoard()");
                        String script = "closeKeyBoard()";
                        SakuraDialogStartWebFragment.this.webView.evaluateJavascript(script, (ValueCallback)new ValueCallback<String>(){

                            public void onReceiveValue(String value) {
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface EventListener {
        public void onProgressChanged(WebView var1, int var2);

        public void onPageStarted(WebView var1, String var2, Bitmap var3);

        public void onPageFinished(WebView var1, String var2);

        public void onScrollChanged(WebView var1, int var2, int var3, int var4, int var5);

        public void onSizeChanged(WebView var1, int var2, int var3, int var4, int var5);
    }
}

