/*
 * Decompiled with CFR 0.152.
 */
package com.bara.gui;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.provider.MediaStore;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.bara.utils.Res;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.quby.R;
import com.sakura.momo.comon.utils.ToastUtils;

public class SakuraImageGaleryActivity
extends AppCompatActivity {
    private GridView grdImages;
    private ImageButton btnSelect;
    private ImageButton btnCancel;
    private ImageAdapter imageAdapter;
    private TextView tvNumberSelected;
    private TextView tvHeader;
    private String[] arrPath;
    private boolean[] thumbnailsselection;
    private int[] ids;
    private int count;
    private int countSelected = 0;
    private int limitSelect = 3;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_mob_game_image_galery);
        Bundle bundle = this.getIntent().getBundleExtra("bundle");
        if (bundle != null) {
            this.limitSelect = bundle.getInt("limit");
        }
        this.grdImages = (GridView)this.findViewById(R.id.grdImages);
        this.btnSelect = (ImageButton)this.findViewById(R.id.btnSelect);
        this.btnCancel = (ImageButton)this.findViewById(R.id.btn_cancel_galery);
        this.tvNumberSelected = (TextView)this.findViewById(R.id.tvNumberSelected);
        this.tvHeader = (TextView)this.findViewById(R.id.tvHeader);
        try {
            this.tvHeader.setText((CharSequence)Res.string((Context)this, R.string.images_selected));
            String orderBy = "datetaken DESC";
            String[] projection = new String[]{"_data", "_id", "datetaken"};
            Cursor imagecursor = this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, null, null, "datetaken DESC");
            this.count = imagecursor.getCount();
            this.arrPath = new String[this.count];
            this.ids = new int[this.count];
            this.thumbnailsselection = new boolean[this.count];
            int dataColumn = imagecursor.getColumnIndexOrThrow("_data");
            int idColumn = imagecursor.getColumnIndexOrThrow("_id");
            for (int i = 0; i < this.count; ++i) {
                imagecursor.moveToPosition(i);
                this.arrPath[i] = imagecursor.getString(dataColumn);
                this.ids[i] = imagecursor.getInt(idColumn);
            }
            this.tvNumberSelected.setText((CharSequence)("" + (this.countSelected + 3 - this.limitSelect)));
            this.imageAdapter = new ImageAdapter((Context)this, new OnSelectImageGalleryListener(){

                @Override
                public void onSelectImageGalleryListener(CheckBox cb, int id2) {
                    try {
                        SakuraImageGaleryActivity.this.countSelected++;
                        if (SakuraImageGaleryActivity.this.countSelected > SakuraImageGaleryActivity.this.limitSelect) {
                            ToastUtils.showShortToast(cb.getContext(), SakuraImageGaleryActivity.this.getString(R.string.alert_image_validate));
                            SakuraImageGaleryActivity.this.countSelected--;
                            cb.setChecked(false);
                            ((SakuraImageGaleryActivity)SakuraImageGaleryActivity.this).thumbnailsselection[id2] = false;
                        } else {
                            SakuraImageGaleryActivity.this.tvNumberSelected.setText((CharSequence)("" + (SakuraImageGaleryActivity.this.countSelected + 3 - SakuraImageGaleryActivity.this.limitSelect)));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onUnselectImageGalleryListener(CheckBox cb, int id2) {
                    try {
                        SakuraImageGaleryActivity.this.countSelected--;
                        SakuraImageGaleryActivity.this.tvNumberSelected.setText((CharSequence)("" + (SakuraImageGaleryActivity.this.countSelected + 3 - SakuraImageGaleryActivity.this.limitSelect)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.grdImages.setAdapter((ListAdapter)this.imageAdapter);
            imagecursor.close();
            this.btnSelect.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        int len = SakuraImageGaleryActivity.this.thumbnailsselection.length;
                        int cnt = 0;
                        String selectImages = "";
                        for (int i = 0; i < len; ++i) {
                            if (!SakuraImageGaleryActivity.this.thumbnailsselection[i]) continue;
                            ++cnt;
                            selectImages = selectImages + SakuraImageGaleryActivity.this.arrPath[i] + "|";
                        }
                        if (cnt == 0) {
                            Toast.makeText((Context)SakuraImageGaleryActivity.this, (CharSequence)"Please select at least one image", (int)1).show();
                        } else {
                            Log.d((String)"SelectedImages", (String)selectImages);
                            Intent i = new Intent();
                            i.putExtra("data", selectImages);
                            SakuraImageGaleryActivity.this.setResult(-1, i);
                            SakuraImageGaleryActivity.this.finish();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.btnCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SakuraImageGaleryActivity.this.finish();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        this.setResult(0);
        super.onBackPressed();
    }

    class ViewHolder {
        ImageView imgThumb;
        CheckBox chkImage;
        int id;

        ViewHolder() {
        }
    }

    static interface OnSelectImageGalleryListener {
        public void onSelectImageGalleryListener(CheckBox var1, int var2);

        public void onUnselectImageGalleryListener(CheckBox var1, int var2);
    }

    public class ImageAdapter
    extends BaseAdapter {
        private Context context;
        private LayoutInflater mInflater;
        private OnSelectImageGalleryListener listener;

        public ImageAdapter(Context context, OnSelectImageGalleryListener listener) {
            this.mInflater = (LayoutInflater)SakuraImageGaleryActivity.this.getSystemService("layout_inflater");
            this.context = context;
            this.listener = listener;
        }

        public int getCount() {
            return SakuraImageGaleryActivity.this.count;
        }

        public ViewHolder getItem(int position) {
            return this.getItem(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            try {
                ViewHolder holder;
                GridView grid = (GridView)parent;
                int itemWidth = grid.getRequestedColumnWidth();
                if (this.context.getResources().getConfiguration().orientation == 2) {
                    itemWidth *= 2;
                }
                if (convertView == null) {
                    holder = new ViewHolder();
                    convertView = this.mInflater.inflate(R.layout.image_galery_item, null);
                    holder.imgThumb = (ImageView)convertView.findViewById(R.id.imgThumb);
                    holder.chkImage = (CheckBox)convertView.findViewById(R.id.chkImage);
                    holder.imgThumb.getLayoutParams().width = itemWidth;
                    holder.imgThumb.getLayoutParams().height = itemWidth;
                    convertView.setTag((Object)holder);
                } else {
                    holder = (ViewHolder)convertView.getTag();
                }
                holder.chkImage.setId(position);
                holder.imgThumb.setId(position);
                holder.chkImage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        CheckBox cb = (CheckBox)v;
                        int id2 = cb.getId();
                        if (SakuraImageGaleryActivity.this.thumbnailsselection[id2]) {
                            cb.setChecked(false);
                            ((SakuraImageGaleryActivity)SakuraImageGaleryActivity.this).thumbnailsselection[id2] = false;
                            if (ImageAdapter.this.listener != null) {
                                ImageAdapter.this.listener.onUnselectImageGalleryListener(cb, id2);
                            }
                        } else {
                            cb.setChecked(true);
                            ((SakuraImageGaleryActivity)SakuraImageGaleryActivity.this).thumbnailsselection[id2] = true;
                            if (ImageAdapter.this.listener != null) {
                                ImageAdapter.this.listener.onSelectImageGalleryListener(cb, id2);
                            }
                        }
                    }
                });
                holder.imgThumb.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int id2 = holder.chkImage.getId();
                        if (SakuraImageGaleryActivity.this.thumbnailsselection[id2]) {
                            holder.chkImage.setChecked(false);
                            ((SakuraImageGaleryActivity)SakuraImageGaleryActivity.this).thumbnailsselection[id2] = false;
                            if (ImageAdapter.this.listener != null) {
                                ImageAdapter.this.listener.onUnselectImageGalleryListener(holder.chkImage, id2);
                            }
                        } else {
                            holder.chkImage.setChecked(true);
                            ((SakuraImageGaleryActivity)SakuraImageGaleryActivity.this).thumbnailsselection[id2] = true;
                            if (ImageAdapter.this.listener != null) {
                                ImageAdapter.this.listener.onSelectImageGalleryListener(holder.chkImage, id2);
                            }
                        }
                    }
                });
                RequestOptions cropOptions = (RequestOptions)new RequestOptions().centerCrop();
                Glide.with((Context)this.context).load(SakuraImageGaleryActivity.this.arrPath[position]).apply((BaseRequestOptions)cropOptions).into(holder.imgThumb);
                holder.chkImage.setChecked(SakuraImageGaleryActivity.this.thumbnailsselection[position]);
                holder.id = position;
                return convertView;
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.mInflater.inflate(R.layout.image_galery_item, null);
            }
        }
    }
}

