/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gcm;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gcm.GCMBroadcastReceiver;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GCMRegistrar {
    public static final long DEFAULT_ON_SERVER_LIFESPAN_MS = 604800000L;
    private static final String TAG = "GCMRegistrar";
    private static final String BACKOFF_MS = "backoff_ms";
    private static final String GSF_PACKAGE = "com.google.android.gsf";
    private static final String PREFERENCES = "com.google.android.gcm";
    private static final int DEFAULT_BACKOFF_MS = 3000;
    private static final String PROPERTY_REG_ID = "regId";
    private static final String PROPERTY_APP_VERSION = "appVersion";
    private static final String PROPERTY_ON_SERVER = "onServer";
    private static final String PROPERTY_ON_SERVER_EXPIRATION_TIME = "onServerExpirationTime";
    private static final String PROPERTY_ON_SERVER_LIFESPAN = "onServerLifeSpan";
    private static GCMBroadcastReceiver sRetryReceiver;
    private static Context sRetryReceiverContext;
    private static String sRetryReceiverClassName;
    private static PendingIntent sAppPendingIntent;

    public static void checkDevice(Context context) {
        int version = Build.VERSION.SDK_INT;
        if (version < 8) {
            throw new UnsupportedOperationException("Device must be at least API Level 8 (instead of " + version + ")");
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.getPackageInfo(GSF_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new UnsupportedOperationException("Device does not have package com.google.android.gsf");
        }
    }

    public static void checkManifest(Context context) {
        PackageInfo receiversInfo;
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getPackageName();
        String permissionName = packageName + ".permission.C2D_MESSAGE";
        try {
            packageManager.getPermissionInfo(permissionName, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalStateException("Application does not define permission " + permissionName);
        }
        try {
            receiversInfo = packageManager.getPackageInfo(packageName, 2);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalStateException("Could not get receivers for package " + packageName);
        }
        ActivityInfo[] receivers = receiversInfo.receivers;
        if (receivers == null || receivers.length == 0) {
            throw new IllegalStateException("No receiver for package " + packageName);
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("number of receivers for " + packageName + ": " + receivers.length));
        }
        HashSet<String> allowedReceivers = new HashSet<String>();
        for (ActivityInfo receiver : receivers) {
            if (!"com.google.android.c2dm.permission.SEND".equals(receiver.permission)) continue;
            allowedReceivers.add(receiver.name);
        }
        if (allowedReceivers.isEmpty()) {
            throw new IllegalStateException("No receiver allowed to receive com.google.android.c2dm.permission.SEND");
        }
        GCMRegistrar.checkReceiver(context, allowedReceivers, "com.google.android.c2dm.intent.REGISTRATION");
        GCMRegistrar.checkReceiver(context, allowedReceivers, "com.google.android.c2dm.intent.RECEIVE");
    }

    private static void checkReceiver(Context context, Set<String> allowedReceivers, String action) {
        PackageManager pm = context.getPackageManager();
        String packageName = context.getPackageName();
        Intent intent = new Intent(action);
        intent.setPackage(packageName);
        List receivers = pm.queryBroadcastReceivers(intent, 32);
        if (receivers.isEmpty()) {
            throw new IllegalStateException("No receivers for action " + action);
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Found " + receivers.size() + " receivers for action " + action));
        }
        for (ResolveInfo receiver : receivers) {
            String name = receiver.activityInfo.name;
            if (allowedReceivers.contains(name)) continue;
            throw new IllegalStateException("Receiver " + name + " is not set with permission " + "com.google.android.c2dm.permission.SEND");
        }
    }

    public static void register(Context context, String ... senderIds) {
        GCMRegistrar.resetBackoff(context);
        GCMRegistrar.internalRegister(context, senderIds);
    }

    static void internalRegister(Context context, String ... senderIds) {
        String flatSenderIds = GCMRegistrar.getFlatSenderIds(senderIds);
        Log.v((String)TAG, (String)("Registering app " + context.getPackageName() + " of senders " + flatSenderIds));
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(GSF_PACKAGE);
        GCMRegistrar.setPackageNameExtra(context, intent);
        intent.putExtra("sender", flatSenderIds);
        context.startService(intent);
    }

    public static void unregister(Context context) {
        GCMRegistrar.resetBackoff(context);
        GCMRegistrar.internalUnregister(context);
    }

    static void internalUnregister(Context context) {
        Log.v((String)TAG, (String)("Unregistering app " + context.getPackageName()));
        Intent intent = new Intent("com.google.android.c2dm.intent.UNREGISTER");
        intent.setPackage(GSF_PACKAGE);
        GCMRegistrar.setPackageNameExtra(context, intent);
        context.startService(intent);
    }

    static String getFlatSenderIds(String ... senderIds) {
        if (senderIds == null || senderIds.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder builder = new StringBuilder(senderIds[0]);
        for (int i = 1; i < senderIds.length; ++i) {
            builder.append(',').append(senderIds[i]);
        }
        return builder.toString();
    }

    public static synchronized void onDestroy(Context context) {
        if (sRetryReceiver != null) {
            Log.v((String)TAG, (String)"Unregistering retry receiver");
            sRetryReceiverContext.unregisterReceiver((BroadcastReceiver)sRetryReceiver);
            sRetryReceiver = null;
            sRetryReceiverContext = null;
        }
    }

    static synchronized void cancelAppPendingIntent() {
        if (sAppPendingIntent != null) {
            sAppPendingIntent.cancel();
            sAppPendingIntent = null;
        }
    }

    private static synchronized void setPackageNameExtra(Context context, Intent intent) {
        if (sAppPendingIntent == null) {
            Log.v((String)TAG, (String)"Creating pending intent to get package name");
            sAppPendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(), (int)0);
        }
        intent.putExtra("app", (Parcelable)sAppPendingIntent);
    }

    static synchronized void setRetryBroadcastReceiver(Context context) {
        if (sRetryReceiver == null) {
            if (sRetryReceiverClassName == null) {
                Log.e((String)TAG, (String)"internal error: retry receiver class not set yet");
                sRetryReceiver = new GCMBroadcastReceiver();
            } else {
                try {
                    Class<?> clazz = Class.forName(sRetryReceiverClassName);
                    sRetryReceiver = (GCMBroadcastReceiver)((Object)clazz.newInstance());
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Could not create instance of " + sRetryReceiverClassName + ". Using " + GCMBroadcastReceiver.class.getName() + " directly."));
                    sRetryReceiver = new GCMBroadcastReceiver();
                }
            }
            String category = context.getPackageName();
            IntentFilter filter = new IntentFilter("com.google.android.gcm.intent.RETRY");
            filter.addCategory(category);
            String permission = category + ".permission.C2D_MESSAGE";
            Log.v((String)TAG, (String)"Registering retry receiver");
            sRetryReceiverContext = context;
            sRetryReceiverContext.registerReceiver((BroadcastReceiver)sRetryReceiver, filter, permission, null);
        }
    }

    static synchronized void setRetryReceiverClassName(String className) {
        Log.v((String)TAG, (String)("Setting the name of retry receiver class to " + className));
        sRetryReceiverClassName = className;
    }

    public static String getRegistrationId(Context context) {
        SharedPreferences prefs = GCMRegistrar.getGCMPreferences(context);
        String registrationId = prefs.getString(PROPERTY_REG_ID, "");
        int oldVersion = prefs.getInt(PROPERTY_APP_VERSION, Integer.MIN_VALUE);
        int newVersion = GCMRegistrar.getAppVersion(context);
        if (oldVersion != Integer.MIN_VALUE && oldVersion != newVersion) {
            Log.v((String)TAG, (String)("App version changed from " + oldVersion + " to " + newVersion + "; resetting registration id"));
            GCMRegistrar.clearRegistrationId(context);
            registrationId = "";
        }
        return registrationId;
    }

    public static boolean isRegistered(Context context) {
        return GCMRegistrar.getRegistrationId(context).length() > 0;
    }

    static String clearRegistrationId(Context context) {
        return GCMRegistrar.setRegistrationId(context, "");
    }

    static String setRegistrationId(Context context, String regId) {
        SharedPreferences prefs = GCMRegistrar.getGCMPreferences(context);
        String oldRegistrationId = prefs.getString(PROPERTY_REG_ID, "");
        int appVersion = GCMRegistrar.getAppVersion(context);
        Log.v((String)TAG, (String)("Saving regId on app version " + appVersion));
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(PROPERTY_REG_ID, regId);
        editor.putInt(PROPERTY_APP_VERSION, appVersion);
        editor.commit();
        return oldRegistrationId;
    }

    public static void setRegisteredOnServer(Context context, boolean flag) {
        SharedPreferences prefs = GCMRegistrar.getGCMPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean(PROPERTY_ON_SERVER, flag);
        long lifespan = GCMRegistrar.getRegisterOnServerLifespan(context);
        long expirationTime = System.currentTimeMillis() + lifespan;
        Log.v((String)TAG, (String)("Setting registeredOnServer status as " + flag + " until " + new Timestamp(expirationTime)));
        editor.putLong(PROPERTY_ON_SERVER_EXPIRATION_TIME, expirationTime);
        editor.commit();
    }

    public static boolean isRegisteredOnServer(Context context) {
        SharedPreferences prefs = GCMRegistrar.getGCMPreferences(context);
        boolean isRegistered = prefs.getBoolean(PROPERTY_ON_SERVER, false);
        Log.v((String)TAG, (String)("Is registered on server: " + isRegistered));
        if (isRegistered) {
            long expirationTime = prefs.getLong(PROPERTY_ON_SERVER_EXPIRATION_TIME, -1L);
            if (System.currentTimeMillis() > expirationTime) {
                Log.v((String)TAG, (String)("flag expired on: " + new Timestamp(expirationTime)));
                return false;
            }
        }
        return isRegistered;
    }

    public static long getRegisterOnServerLifespan(Context context) {
        SharedPreferences prefs = GCMRegistrar.getGCMPreferences(context);
        long lifespan = prefs.getLong(PROPERTY_ON_SERVER_LIFESPAN, 604800000L);
        return lifespan;
    }

    public static void setRegisterOnServerLifespan(Context context, long lifespan) {
        SharedPreferences prefs = GCMRegistrar.getGCMPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(PROPERTY_ON_SERVER_LIFESPAN, lifespan);
        editor.commit();
    }

    private static int getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Coult not get package name: " + (Object)((Object)e));
        }
    }

    static void resetBackoff(Context context) {
        Log.d((String)TAG, (String)("Resetting backoff for " + context.getPackageName()));
        GCMRegistrar.setBackoff(context, 3000);
    }

    static int getBackoff(Context context) {
        SharedPreferences prefs = GCMRegistrar.getGCMPreferences(context);
        return prefs.getInt(BACKOFF_MS, 3000);
    }

    static void setBackoff(Context context, int backoff) {
        SharedPreferences prefs = GCMRegistrar.getGCMPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(BACKOFF_MS, backoff);
        editor.commit();
    }

    private static SharedPreferences getGCMPreferences(Context context) {
        return context.getSharedPreferences(PREFERENCES, 0);
    }

    private GCMRegistrar() {
        throw new UnsupportedOperationException();
    }
}

