package com.sakura.momo.ui.register;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.sakura.momo.comon.api.ApiUtils;
import com.sakura.momo.comon.game.BaseDialogWebFragment;
import com.sakura.momo.comon.game.BaraSdk;
import com.sakura.momo.comon.js.JsBase;
import com.sakura.momo.comon.js.JsRegister;
import com.sakura.momo.comon.listener.ILoginListener;
import com.sakura.momo.comon.listener.IWebViewClientListener;
import com.sakura.momo.comon.tracking.SakuraTracking;
import com.quby.R;

public class RegistryFragment extends BaseDialogWebFragment implements IWebViewClientListener {

    ILoginListener registerListener;
  static String urlRegister="";

    public static RegistryFragment newInstance(ILoginListener registerListener) {
        RegistryFragment frag = new RegistryFragment();
        Bundle args = new Bundle();
        String url = ApiUtils.getUrlWvRegister(BaraSdk.getInstance().getApplication());
        urlRegister=url;
        Log.d(RegistryFragment.class.getSimpleName(), "url: "+ url);
        args.putString(URL_WEBVIEW, url);
        frag.setArguments(args);
        frag.setRegisterListener(registerListener);
        return frag;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setTitleForm(getResources().getString(R.string.title_header_registry));
    }

    @Override
    protected JsBase getJsHandler() {
        return new JsRegister(new JsRegister.Listener() {
            @Override
            public void onCloseWindow() {
                dismiss();
            }

            @Override
            public void onOpenWindow() {

            }

            @Override
            public void onBackToWindow() {
                goBack();
            }

            @Override
            public void onRegisterSuccess(String param) {
                if (registerListener != null)
                    registerListener.onRegisterSuccess(param);
            }
        });
    }

    @Override
    protected IWebViewClientListener getWebListener() {
        return this;
    }

    public void setRegisterListener(ILoginListener registerListener) {
        this.registerListener = registerListener;
    }

    @Override
    public void shouldOverrideUrlLoading(WebView view, String url) {

    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (url.contains("checkScreen=register")) {
            SakuraTracking.getInstance().trackRegisterSubmitForm();
        }
    }

    @Override
    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {

    }

    @Override
    public void onPageFinished(WebView view, String url) {
        if (urlRegister.equals(ApiUtils.getUrlWvRegister(mActivity))) {
            SakuraTracking.getInstance().trackRegisterLoadSuccess();
        }
    }
}
