package com.sakura.momo.ui.login.term;

import android.os.Bundle;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.sakura.momo.comon.game.BaseDialogWebFragment;
import com.sakura.momo.comon.js.JsBase;
import com.sakura.momo.comon.js.JsTerm;
import com.sakura.momo.comon.listener.IWebViewClientListener;
import com.quby.R;

public class TermDialogFragment extends BaseDialogWebFragment {


    public static TermDialogFragment newInstance(String url) {
        TermDialogFragment frag = new TermDialogFragment();
        Bundle args = new Bundle();
        args.putString(URL_WEBVIEW, url);
        frag.setArguments(args);
        return frag;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setTitleForm(getString(R.string.title_webview_term));
    }

    @Override
    protected JsBase getJsHandler() {
        return new JsTerm(new JsTerm.Listener() {
            @Override
            public void onCloseWindow() {
                dismiss();
            }

            @Override
            public void onOpenWindow() {

            }

            @Override
            public void onBackToWindow() {
                goBack();
            }
        });
    }

    @Override
    protected IWebViewClientListener getWebListener() {
        return null;
    }
}
