package com.sakura.momo.comon.js.command;

import android.app.Activity;
import android.widget.Toast;

import com.sakura.momo.comon.object.BaseObj;
import com.sakura.momo.comon.presenter.BaseView;
import com.sakura.momo.comon.utils.DialogUtils;
import com.sakura.momo.comon.utils.LogUtils;
import com.sakura.momo.comon.utils.ToastUtils;
import com.sakura.momo.comon.utils.Utils;
import com.sakura.momo.ui.other.GamePresenterImpl;
import com.sakura.momo.ui.other.IGamePresenter;
import com.facebook.AccessToken;
import com.quby.R;
import com.bara.component.FacebookManager;
import com.bara.gui.dialog.SakuraDialogStartWebFragment;
import com.bara.gui.dialog.SakuraDialogWebviewFragment;
import com.bara.utils.Res;

import java.util.HashMap;
import java.util.Set;


public final class CmdLogin {

    private static final String TAG = CmdLogin.class.getSimpleName();
    private static CmdLogin INSTANCE;

    private CmdLogin() {
    }

    public static CmdLogin getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdLogin();
        }
        return INSTANCE;
    }

    public void upgradeFacebook(final Activity activity, final SakuraDialogWebviewFragment webDialogFragment, final SakuraDialogStartWebFragment dialogStartWebFragment, String params) {

        FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback() {

            @Override
            public void onSuccess(AccessToken accessToken,
                                  Set<String> recentlyGrantedPermissions,
                                  Set<String> recentlyDeniedPermissions) {

                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("fb_token", accessToken.getToken());

                    IGamePresenter iGamePresenter = new GamePresenterImpl(new BaseView() {
                        @Override
                        public void showProgress(String message) {
                            Utils.showLoading(activity, true);
                        }

                        @Override
                        public void hideProgress() {
                            Utils.showLoading(activity, false);
                        }

                        @Override
                        public void success(Object x) {
                            if (x instanceof BaseObj) {
                                DialogUtils.showInfoDialog(activity, "", ((BaseObj) x).getMessage(), new DialogUtils.DlgListener() {
                                    @Override
                                    public void onOK() {
                                        if (webDialogFragment != null)
                                            webDialogFragment.dismiss();
                                        if (dialogStartWebFragment != null)
                                            dialogStartWebFragment.dismiss();
                                    }
                                });
                            }
                        }

                        @Override
                        public void error(Object o) {
                            if (o instanceof BaseObj) {
                                DialogUtils.showErrorDialog(activity, ((BaseObj) o).getMessage());
                            }
                        }
                    });
                    iGamePresenter.connectFaceBook(accessToken.getToken());
                } catch (Exception e) {
                    handleException(activity, Res.string(activity, R.string.something_went_wrong));
                }

            }

            @Override
            public void onCancel() {

            }

            @Override
            public void onError(Throwable t) {
                LogUtils.d("LoginFB", t.getMessage());
                ToastUtils.showShortToast(activity,activity.getString(R.string.err_connect_facebook));
            }

        });
    }


    private void handleException(final Activity activity, final String message) {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(activity, message, Toast.LENGTH_LONG).show();
            }
        });


    }

}
