package com.sakura.momo.comon.js;

import android.app.Activity;
import android.util.Log;
import android.webkit.JavascriptInterface;

import com.sakura.momo.comon.js.command.CmdDashboard;
import com.sakura.momo.comon.js.command.CmdLogin;
import com.sakura.momo.comon.utils.ToastUtils;
import com.bara.gui.dialog.SakuraDialogStartWebFragment;
import com.bara.gui.dialog.SakuraDialogWebviewFragment;
import com.bara.gui.dialog.SakuraHaveBackButtonFragment;

public class JsHandler {

    private static String TAG = JsHandler.class.getSimpleName();

    private Activity activity;

    private SakuraHaveBackButtonFragment webDialogHaveBackButton;
    private SakuraDialogWebviewFragment dialogWebviewFragment;
    private SakuraDialogStartWebFragment dialogStartWebFragment;

    private enum switchCommandJS {
        //SDK 5.0 ----------------------------------------------------------------------------------
        cDaFOhByeo,
        ErPbtpPz,
        lbfNQzQc,
        SRAWoDvA,
        bpmyEufN,
        nQENmzOB,
        RrqdKqWr,
        utLixaAg,
        FJHVOVxc,
        FwLaIJnY,
        DRmsOkTS,
        WLUwpOBa,
        copyToClipboard,
        TyTUhwJU,
        qeQVXUMJ,
        khjhwXak,
        WGzwTLGO,
        ODRZwsHJ,
    }

    public JsHandler(Activity activity) {
        this.activity = activity;
    }

    public JsHandler(Activity activity, SakuraDialogWebviewFragment dialogWebviewFragment) {
        this.activity = activity;
        this.dialogWebviewFragment = dialogWebviewFragment;
    }

    public JsHandler(Activity activity, SakuraDialogStartWebFragment dialogStartWebFragment) {
        this.activity = activity;
        this.dialogStartWebFragment = dialogStartWebFragment;
    }


    public JsHandler(Activity activity, SakuraHaveBackButtonFragment webDialogHaveBackButton) {
        this.activity = activity;
        this.webDialogHaveBackButton = webDialogHaveBackButton;
    }


    @JavascriptInterface
    public void mobAppSDKexecute(String command, String params) {
        try {
            Log.i(TAG, " AppSDKexecute: command = " + command + "; params = " + params);

            switch (switchCommandJS.valueOf(command)) {

                /**********  PAYMENT  **********/

                case nQENmzOB:
                    CmdDashboard.getInstance().openContact(activity, params);
                    break;
                case RrqdKqWr:
                    CmdDashboard.getInstance().openBrowser(activity, params);
                    break;
                case SRAWoDvA:
                    CmdDashboard.getInstance().openFBFanpage(activity, params);
                    break;

                case bpmyEufN:
                    CmdDashboard.getInstance().openFBGroup(activity, params);
                    break;
                case utLixaAg:
                    CmdDashboard.getInstance().makePhoneCall(activity, params);
                    break;
                case copyToClipboard:
                    CmdDashboard.getInstance().mobCopyToClipboard(activity, params);
                    break;
                case FwLaIJnY:
                    CmdDashboard.getInstance().selectImage2(activity, dialogWebviewFragment, params);
                    break;
                case FJHVOVxc:
                    CmdDashboard.getInstance().getIssue(activity, dialogWebviewFragment, params);
                    break;
                case DRmsOkTS:
//                    CmdDashboard.getInstance().deleteImageData(activity, webFragment, params);
                    break;
                case WLUwpOBa:
                    CmdDashboard.getInstance().clearImageData(activity);
                    break;
                case khjhwXak:
//                    dialogWebviewFragment.dismiss();
                    CmdDashboard.getInstance().refreshBugForm(activity, params, dialogWebviewFragment);
                    break;
                case qeQVXUMJ:
                    CmdDashboard.getInstance().chooseFriend(activity, params);
                    break;
                case TyTUhwJU:
                    CmdDashboard.getInstance().openDialogWebView(activity, params);
                    break;
                case ODRZwsHJ:
                    CmdDashboard.getInstance().trackingFromWeb(activity, params);
                    break;
                case ErPbtpPz:
                    CmdLogin.getInstance().upgradeFacebook(activity, dialogWebviewFragment, dialogStartWebFragment, params);
                    break;
                case lbfNQzQc:
                    ToastUtils.showShortToast(activity, " updateSuccess Cho cả connect fb và update profile");
                default:
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}