package com.sakura.momo.comon.game;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import androidx.annotation.Nullable;
import android.text.TextUtils;

import com.appsflyer.AppsFlyerLib;
import com.sakura.momo.comon.api.ErrorCode;
import com.sakura.momo.comon.config.GameConfigs;
import com.sakura.momo.comon.constants.Constants;
import com.sakura.momo.ui.login.ILoginPresenter;
import com.sakura.momo.ui.login.LoginPresenterImpl;
import com.sakura.momo.comon.object.UserObj;
import com.sakura.momo.comon.object.err.SdkConfigErrObj;
import com.sakura.momo.comon.object.err.UserErrObj;
import com.sakura.momo.comon.object.response.SdkConfigResponseObj;
import com.sakura.momo.comon.object.response.UserResponseObj;
import com.sakura.momo.comon.presenter.BaseView;
import com.sakura.momo.comon.sharePref.PrefManager;
import com.sakura.momo.comon.tracking.SakuraTracking;
import com.sakura.momo.comon.utils.DialogUtils;
import com.sakura.momo.comon.utils.LogUtils;
import com.sakura.momo.comon.utils.ToastUtils;
import com.sakura.momo.comon.utils.Utils;
import com.bara.SakuraSDK;
import com.quby.R;


public class LifeCycleActivity implements BaseView {
    public static LifeCycleActivity manCTActivity;
    Activity activity;
    boolean isFirstLauch;
    ILoginPresenter loginPresenter;

    public static LifeCycleActivity getInstance(Activity activity) {
        if (manCTActivity == null)
            manCTActivity = new LifeCycleActivity(activity);
        return manCTActivity;
    }

    public LifeCycleActivity(Activity activity) {
        isFirstLauch = true;
        this.activity = activity;
        loginPresenter = new LoginPresenterImpl(this);
    }


    public void onCreate() {
        if (GameConfigs.getInstance().getUser() != null && GameConfigs.getInstance().isLogin()) {
            loginPresenter.getUser();
        } else {
            isFirstLauch = false;
        }
    }

    public void onStart() {
    }


    public void onResume() {
        if (isFirstLauch) {
            return;
        }
        if (!TextUtils.isEmpty(PrefManager.getAccessToken(activity))) {
            loginPresenter = new LoginPresenterImpl(this);
            loginPresenter.getUser();
        }
    }

    public void onPause() {
    }

    public void onStop() {
    }

    public void onDestroy() {
    }

    public void onWindowFocusChanged(boolean hasFocus) {
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
    }


    @Override
    public void showProgress(String mess) {
        Utils.showLoading(activity, true);
    }

    @Override
    public void hideProgress() {
        Utils.showLoading(activity, false);
    }

    @Override
    public void success(Object x) {
        if (x instanceof UserResponseObj) {
            UserObj obj = ((UserResponseObj) x).getData();
            GameConfigs.getInstance().setUser(obj);
            if (isFirstLauch)
                loginPresenter.getSdkConfig();
            LogUtils.d("LifeCycleActivity", "User valid");
        } else if (x instanceof SdkConfigResponseObj) {
            try {
                isFirstLauch = false;
                SdkConfigResponseObj obj = (SdkConfigResponseObj) x;
                GameConfigs.getInstance().setSdkConfig(obj.getData());
                if (obj != null && obj.getData() != null && obj.getData().getMaintenance() != null && !TextUtils.isEmpty(obj.getData().getMaintenance().getUrl())) {
                    SakuraTracking.getInstance().trackMaintainScreenOpened();
                    SakuraSDK.getInstance().getQueuePopups().add(SakuraSDK.POPUP_MAINTAIN);
                    SakuraSDK.getInstance().showPopup();
                    return;
                }
                AppsFlyerLib.getInstance().setCustomerUserId(GameConfigs.getInstance().getUser().getId() + "");
                BaraSdk.getInstance().onLoginSuccess(activity, "login");
                LogUtils.d("LifeCycleActivity", "get game info success");
            } catch (Exception e) {
                LogUtils.d("LifeCycleActivity", e.getMessage());
            }
        }
    }

    @Override
    public void error(Object o) {
        if (o instanceof UserErrObj) {
            UserErrObj obj = (UserErrObj) o;
            if (obj.getStatus() == Constants.USER_ERR_CODE.INVALID_TOKEN) {
                DialogUtils.showExpireDialog(activity);
            } else {
                if (obj.getStatus() == ErrorCode.NO_INTERNET)
                    ToastUtils.showShortToast(activity, activity.getString(R.string.error_network));
                DialogUtils.showRetryDialog(activity, obj.getMessage(), new DialogUtils.Listener() {
                    @Override
                    public void onRetry() {
                        onResume();
                    }
                });
            }
        } else if (o instanceof SdkConfigErrObj) {
            SdkConfigErrObj obj = (SdkConfigErrObj) o;
            if (obj.getStatus() == Constants.USER_ERR_CODE.INVALID_TOKEN) {
                DialogUtils.showExpireDialog(activity);
            } else {
                if (obj.getStatus() == ErrorCode.NO_INTERNET) {
                    DialogUtils.showRetryDialog(activity, activity.getString(R.string.error_network), new DialogUtils.Listener() {
                        @Override
                        public void onRetry() {
                            ILoginPresenter loginPresenter = new LoginPresenterImpl(LifeCycleActivity.this);
                            loginPresenter.getSdkConfig();
                        }
                    });
                } else {
                    DialogUtils.showRetryDialogWithLogOut(activity, obj.getMessage(), new DialogUtils.Listener() {
                        @Override
                        public void onRetry() {
                            ILoginPresenter loginPresenter = new LoginPresenterImpl(LifeCycleActivity.this);
                            loginPresenter.getSdkConfig();
                        }
                    });
                }
            }
        }
    }
}
