package com.sakura.momo.comon.game;

import android.app.Activity;
import android.app.Application;
import android.app.DialogFragment;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;

import com.appsflyer.AppsFlyerLib;
import com.sakura.momo.comon.api.RetrofitClient;
import com.sakura.momo.comon.cmd.CmdPaymentV3;
import com.sakura.momo.comon.config.AuthenConfigs;
import com.sakura.momo.comon.config.GameConfigs;
import com.sakura.momo.comon.constants.Constants;
import com.sakura.momo.comon.utils.DeviceUtils;
import com.sakura.momo.ui.block.BlockFragment;
import com.sakura.momo.ui.login.ILoginPresenter;
import com.sakura.momo.ui.login.LoginFragment;
import com.sakura.momo.ui.login.LoginPresenterImpl;
import com.sakura.momo.ui.notification.HanaFirebaseMessagingService;
import com.sakura.momo.ui.other.GamePresenterImpl;
import com.sakura.momo.ui.other.IGamePresenter;
import com.sakura.momo.ui.payment.PaymentNativeFragment;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.sakura.momo.comon.listener.IBlockIpListener;
import com.sakura.momo.comon.listener.ILoginListener;
import com.sakura.momo.comon.listener.ILogoutListener;
import com.sakura.momo.comon.listener.IMesssageListener;
import com.sakura.momo.comon.listener.IPaymentListener;
import com.sakura.momo.comon.listener.ISaveCharactorListener;
import com.sakura.momo.comon.login.FacebookManager;
import com.sakura.momo.comon.login.GoogleManager;
import com.sakura.momo.comon.object.AuthenConfigObj;
import com.sakura.momo.comon.object.BaseObj;
import com.sakura.momo.comon.object.MessInGameObj;
import com.sakura.momo.comon.object.PurchaseHistoryObj;
import com.sakura.momo.comon.object.VerifyPurchaseObj;
import com.sakura.momo.comon.object.response.AuthenConfigResponseObj;
import com.sakura.momo.comon.object.response.MessInGameResponseObj;
import com.sakura.momo.comon.presenter.BaseView;
import com.sakura.momo.comon.sharePref.PrefManager;
import com.sakura.momo.comon.tracking.SakuraTracking;
import com.sakura.momo.comon.utils.LogUtils;
import com.sakura.momo.comon.utils.ToastUtils;
import com.sakura.momo.comon.utils.Utils;
import com.bara.SakuraHelper;
import com.bara.SakuraSDK;
import com.quby.R;

import java.util.ArrayList;
import java.util.Timer;

import static com.facebook.login.widget.ProfilePictureView.TAG;

public class BaraSdk implements IBaraSdk {
    private static Application sApp;
    private static BaraSdk TaunSdk;
    private static SakuraSDK sakuraSDK;
    Handler mHandler;
    Runnable mRunable;
    private Timer timerAsync;
    private BlockFragment dialogFragment;


    public Application getApplication() {
        return sApp;
    }

    public static BaraSdk getInstance() {
        if (TaunSdk == null) {
            TaunSdk = new BaraSdk();
            sakuraSDK = SakuraSDK.getInstance();
        }
        return TaunSdk;
    }

    public void initSdk(Activity activity) {
        sakuraSDK.init(activity);
        DeviceUtils.initAdvertising(activity, new DeviceUtils.Listener() {
            @Override
            public void onGetAds() {
            }
        });
        checkIpRequest(activity);
    }

    public void init(@NonNull Application application, String appkey, String facebookId) {
        sApp = application;

        //New SDK init
        SakuraTracking.getInstance().init(sApp);
        SakuraTracking.getInstance().trackAppLaunch();
        SakuraTracking.getInstance().trackLastSession(sApp);

        //init GameConfig
        GameConfigs.getInstance().setAppKey(appkey);
        GameConfigs.getInstance().initFacebook(facebookId);
        mHandler = new Handler();

        timerAsync = new Timer();
    }

    public void login(Activity activity, ILoginListener listener) {
        //check authen config , if not exit , will not show login dialog
        if (GameConfigs.getInstance().isLogin()) {
            String mess = activity.getResources().getString(R.string.lbl_already_login);
            ToastUtils.showShortToast(activity, mess);
            return;
        }
        ILoginPresenter pr = new LoginPresenterImpl(new BaseView() {
            @Override
            public void showProgress(String message) {
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        Utils.showLoading(activity, true);
                    }
                });

            }

            @Override
            public void hideProgress() {
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        Utils.showLoading(activity, false);
                    }
                });

            }

            @Override
            public void success(Object x) {
                if (x instanceof AuthenConfigResponseObj) {
                    AuthenConfigObj obj = ((AuthenConfigResponseObj) x).getData();
                    AuthenConfigs.getInstance().setAuthenConfigObj(obj);
                }
                showFormLogin(activity, new ILoginListener() {
                    @Override
                    public void onLoginSuccess() {
                        AppsFlyerLib.getInstance().setCustomerUserId(GameConfigs.getInstance().getUser().getId() + "");
                        saveFCM(activity);
                        if (listener != null)
                            listener.onLoginSuccess();

                        Log.d(TAG, "userId : " + GameConfigs.getInstance().getUser().getId());
                    }

                    @Override
                    public void onRegisterSuccess(String param) {

                    }
                });
            }

            @Override
            public void error(Object o) {
                showFormLogin(activity, listener);
            }
        });
        pr.getAuthenConfig();
    }

    public void showFormLogin(Activity activity, ILoginListener listener) {
        if (mHandler != null && mRunable != null) {
            mHandler.removeCallbacks(mRunable);
        }
        mRunable = new Runnable() {
            @Override
            public void run() {
                DialogFragment newFragment = (DialogFragment) activity.getFragmentManager().findFragmentByTag(LoginFragment.class.getSimpleName());
                if (newFragment == null)
                    newFragment = LoginFragment.newInstance(listener);
                newFragment.setCancelable(false);
                if (newFragment.getDialog() != null && newFragment.getDialog().isShowing())
                    return;
                newFragment.show(activity.getFragmentManager(), LoginFragment.class.getSimpleName());
            }
        };
        mHandler.postDelayed(mRunable, 200);

    }

    public void logOut(Activity activity) {
        sakuraSDK.logout();
        if (GameConfigs.getInstance().getUser() != null || GameConfigs.getInstance().isLogin()) {
            if (GameConfigs.getInstance().getUser() != null)
                SakuraTracking.getInstance().trackLogoutSuccess(GameConfigs.getInstance().getUser().getId());
            RetrofitClient.clearInstant();
            GameConfigs.clearInstance();
            GoogleManager.getInstance(sApp).logout();
            FacebookManager.getInstance(sApp).logout();
            PrefManager.saveBoolean(sApp, Constants.SAVE_FCM_NON_TOKEN + AuthenConfigs.getInstance().getAccessToken(), false);
            PrefManager.saveSetting(sApp, Constants.ROLE_ID, "");
            PrefManager.saveSetting(sApp, Constants.AREA_ID, "");
            PrefManager.saveAccessToken(sApp, "");
            AppsFlyerLib.getInstance().setCustomerUserId("");
            SakuraHelper.hideNotiFloatButton();
            SakuraSDK.getInstance().logout();
            String mess = activity.getResources().getString(R.string.lbl_log_out_success);
            ToastUtils.showShortToast(activity, mess);
        } else {
            String mess = activity.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showShortToast(activity, mess);
        }
    }

    public void logOut(Activity activity, ILogoutListener logoutListener) {
        logOut(activity);
        if (logoutListener != null)
            logoutListener.onLogoutSuccess();
    }

    public void onLoginSuccess(Activity activity, String tab) {
        if (GameConfigs.getInstance().getUser() != null && GameConfigs.getInstance().getUser().getName() != null) {
            String name = GameConfigs.getInstance().getUser().getName();
            name = TextUtils.isEmpty(name) ? "" : (" " + name + "!");
            String mess = activity.getResources().getString(R.string.welcome) + name;
            ToastUtils.showShortToast(activity, mess);
        }
        if (GameConfigs.getInstance().getSdkConfig() != null) {
            SakuraHelper.showNotiFloatButton(GameConfigs.getInstance().getSdkConfig().getEx());
        }


    }

    public void getMessagesInGame(Activity activity, IMesssageListener messsageListener) {
        if (!GameConfigs.getInstance().isLogin()) {
            String mess = activity.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showShortToast(activity, mess);
            return;
        }
        IGamePresenter gamePresenter = new GamePresenterImpl(new BaseView() {
            @Override
            public void showProgress(String mess) {
                Utils.showLoading(activity, true);
            }

            @Override
            public void hideProgress() {
                Utils.showLoading(activity, false);
            }

            @Override
            public void success(Object x) {
                if (x instanceof MessInGameResponseObj && messsageListener != null) {
                    ArrayList<MessInGameObj> obj = ((MessInGameResponseObj) x).getData();
                    if (obj != null && obj.size() > 0)
                        messsageListener.onSuccess(obj);
                }

            }

            @Override
            public void error(Object o) {
                BaseObj baseObj = (BaseObj) o;
                ToastUtils.showShortToast(activity, baseObj.getMessage());
            }
        });
        gamePresenter.getMessagesInGame();
    }


    @Override
    public void saveCharacter(Activity activity, String roleId, String areaId, ISaveCharactorListener listener) {
        if (!GameConfigs.getInstance().isLogin()) {
            String mess = activity.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showShortToast(activity, mess);
            return;
        }
        PrefManager.saveSetting(activity, Constants.ROLE_ID, roleId);
        PrefManager.saveSetting(activity, Constants.AREA_ID, areaId);
        LogUtils.d(TAG, "ROLE_ID :" + roleId);
        LogUtils.d(TAG, "AREA_ID :" + roleId);

        LogUtils.d("saveCharacter", "ROLE_ID :" + roleId + " - AREA_ID :" + roleId);

        IGamePresenter gamePresenter = new GamePresenterImpl(new BaseView() {
            @Override
            public void showProgress(String mess) {
                Utils.showLoading(activity, true);
            }

            @Override
            public void hideProgress() {
                Utils.showLoading(activity, false);
            }

            @Override
            public void success(Object x) {
                if (x instanceof BaseObj && listener != null) {
                    SakuraTracking.getInstance().trackCharactorCreatedSuccess(GameConfigs.getInstance().getUser().getId(), roleId, areaId);
           /*         SdkConfigObj.Pop pop = GameConfigs.getInstance().getPopup();
                    if (pop != null && !TextUtils.isEmpty(pop.getUrl())) {
                        QubySDK.getInstance().getQueuePopups().add(QubySDK.POPUP_LINK);
                        QubySDK.getInstance().showPopup();
                    }*/
                    listener.onSuccess();
                }
            }

            @Override
            public void error(Object o) {
                BaseObj baseObj = (BaseObj) o;
                ToastUtils.showShortToast(activity, baseObj.getMessage());
                SakuraTracking.getInstance().trackCharactorCreatedFailed(GameConfigs.getInstance().getUser().getId(), roleId, areaId);
            }
        });
        SakuraTracking.getInstance().trackCharactorCreated(activity, GameConfigs.getInstance().getUser().getId(), roleId, areaId);
        try {
            gamePresenter.saveCharactor(roleId, areaId);
        } catch (Exception e) {
            LogUtils.d(TAG, e.getMessage());
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (sakuraSDK != null)
            sakuraSDK.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onDestroy() {
        if (sakuraSDK != null) {
            timerAsync.cancel();
            sakuraSDK.onDestroySDK();
        }
    }

    @Override
    public void shareImageToFacebook(Activity activity, Bitmap image) {
        if (sakuraSDK != null)
            sakuraSDK.shareImageToFacebook(activity, image);
    }

    @Override
    public void showTextScroll(ArrayList<MessInGameObj> listNoti) {
        if (sakuraSDK != null)
            sakuraSDK.showTextScroll(listNoti);
    }

    @Override
    public void onRequestPermissionsResult(Activity gameActivity, int requestCode, String[] permissions, int[] grantResults) {
        if (sakuraSDK != null)
            sakuraSDK.onRequestPermissionsResult(gameActivity, requestCode, permissions, grantResults);
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        if (sakuraSDK != null)
            sakuraSDK.onWindowFocusChanged(hasFocus);
    }

    @Override
    public void onBackPressed() {
        sakuraSDK.onBackPressed();
    }

    DialogFragment paymentNativeFragment;


    @Override
    public void payment(Activity activity, String state, IPaymentListener listener) {

        if (mHandler != null && mRunable != null) {
            mHandler.removeCallbacks(mRunable);
        }
        mRunable = new Runnable() {
            @Override
            public void run() {
                try {
                    Log.i(TAG, "payment:" + state);

                    if (!GameConfigs.getInstance().isLogin()) {
                        String mess = activity.getResources().getString(R.string.lbl_not_login);
                        ToastUtils.showShortToast(activity, mess);
                    } else {
                        String role_id = PrefManager.getString(activity, Constants.ROLE_ID, "");
                        String area_id = PrefManager.getString(activity, Constants.AREA_ID, "");
                        if (TextUtils.isEmpty(role_id) || TextUtils.isEmpty(area_id)) {
                            ToastUtils.showShortToast(activity, activity.getString(R.string.err_empty_charactor));
                            return;
                        }

                        paymentNativeFragment = (DialogFragment) activity.getFragmentManager().findFragmentByTag(PaymentNativeFragment.class.getSimpleName());

                        if (paymentNativeFragment == null) {
                            paymentNativeFragment = PaymentNativeFragment.newInstance(state, new PaymentNativeFragment.PaymentSuccess() {
                                @Override
                                public void onIapPaymentSuccess(PurchaseHistoryObj obj) {
                                    CmdPaymentV3.getInstance().verifyPayment(activity, obj, listener);
                                }

                                @Override
                                public void onLocalPaymentSuccess(VerifyPurchaseObj verifyPurchaseObj) {
                                    listener.onPaymentSuccess(verifyPurchaseObj);
                                }
                            });
                        }
                        if (paymentNativeFragment.getDialog() != null && paymentNativeFragment.getDialog().isShowing())
                            return;
                        paymentNativeFragment.show(activity.getFragmentManager(), PaymentNativeFragment.class.getSimpleName());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        mHandler.postDelayed(mRunable, 200);
    }

    public void checkIpRequest(Activity activity) {
        dialogFragment = (BlockFragment) activity.getFragmentManager().findFragmentByTag(BlockFragment.class.getSimpleName());
        if (dialogFragment == null) {
            dialogFragment = BlockFragment.newInstance(new IBlockIpListener() {
                @Override
                public void hideBlock() {
                    if (dialogFragment.getDialog() != null && dialogFragment.getDialog().isShowing()){
                        dialogFragment.dismiss();
                    }

                }
            });
        }
        dialogFragment.setCancelable(true);
        dialogFragment.show(activity.getFragmentManager(), BlockFragment.class.getSimpleName());


    }

    public void saveFCM(Activity activity) {
        if (GameConfigs.getInstance().isLogin() && !PrefManager.getBoolean(sApp, Constants.SAVE_FCM_NON_TOKEN + AuthenConfigs.getInstance().getAccessToken(), false)) {
            FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener(new OnSuccessListener<InstanceIdResult>() {
                @Override
                public void onSuccess(InstanceIdResult instanceIdResult) {
                    String firebaseToken = instanceIdResult.getToken();
                    LogUtils.d(TAG, "Firebase Token/regId: " + firebaseToken);

                    if (GameConfigs.getInstance().getAppKey() != null && GameConfigs.getInstance().getUser() != null) {
                        int userId = GameConfigs.getInstance().getUser().getId();
                        HanaFirebaseMessagingService.getInstance().sendRegistrationToServer(activity, String.valueOf(userId), firebaseToken);
                    }
                }
            });
        } else if (!PrefManager.getBoolean(sApp, Constants.SAVE_FCM_NON_TOKEN, false)) {
            FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener(new OnSuccessListener<InstanceIdResult>() {
                @Override
                public void onSuccess(InstanceIdResult instanceIdResult) {
                    String firebaseToken = instanceIdResult.getToken();
                    LogUtils.d(TAG, "Firebase Token/regId: " + firebaseToken);
                    if (GameConfigs.getInstance().getAppKey() != null) {
                        HanaFirebaseMessagingService.getInstance().sendRegistrationToServer(activity, "", firebaseToken);
                    }
                }
            });

        }
    }
}
